<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
require_once("config.php");
require_once('include/utils/utils.php');
require_once('modules/Products/Products.php');
require_once('modules/Existencias/Existencias.php');
require_once('modules/Flota_renta/Flota_renta.php');
require_once('modules/Numeros_serie/Numeros_serie.php');
require_once('modules/Sucursales/Sucursales.php');
require_once('modules/Users/Users.php');
require_once("modules/Lineas/Lineas.php");
require_once("modules/Kardex/Kardex.php");
require_once("modules/Blocks_folios/Blocks_folios.php");

class Altas_flota_renta extends CRMEntity {
	var $db, $log; // Used in class functions of CRMEntity

	var $table_name = 'vtiger_altas_flota_renta';
	var $table_index= 'altas_flota_rentaid';
	var $column_fields = Array();

	/** Indicator if this is a custom module or standard module */
	var $IsCustomModule = true;

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_altas_flota_rentacf', 'altas_flota_rentaid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_altas_flota_renta', 'vtiger_altas_flota_rentacf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_altas_flota_renta'   => 'altas_flota_rentaid',
	    'vtiger_altas_flota_rentacf' => 'altas_flota_rentaid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Altas_flota_renta Name'=> Array('altas_flota_renta', 'idv'),
		'Assigned To' => Array('crmentity','smownerid')
	);
	var $list_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Altas_flota_renta Name'=> 'idv',
		'Assigned To' => 'assigned_user_id'
	);

	// Make the field link to detail view from list view (Fieldname)
	var $list_link_field = 'idv';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		//'Altas_flota_renta Name'=> Array('altas_flota_renta', 'idv')
		'Folio'=> Array('altas_flota_renta', 'folio'),
		'Sucursal'=> Array('altas_flota_renta', 'sucursal'),
		'Producto'=> Array('altas_flota_renta', 'producto'),
		'Cantidad'=> Array('altas_flota_renta', 'cantidad'),
		'Fecha efectiva'=> Array('altas_flota_renta', 'fecha_efectiva'),
	);
	var $search_fields_name = Array(
		/* Format: Field Label => fieldname */
		//'Altas_flota_renta Name'=> 'idv'
		'Folio'=> 'folio',
		'Sucursal'=> 'sucursal',
		'Producto'=> 'producto',
		'Cantidad'=> 'cantidad',
		'Fecha efectiva'=> 'fecha_efectiva',
	);

	// For Popup window record selection
	//var $popup_fields = Array('idv');
	var $popup_fields = Array('folio');

	// Placeholder for sort fields - All the fields will be initialized for Sorting through initSortFields
	var $sortby_fields = Array();

	// For Alphabetical search
	var $def_basicsearch_col = 'idv';

	// Column value to use on detail view record text display
	var $def_detailview_recname = 'idv';

	// Required Information for enabling Import feature
	var $required_fields = Array('idv'=>1);

	// Callback function list during Importing
	var $special_functions = Array('set_import_assigned_user');

	var $default_order_by = 'idv';
	var $default_sort_order='ASC';
	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('createdtime', 'modifiedtime', 'idv');
	
	function __construct() {
		global $log, $currentModule;
		$this->column_fields = getColumnFields($currentModule);
		$this->db = PearDatabase::getInstance();
		$this->log = $log;
	}

	function getSortOrder() {
		global $currentModule;

		$sortorder = $this->default_sort_order;
		if($_REQUEST['sorder']) $sortorder = $this->db->sql_escape_string($_REQUEST['sorder']);
		else if($_SESSION[$currentModule.'_Sort_Order']) 
			$sortorder = $_SESSION[$currentModule.'_Sort_Order'];

		return $sortorder;
	}

	function getOrderBy() {
		global $currentModule;
		
		$use_default_order_by = '';		
		if(PerformancePrefs::getBoolean('LISTVIEW_DEFAULT_SORTING', true)) {
			$use_default_order_by = $this->default_order_by;
		}
		
		$orderby = $use_default_order_by;
		if($_REQUEST['order_by']) $orderby = $this->db->sql_escape_string($_REQUEST['order_by']);
		else if($_SESSION[$currentModule.'_Order_By'])
			$orderby = $_SESSION[$currentModule.'_Order_By'];
		return $orderby;
	}

	function save_module($module) {
	}

	/**
	 * Return query to use based on given modulename, fieldname
	 * Useful to handle specific case handling for Popup
	 */
	function getQueryByModuleField($module, $fieldname, $srcrecord, $query='') {
		// $srcrecord could be empty
	}

	/**
	 * Get list view query (send more WHERE clause condition if required)
	 */
	function getListQuery($module, $usewhere='') {
		$query = "SELECT vtiger_crmentity.*, $this->table_name.*";
		
		// Keep track of tables joined to avoid duplicates
		$joinedTables = array();

		// Select Custom Field Table Columns if present
		if(!empty($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$query .= " FROM $this->table_name";

		$query .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		$joinedTables[] = $this->table_name;
		$joinedTables[] = 'vtiger_crmentity';
		
		// Consider custom table join as well.
		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index";
			$joinedTables[] = $this->customFieldTable[0]; 
		}
		$query .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";

		$joinedTables[] = 'vtiger_users';
		$joinedTables[] = 'vtiger_groups';
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($module));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);
		
		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other =  CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			if(!in_array($other->table_name, $joinedTables)) {
				$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
				$joinedTables[] = $other->table_name;
			}
		}

		global $current_user;
		$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
		$query .= "	WHERE vtiger_crmentity.deleted = 0 ".$usewhere;
		return $query;
	}

	/**
	 * Apply security restriction (sharing privilege) query part for List view.
	 */
	function getListViewSecurityParameter($module) {
		global $current_user;
		require('user_privileges/user_privileges_'.$current_user->id.'.php');
		require('user_privileges/sharing_privileges_'.$current_user->id.'.php');

		$sec_query = '';
		$tabid = getTabid($module);

		if($is_admin==false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 
			&& $defaultOrgSharingPermission[$tabid] == 3) {

				$sec_query .= " AND (vtiger_crmentity.smownerid in($current_user->id) OR vtiger_crmentity.smownerid IN 
					(
						SELECT vtiger_user2role.userid FROM vtiger_user2role 
						INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid 
						INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid 
						WHERE vtiger_role.parentrole LIKE '".$current_user_parent_role_seq."::%'
					) 
					OR vtiger_crmentity.smownerid IN 
					(
						SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per 
						WHERE userid=".$current_user->id." AND tabid=".$tabid."
					) 
					OR 
						(";
		
					// Build the query based on the group association of current user.
					if(sizeof($current_user_groups) > 0) {
						$sec_query .= " vtiger_groups.groupid IN (". implode(",", $current_user_groups) .") OR ";
					}
					$sec_query .= " vtiger_groups.groupid IN 
						(
							SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid 
							FROM vtiger_tmp_read_group_sharing_per
							WHERE userid=".$current_user->id." and tabid=".$tabid."
						)";
				$sec_query .= ")
				)";
		}
		return $sec_query;
	}

	/**
	 * Create query to export the records.
	 */
	function create_export_query($where)
	{
		global $current_user;
		$thismodule = $_REQUEST['module'];
		
		include("include/utils/ExportUtils.php");

		//To get the Permitted fields query and the permitted fields list
		$sql = getPermittedFieldsQuery($thismodule, "detail_view");
		
		$fields_list = getFieldsListFromQuery($sql);

		$query = "SELECT $fields_list, vtiger_users.user_name AS user_name 
					FROM vtiger_crmentity INNER JOIN $this->table_name ON vtiger_crmentity.crmid=$this->table_name.$this->table_index";

		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}

		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id and vtiger_users.status='Active'";
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($thismodule));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);

		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other = CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
		}

		$query .= $this->getNonAdminAccessControlQuery($thismodule,$current_user);
		$where_auto = " vtiger_crmentity.deleted=0";

		if($where != '') $query .= " WHERE ($where) AND $where_auto";
		else $query .= " WHERE $where_auto";

		return $query;
	}

	/**
	 * Initialize this instance for importing.
	 */
	function initImport($module) {
		$this->db = PearDatabase::getInstance();
		$this->initImportableFields($module);
	}

	/**
	 * Create list query to be shown at the last step of the import.
	 * Called From: modules/Import/UserLastImport.php
	 */
	function create_import_query($module) {
		global $current_user;
		$query = "SELECT vtiger_crmentity.crmid, case when (vtiger_users.user_name not like '') then vtiger_users.user_name else vtiger_groups.groupname end as user_name, $this->table_name.* FROM $this->table_name
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index
			LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=vtiger_crmentity.crmid
			LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			WHERE vtiger_users_last_import.assigned_user_id='$current_user->id'
			AND vtiger_users_last_import.bean_type='$module'
			AND vtiger_users_last_import.deleted=0";
		return $query;
	}

	/**
	 * Delete the last imported records.
	 */
	function undo_import($module, $user_id) {
		global $adb;
		$count = 0;
		$query1 = "select bean_id from vtiger_users_last_import where assigned_user_id=? AND bean_type='$module' AND deleted=0";
		$result1 = $adb->pquery($query1, array($user_id)) or die("Error getting last import for undo: ".mysql_error()); 
		while ( $row1 = $adb->fetchByAssoc($result1))
		{
			$query2 = "update vtiger_crmentity set deleted=1 where crmid=?";
			$result2 = $adb->pquery($query2, array($row1['bean_id'])) or die("Error undoing last import: ".mysql_error()); 
			$count++;			
		}
		return $count;
	}
	
	/**
	 * Transform the value while exporting
	 */
	function transform_export_value($key, $value) {
		return parent::transform_export_value($key, $value);
	}

	/**
	 * Function which will set the assigned user id for import record.
	 */
	function set_import_assigned_user()
	{
		global $current_user, $adb;
		$record_user = $this->column_fields["assigned_user_id"];
		
		if($record_user != $current_user->id){
			$sqlresult = $adb->pquery("select id from vtiger_users where id = ? union select groupid as id from vtiger_groups where groupid = ?", array($record_user, $record_user));
			if($this->db->num_rows($sqlresult)!= 1) {
				$this->column_fields["assigned_user_id"] = $current_user->id;
			} else {			
				$row = $adb->fetchByAssoc($sqlresult, -1, false);
				if (isset($row['id']) && $row['id'] != -1) {
					$this->column_fields["assigned_user_id"] = $row['id'];
				} else {
					$this->column_fields["assigned_user_id"] = $current_user->id;
				}
			}
		}
	}
	
	/** 
	 * Function which will give the basic query to find duplicates
	 */
	function getDuplicatesQuery($module,$table_cols,$field_values,$ui_type_arr,$select_cols='') {
		$select_clause = "SELECT ". $this->table_name .".".$this->table_index ." AS recordid, vtiger_users_last_import.deleted,".$table_cols;

		// Select Custom Field Table Columns if present
		if(isset($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$from_clause = " FROM $this->table_name";

		$from_clause .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		// Consider custom table join as well.
		if(isset($this->customFieldTable)) {
			$from_clause .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}
		$from_clause .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
						LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		
		$where_clause = "	WHERE vtiger_crmentity.deleted = 0";
		$where_clause .= $this->getListViewSecurityParameter($module);
					
		if (isset($select_cols) && trim($select_cols) != '') {
			$sub_query = "SELECT $select_cols FROM  $this->table_name AS t " .
				" INNER JOIN vtiger_crmentity AS crm ON crm.crmid = t.".$this->table_index;
			// Consider custom table join as well.
			if(isset($this->customFieldTable)) {
				$sub_query .= " LEFT JOIN ".$this->customFieldTable[0]." tcf ON tcf.".$this->customFieldTable[1]." = t.$this->table_index";
			}
			$sub_query .= " WHERE crm.deleted=0 GROUP BY $select_cols HAVING COUNT(*)>1";	
		} else {
			$sub_query = "SELECT $table_cols $from_clause $where_clause GROUP BY $table_cols HAVING COUNT(*)>1";
		}	
		
		
		$query = $select_clause . $from_clause .
					" LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=" . $this->table_name .".".$this->table_index .
					" INNER JOIN (" . $sub_query . ") AS temp ON ".get_on_clause($field_values,$ui_type_arr,$module) .
					$where_clause .
					" ORDER BY $table_cols,". $this->table_name .".".$this->table_index ." ASC";
					
		return $query;		
	}

	/**
	 * Invoked when special actions are performed on the module.
	 * @param String Module name
	 * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
	 */
	function vtlib_handler($modulename, $event_type) {
		if($event_type == 'module.postinstall') {
			// TODO Handle post installation actions
		} else if($event_type == 'module.disabled') {
			// TODO Handle actions when this module is disabled.
		} else if($event_type == 'module.enabled') {
			// TODO Handle actions when this module is enabled.
		} else if($event_type == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($event_type == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($event_type == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
	}

	/** 
	 * Handle saving related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	// function save_related_module($module, $crmid, $with_module, $with_crmid) { }
	
	/**
	 * Handle deleting related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function delete_related_module($module, $crmid, $with_module, $with_crmid) { }

	/**
	 * Handle getting related list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_related_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	/**
	 * Handle getting dependents list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_dependents_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }
	function procesar($ns)
	{
                // La sesión se abre no aquí sino en el programa que manda llamar esta función. De esto depende poder cargar el usuario actual.

                global $current_user, $adb;

                // Carga definiciones de campos personalizados.
                require("campos_personalizados.php");

                //$id_alta = (int)$this->column_fields["record_id"];
                $id_alta = (int)$this->id;
//echo "id alta:";
//var_dump($id_alta);
//echo "id:";
//var_dump($this->id);
                $folio_alta = $this->column_fields["folio"];

		// Obtiene la sucursal.
		$sucursal = new Sucursales;
		$sucursal->retrieve_entity_info($this->column_fields["sucursal"], "Sucursales");

		// Obtiene el producto.
		$producto_actual = new Products;
		$producto_actual->retrieve_entity_info($this->column_fields["producto"], "Products");

		// Obtiene la línea del producto.
		if ($producto_actual->column_fields[$campos_personalizados["products"]["linea"]] != "")
		{
			$linea_actual = new Lineas;
			$linea_actual->retrieve_entity_info($producto_actual->column_fields[$campos_personalizados["products"]["linea"]], "Lineas");
		}
		else
		{
			die("ERROR. El producto ".$producto_actual->column_fields["productname"]." no tiene línea.");
		}
		//$linea_actual = new Lineas;
		//$linea_actual->retrieve_entity_info($producto_actual->column_fields[$campos_personalizados["products"]["linea"]], "Lineas");

/********************************************************************************************
		// Calcula código de artículo nuevo según la familia de producto.
		$codigo_articulo = $producto_actual->column_fields["productcode"];

		if ($linea_actual->column_fields["familia"] != "")
		{
			$familia_actual = new Familias;
			$familia_actual->retrieve_entity_info($linea_actual->column_fields["familia"], "Familias");
		}
		else
		{
			die("ERROR. La línea ".$linea_actual->column_fields["nombre"]." no tiene familia.");
		}
************************************************************************************/
		$codigo_articulo = $producto_actual->column_fields["productcode"];

		// Si es subarrendado, agrega el prefijo "6".
		if ($this->column_fields["subarrendado"])
		{
			$codigo_articulo = "6$codigo_articulo";
		}

		// Crea o actualiza, según sea el caso, el registro de kardex de nuevos.

		// Revisa si ya existe el registro.
		$consulta = "select kdx.* from vtiger_kardex kdx, vtiger_crmentity e where kdx.movimiento = '$folio_alta' and e.crmid = kdx.kardexid and e.deleted = '0' and kdx.codigo = '$codigo_articulo'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);
		$id_kardex = $renglon["kardexid"];
/****************************************
echo "<pre>";
var_dump($id_alta);
var_dump($this->id);
var_dump($renglon);
*****************************************/

		$kardex = new Kardex;
		if ($id_kardex != "")
		{
			$kardex->retrieve_entity_info($id_kardex, "Kardex");
		}
		$kardex->column_fields["assigned_user_id"] = $current_user->id;
		$kardex->column_fields["codigo"] = $codigo_articulo;
		$kardex->column_fields["fecha"] = $this->column_fields["fecha_efectiva"];
                $kardex->column_fields["tipo_documento"] = "Alta a flota de renta";
		$kardex->column_fields["movimiento"] = $this->column_fields["folio"];
		//$kardex->column_fields["existencia_inicial"] = 0 + $existencias->column_fields["cantidad"];
		$kardex->column_fields["existencia_inicial"] = 0;
		$kardex->column_fields["entradas"] = 0;
		$kardex->column_fields["salidas"] = $this->column_fields["cantidad"];
		$kardex->column_fields["existencia_final"] = $kardex->column_fields["existencia_inicial"] + $kardex->column_fields["entradas"] - $kardex->column_fields["salidas"];
		$kardex->save("Kardex", $id_kardex);


		// Crea o actualiza, según sea el caso, el registro de existencias de nuevos.
		
		// Revisa si ya existe el registro.
		$consulta = "select exi.* from vtiger_existencias exi, vtiger_crmentity e where e.crmid = exi.existenciasid and e.deleted = '0' and exi.codigo_producto = '$codigo_articulo' ";
		//var_dump($consulta);
		//die;
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);
		$id_exi_nuevo = $renglon["existenciasid"];

		$exi_nuevo = new Existencias;
		if ($id_exi_nuevo != "")
		{
			$exi_nuevo->retrieve_entity_info($id_exi_nuevo, "Existencias");
		}
		$exi_nuevo->column_fields["assigned_user_id"] = $current_user->id;
		$exi_nuevo->column_fields["sucursal"] = $sucursal->column_fields["record_id"];
		$exi_nuevo->column_fields["almacen"] = $sucursal->column_fields["almacen_nuevo"];
		$exi_nuevo->column_fields["producto"] = $producto_actual->column_fields["record_id"];
		$exi_nuevo->column_fields["codigo_producto"] = $codigo_articulo;
		$exi_nuevo->column_fields["cantidad"] = 0;
		$exi_nuevo->save("Existencias", $id_exi_nuevo);
		// Calcula cantidades reconstruyendo a partir de la fecha efectiva de la recepción.
		$exi_nuevo->calcular($this->column_fields["fecha_efectiva"]);


		// Crea los registros de flota de renta de acuerdo a la cantidad de equipos del alta.

		for ($i = 1; $i <= $this->column_fields["cantidad"]; $i++)
		{
			// Busca un posible registro existente.
			$consulta = "select flr.flota_rentaid, flr.numeros_serieid from vtiger_flota_renta flr, vtiger_crmentity e where e.crmid = flr.flota_rentaid and e.deleted = '0' and flr.consecutivo_producto = '$i' and flr.altas_flota_rentaid = '$id_alta'";
//var_dump($consulta);
//die;
			$resultado = $adb->query($consulta);
			$renglon = $adb->fetch_array($resultado);
			$valores_ns = each($ns);
//die(var_dump($valores_ns));

        		$flota_renta = new Flota_renta;
			if ($renglon["flota_rentaid"] != "")
			{
				$flota_renta->retrieve_entity_info($renglon["flota_rentaid"], "Flota_renta");
			}

			// Si ya tenía número interno, lo respeta, si no obtiene los códigos que le corresponden.
			if ($flota_renta->column_fields["numero_interno"] == "")
			{
        			$codigos = $linea_actual->obtener_codigos($this->column_fields["subarrendado"]);
			}
			else
			{
        			$codigos["general"] = $flota_renta->column_fields["codigo_general"];
        			$codigos["flota"] = $flota_renta->column_fields["codigo_flota"];
        			$codigos["renta"] = $flota_renta->column_fields["codigo_renta"];
        			$codigos["hextra"] = $flota_renta->column_fields["codigo_hextra"];
			}

        		$flota_renta->column_fields["assigned_user_id"] = $current_user->id;
        		$flota_renta->column_fields["sucursal"] = $this->column_fields["sucursal"];
        		$flota_renta->column_fields["cliente"] = $sucursal->column_fields["cliente_mks"];
        		$flota_renta->column_fields["obra"] = $sucursal->column_fields["obra_mks"];
        		$flota_renta->column_fields["producto"] = $producto_actual->column_fields["record_id"];
        		$flota_renta->column_fields["estado"] = "Disponible";
        		$flota_renta->column_fields["existencia"] = 1;
        		$flota_renta->column_fields["numero_serie"] = $valores_ns["key"];
        		$flota_renta->column_fields["alta_flota_renta"] = $id_alta;
        		$flota_renta->column_fields["consecutivo_producto"] = $i;
       			$flota_renta->column_fields["codigo_general"] = $codigos["general"];
       			$flota_renta->column_fields["codigo_flota"] = $codigos["flota"];
       			$flota_renta->column_fields["codigo_renta"] = $codigos["renta"];
       			$flota_renta->column_fields["codigo_hextra"] = $codigos["hextra"];
       			$flota_renta->column_fields["numero_interno"] = $codigos["flota"];
//die(var_dump($flota_renta->column_fields));
        		$flota_renta->save("Flota_renta", $renglon["flota_rentaid"]);

			// Actualiza los registros de número de serie involucrados.
			// Elemento anterior.
			if ($renglon["numeros_serieid"] != "")
			{
				$ns_actual = new Numeros_serie;
				$ns_actual->retrieve_entity_info($renglon["numeros_serieid"], "Numeros_serie");
				$ns_actual->column_fields["estado"] = "Nuevo";
				$ns_actual->column_fields["numero_interno"] = "";
				$ns_actual->save("Numeros_serie", $renglon["numeros_serieid"]);
			}

			// Elemento elegido.
			if ($valores_ns["key"] != "")
			{
				$ns_actual = new Numeros_serie;
				$ns_actual->retrieve_entity_info($valores_ns["key"], "Numeros_serie");
				$ns_actual->column_fields["estado"] = "Equipo";
				$ns_actual->column_fields["numero_interno"] = $flota_renta->column_fields["numero_interno"];
				$ns_actual->save("Numeros_serie", $valores_ns["key"]);
			}

                	// Crea o actualiza, según sea el caso, el registro de kardex de nuevos.

                	// Revisa si ya existe el registro.
			$codigo_articulo = $codigos["flota"];
                	$consulta = "select kdx.* from vtiger_kardex kdx, vtiger_crmentity e where kdx.movimiento = '$folio_alta' and e.crmid = kdx.kardexid and e.deleted = '0' and kdx.codigo = '$codigo_articulo'";
                	$resultado = $adb->query($consulta);
                	$renglon = $adb->fetch_array($resultado);
                	$id_kardex = $renglon["kardexid"];

                	$kardex = new Kardex;
                	if ($id_kardex != "")
                	{
                        	$kardex->retrieve_entity_info($id_kardex, "Kardex");
                	}
                	$kardex->column_fields["assigned_user_id"] = $current_user->id;
                	$kardex->column_fields["codigo"] = $codigo_articulo;
                	$kardex->column_fields["fecha"] = $this->column_fields["fecha_efectiva"];
                	$kardex->column_fields["tipo_documento"] = "Alta a flota de renta";
                	$kardex->column_fields["movimiento"] = $this->column_fields["folio"];
                	$kardex->column_fields["existencia_inicial"] = 0;
                	$kardex->column_fields["entradas"] = 1;
                	$kardex->column_fields["salidas"] = 0;
                	$kardex->column_fields["existencia_final"] = $kardex->column_fields["existencia_inicial"] + $kardex->column_fields["entradas"] - $kardex->column_fields["salidas"];
                	$kardex->save("Kardex", $id_kardex);


			// Crea o actualiza, según sea el caso, el registro de existencias de flota de renta.

			// Revisa si ya existe el registro.
			$consulta = "select exi.* from vtiger_existencias exi, vtiger_crmentity e where e.crmid = exi.existenciasid and e.deleted = '0' and exi.codigo_producto = '$codigo_articulo' ";
			//var_dump($consulta);
			//die;
			$resultado = $adb->query($consulta);
			$renglon = $adb->fetch_array($resultado);
			$id_exi_flota = $renglon["existenciasid"];

			$exi_flota = new Existencias;
			if ($id_exi_flota != "")
			{
			$exi_flota->retrieve_entity_info($id_exi_flota, "Existencias");
			}
			$exi_flota->column_fields["assigned_user_id"] = $current_user->id;
			$exi_flota->column_fields["sucursal"] = $sucursal->column_fields["record_id"];
			$exi_flota->column_fields["almacen"] = $sucursal->column_fields["almacen_flota"];
			$exi_flota->column_fields["producto"] = $producto_actual->column_fields["record_id"];
			$exi_flota->column_fields["codigo_producto"] = $codigo_articulo;
			$exi_flota->column_fields["cantidad"] = 0;
			$exi_flota->save("Existencias", $id_exi_flota);
			// Calcula cantidades reconstruyendo a partir de la fecha efectiva de la recepción.
			$exi_flota->calcular($this->column_fields["fecha_efectiva"]);






                        // Crea o actualiza, según sea el caso, el registro de kardex de código de renta.

                        // Revisa si ya existe el registro.
			$codigo_articulo = $codigos["renta"];
                        $consulta = "select kdx.* from vtiger_kardex kdx, vtiger_crmentity e where kdx.movimiento = '$folio_alta' and e.crmid = kdx.kardexid and e.deleted = '0' and kdx.codigo = '$codigo_articulo'";
                        $resultado = $adb->query($consulta);
                        $renglon = $adb->fetch_array($resultado);
                        $id_kardex = $renglon["kardexid"];

                        $kardex = new Kardex;
                        if ($id_kardex != "")
                        {
                                $kardex->retrieve_entity_info($id_kardex, "Kardex");
                        }
                        $kardex->column_fields["assigned_user_id"] = $current_user->id;
                        $kardex->column_fields["codigo"] = $codigo_articulo;
                        $kardex->column_fields["fecha"] = $this->column_fields["fecha_efectiva"];
                        $kardex->column_fields["tipo_documento"] = "Alta a flota de renta";
                        $kardex->column_fields["movimiento"] = $this->column_fields["folio"];
                        $kardex->column_fields["existencia_inicial"] = 0;
                        $kardex->column_fields["entradas"] = 100000;
                        $kardex->column_fields["salidas"] = 0;
                        $kardex->column_fields["existencia_final"] = $kardex->column_fields["existencia_inicial"] + $kardex->column_fields["entradas"] - $kardex->column_fields["salidas"];
                        $kardex->save("Kardex", $id_kardex);

			// Si esta línea de productos permite horas extra hace el procesamiento correspondiente.
                	$permite_hextra = $linea_actual->column_fields["hextra"];
			if ($permite_hextra)
			{
                        	// Crea o actualiza, según sea el caso, el registro de kardex de código de renta.

                        	// Revisa si ya existe el registro.
                        	$codigo_articulo = $codigos["hextra"];
                        	$consulta = "select kdx.* from vtiger_kardex kdx, vtiger_crmentity e where kdx.movimiento = '$folio_alta' and e.crmid = kdx.kardexid and e.deleted = '0' and kdx.codigo = '$codigo_articulo'";
                        	$resultado = $adb->query($consulta);
                        	$renglon = $adb->fetch_array($resultado);
                        	$id_kardex = $renglon["kardexid"];

                        	$kardex = new Kardex;
                        	if ($id_kardex != "")
                        	{
                                	$kardex->retrieve_entity_info($id_kardex, "Kardex");
                        	}
                        	$kardex->column_fields["assigned_user_id"] = $current_user->id;
                        	$kardex->column_fields["codigo"] = $codigo_articulo;
                        	$kardex->column_fields["fecha"] = $this->column_fields["fecha_efectiva"];
                        	$kardex->column_fields["tipo_documento"] = "Alta a flota de renta";
                        	$kardex->column_fields["movimiento"] = $this->column_fields["folio"];
                        	$kardex->column_fields["existencia_inicial"] = 0;
                        	$kardex->column_fields["entradas"] = 100000;
                        	$kardex->column_fields["salidas"] = 0;
                        	$kardex->column_fields["existencia_final"] = $kardex->column_fields["existencia_inicial"] + $kardex->column_fields["entradas"] - $kardex->column_fields["salidas"];
                        	$kardex->save("Kardex", $id_kardex);
			}

			// Elimina la flota de renta adicional que pudiera haber quedado de una captura previa. Esto ocurre cuando se decrementa la cantidad en el alta.
			//$consulta = "update vtiger_numeros_serie ns, vtiger_crmentity e set e.deleted = '1' where e.crmid = ns.numeros_serieid and ns.consecutivo_producto >= '$j' and ns.productid = '$producto' and ns.recepciones_mercanciaid = '$id_recepcion'";
			
//var_dump($consulta);
//die;
//$adb->query($consulta);

		}
	}

	function asignar_folio()
	{
/*****************************
echo "<pre>";
var_dump($this->id);
var_dump($this->column_fields);
die;
**************************/
        	$codigo_modulo = "altas_flota_renta";
        	$codigo_documento = "A";
        	$sucursal = new Sucursales;
        	$sucursal->retrieve_entity_info($this->column_fields["sucursal"], "Sucursales");
        	$block_folios = new Blocks_folios;
		if ($this->column_fields["subarrendado"])
		{
        		$block_folios->retrieve_entity_info($sucursal->column_fields[$codigo_modulo."_subarrendado"], "Blocks_folios");
		}
		else
		{
        		$block_folios->retrieve_entity_info($sucursal->column_fields[$codigo_modulo], "Blocks_folios");
		}
        	$this->column_fields["folio"] = $sucursal->column_fields["prefijo"].$codigo_documento.$block_folios->column_fields["prefijo"].str_pad($block_folios->column_fields["folio"], 6, "0", STR_PAD_LEFT);
        	$block_folios->column_fields["folio"]++;
        	$block_folios->save("Blocks_folios", $block_folios->column_fields["record_id"]);
		$this->save("Altas_flota_renta", $this->id);
	}

	function reconstruir()
	{
                // La sesión se abre no aquí sino en el programa que manda llamar esta función. De esto depende poder cargar el usuario actual.

                global $current_user, $adb;

                $id_alta = (int)$this->column_fields["record_id"];
                $folio_alta = $this->column_fields["folio"];

		// Genera una lista de números de serie actualmente registrados para esta alta.
		$consulta = "select flr.*, ns.numero_serie from vtiger_flota_renta flr, vtiger_crmentity e, vtiger_numeros_serie ns where e.crmid = flr.flota_rentaid and e.deleted = '0' and flr.altas_flota_rentaid = '$id_alta' and ns.numeros_serieid = flr.numeros_serieid";
		//var_dump($consulta);
		$resultado = $adb->query($consulta);
		//var_dump($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
			$ns[$renglon["numeros_serieid"]] = "on";
		}
		//var_dump($ns);

		if (!$this->column_fields["subarrendado"])
		{
			$this->procesar($ns);
		}
	}

	function detectar_anomalias()
	{
                // Intenta detectar anomalías y, en caso de encontrar, las registra en el documento de operación.

                global $adb;

                $id_alta = (int)$this->column_fields["record_id"];

                // Anomalía buscada: inconsistencia en cantidad vs números de serie registrados en la flota de renta.
                $consulta = "select count(*) as cantidad from vtiger_flota_renta flr, vtiger_crmentity e where e.crmid = flr.flota_rentaid and e.deleted = '0' and flr.altas_flota_rentaid = '$id_alta'";
                $resultado = $adb->query($consulta);
                $renglon = $adb->fetch_array($resultado);
/*****************************************
echo "<pre>";
var_dump($consulta);
var_dump($renglon);
var_dump($this->column_fields);
die;
*******************************************/

                if ($this->column_fields["cantidad"] != $renglon["cantidad"])
                {
			$anomalia = "La cantidad no coincide con los artículos en flota de renta.";
                }
                else
                {
                        $anomalia = false;
                }

		return $anomalia;
	}
}
?>
