<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
require_once("modules/Flota_renta/Flota_renta.php");
require_once("modules/Products/Products.php");
require_once("modules/Lineas/Lineas.php");

class Por_facturar extends CRMEntity {
	var $db, $log; // Used in class functions of CRMEntity

	var $table_name = 'vtiger_por_facturar';
	var $table_index= 'por_facturarid';
	var $column_fields = Array();

	/** Indicator if this is a custom module or standard module */
	var $IsCustomModule = true;

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_por_facturarcf', 'por_facturarid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_por_facturar', 'vtiger_por_facturarcf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_por_facturar'   => 'por_facturarid',
	    'vtiger_por_facturarcf' => 'por_facturarid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Por_facturar Name'=> Array('por_facturar', 'idv'),
		'Assigned To' => Array('crmentity','smownerid')
	);
	var $list_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Por_facturar Name'=> 'idv',
		'Assigned To' => 'assigned_user_id'
	);

	// Make the field link to detail view from list view (Fieldname)
	var $list_link_field = 'idv';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Por_facturar Name'=> Array('por_facturar', 'idv')
	);
	var $search_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Por_facturar Name'=> 'idv'
	);

	// For Popup window record selection
	var $popup_fields = Array('idv');

	// Placeholder for sort fields - All the fields will be initialized for Sorting through initSortFields
	var $sortby_fields = Array();

	// For Alphabetical search
	var $def_basicsearch_col = 'idv';

	// Column value to use on detail view record text display
	var $def_detailview_recname = 'idv';

	// Required Information for enabling Import feature
	var $required_fields = Array('idv'=>1);

	// Callback function list during Importing
	var $special_functions = Array('set_import_assigned_user');

	var $default_order_by = 'idv';
	var $default_sort_order='ASC';
	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('createdtime', 'modifiedtime', 'idv');
	
	function __construct() {
		global $log, $currentModule;
		$this->column_fields = getColumnFields($currentModule);
		$this->db = PearDatabase::getInstance();
		$this->log = $log;
	}

	function getSortOrder() {
		global $currentModule;

		$sortorder = $this->default_sort_order;
		if($_REQUEST['sorder']) $sortorder = $this->db->sql_escape_string($_REQUEST['sorder']);
		else if($_SESSION[$currentModule.'_Sort_Order']) 
			$sortorder = $_SESSION[$currentModule.'_Sort_Order'];

		return $sortorder;
	}

	function getOrderBy() {
		global $currentModule;
		
		$use_default_order_by = '';		
		if(PerformancePrefs::getBoolean('LISTVIEW_DEFAULT_SORTING', true)) {
			$use_default_order_by = $this->default_order_by;
		}
		
		$orderby = $use_default_order_by;
		if($_REQUEST['order_by']) $orderby = $this->db->sql_escape_string($_REQUEST['order_by']);
		else if($_SESSION[$currentModule.'_Order_By'])
			$orderby = $_SESSION[$currentModule.'_Order_By'];
		return $orderby;
	}

	function save_module($module) {
	}

	/**
	 * Return query to use based on given modulename, fieldname
	 * Useful to handle specific case handling for Popup
	 */
	function getQueryByModuleField($module, $fieldname, $srcrecord, $query='') {
		// $srcrecord could be empty
	}

	/**
	 * Get list view query (send more WHERE clause condition if required)
	 */
	function getListQuery($module, $usewhere='') {
		$query = "SELECT vtiger_crmentity.*, $this->table_name.*";
		
		// Keep track of tables joined to avoid duplicates
		$joinedTables = array();

		// Select Custom Field Table Columns if present
		if(!empty($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$query .= " FROM $this->table_name";

		$query .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		$joinedTables[] = $this->table_name;
		$joinedTables[] = 'vtiger_crmentity';
		
		// Consider custom table join as well.
		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index";
			$joinedTables[] = $this->customFieldTable[0]; 
		}
		$query .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";

		$joinedTables[] = 'vtiger_users';
		$joinedTables[] = 'vtiger_groups';
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($module));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);
		
		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other =  CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			if(!in_array($other->table_name, $joinedTables)) {
				$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
				$joinedTables[] = $other->table_name;
			}
		}

		global $current_user;
		$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
		$query .= "	WHERE vtiger_crmentity.deleted = 0 ".$usewhere;
		return $query;
	}

	/**
	 * Apply security restriction (sharing privilege) query part for List view.
	 */
	function getListViewSecurityParameter($module) {
		global $current_user;
		require('user_privileges/user_privileges_'.$current_user->id.'.php');
		require('user_privileges/sharing_privileges_'.$current_user->id.'.php');

		$sec_query = '';
		$tabid = getTabid($module);

		if($is_admin==false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 
			&& $defaultOrgSharingPermission[$tabid] == 3) {

				$sec_query .= " AND (vtiger_crmentity.smownerid in($current_user->id) OR vtiger_crmentity.smownerid IN 
					(
						SELECT vtiger_user2role.userid FROM vtiger_user2role 
						INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid 
						INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid 
						WHERE vtiger_role.parentrole LIKE '".$current_user_parent_role_seq."::%'
					) 
					OR vtiger_crmentity.smownerid IN 
					(
						SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per 
						WHERE userid=".$current_user->id." AND tabid=".$tabid."
					) 
					OR 
						(";
		
					// Build the query based on the group association of current user.
					if(sizeof($current_user_groups) > 0) {
						$sec_query .= " vtiger_groups.groupid IN (". implode(",", $current_user_groups) .") OR ";
					}
					$sec_query .= " vtiger_groups.groupid IN 
						(
							SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid 
							FROM vtiger_tmp_read_group_sharing_per
							WHERE userid=".$current_user->id." and tabid=".$tabid."
						)";
				$sec_query .= ")
				)";
		}
		return $sec_query;
	}

	/**
	 * Create query to export the records.
	 */
	function create_export_query($where)
	{
		global $current_user;
		$thismodule = $_REQUEST['module'];
		
		include("include/utils/ExportUtils.php");

		//To get the Permitted fields query and the permitted fields list
		$sql = getPermittedFieldsQuery($thismodule, "detail_view");
		
		$fields_list = getFieldsListFromQuery($sql);

		$query = "SELECT $fields_list, vtiger_users.user_name AS user_name 
					FROM vtiger_crmentity INNER JOIN $this->table_name ON vtiger_crmentity.crmid=$this->table_name.$this->table_index";

		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}

		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id and vtiger_users.status='Active'";
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($thismodule));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);

		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other = CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
		}

		$query .= $this->getNonAdminAccessControlQuery($thismodule,$current_user);
		$where_auto = " vtiger_crmentity.deleted=0";

		if($where != '') $query .= " WHERE ($where) AND $where_auto";
		else $query .= " WHERE $where_auto";

		return $query;
	}

	/**
	 * Initialize this instance for importing.
	 */
	function initImport($module) {
		$this->db = PearDatabase::getInstance();
		$this->initImportableFields($module);
	}

	/**
	 * Create list query to be shown at the last step of the import.
	 * Called From: modules/Import/UserLastImport.php
	 */
	function create_import_query($module) {
		global $current_user;
		$query = "SELECT vtiger_crmentity.crmid, case when (vtiger_users.user_name not like '') then vtiger_users.user_name else vtiger_groups.groupname end as user_name, $this->table_name.* FROM $this->table_name
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index
			LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=vtiger_crmentity.crmid
			LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			WHERE vtiger_users_last_import.assigned_user_id='$current_user->id'
			AND vtiger_users_last_import.bean_type='$module'
			AND vtiger_users_last_import.deleted=0";
		return $query;
	}

	/**
	 * Delete the last imported records.
	 */
	function undo_import($module, $user_id) {
		global $adb;
		$count = 0;
		$query1 = "select bean_id from vtiger_users_last_import where assigned_user_id=? AND bean_type='$module' AND deleted=0";
		$result1 = $adb->pquery($query1, array($user_id)) or die("Error getting last import for undo: ".mysql_error()); 
		while ( $row1 = $adb->fetchByAssoc($result1))
		{
			$query2 = "update vtiger_crmentity set deleted=1 where crmid=?";
			$result2 = $adb->pquery($query2, array($row1['bean_id'])) or die("Error undoing last import: ".mysql_error()); 
			$count++;			
		}
		return $count;
	}
	
	/**
	 * Transform the value while exporting
	 */
	function transform_export_value($key, $value) {
		return parent::transform_export_value($key, $value);
	}

	/**
	 * Function which will set the assigned user id for import record.
	 */
	function set_import_assigned_user()
	{
		global $current_user, $adb;
		$record_user = $this->column_fields["assigned_user_id"];
		
		if($record_user != $current_user->id){
			$sqlresult = $adb->pquery("select id from vtiger_users where id = ? union select groupid as id from vtiger_groups where groupid = ?", array($record_user, $record_user));
			if($this->db->num_rows($sqlresult)!= 1) {
				$this->column_fields["assigned_user_id"] = $current_user->id;
			} else {			
				$row = $adb->fetchByAssoc($sqlresult, -1, false);
				if (isset($row['id']) && $row['id'] != -1) {
					$this->column_fields["assigned_user_id"] = $row['id'];
				} else {
					$this->column_fields["assigned_user_id"] = $current_user->id;
				}
			}
		}
	}
	
	/** 
	 * Function which will give the basic query to find duplicates
	 */
	function getDuplicatesQuery($module,$table_cols,$field_values,$ui_type_arr,$select_cols='') {
		$select_clause = "SELECT ". $this->table_name .".".$this->table_index ." AS recordid, vtiger_users_last_import.deleted,".$table_cols;

		// Select Custom Field Table Columns if present
		if(isset($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$from_clause = " FROM $this->table_name";

		$from_clause .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		// Consider custom table join as well.
		if(isset($this->customFieldTable)) {
			$from_clause .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}
		$from_clause .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
						LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		
		$where_clause = "	WHERE vtiger_crmentity.deleted = 0";
		$where_clause .= $this->getListViewSecurityParameter($module);
					
		if (isset($select_cols) && trim($select_cols) != '') {
			$sub_query = "SELECT $select_cols FROM  $this->table_name AS t " .
				" INNER JOIN vtiger_crmentity AS crm ON crm.crmid = t.".$this->table_index;
			// Consider custom table join as well.
			if(isset($this->customFieldTable)) {
				$sub_query .= " LEFT JOIN ".$this->customFieldTable[0]." tcf ON tcf.".$this->customFieldTable[1]." = t.$this->table_index";
			}
			$sub_query .= " WHERE crm.deleted=0 GROUP BY $select_cols HAVING COUNT(*)>1";	
		} else {
			$sub_query = "SELECT $table_cols $from_clause $where_clause GROUP BY $table_cols HAVING COUNT(*)>1";
		}	
		
		
		$query = $select_clause . $from_clause .
					" LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=" . $this->table_name .".".$this->table_index .
					" INNER JOIN (" . $sub_query . ") AS temp ON ".get_on_clause($field_values,$ui_type_arr,$module) .
					$where_clause .
					" ORDER BY $table_cols,". $this->table_name .".".$this->table_index ." ASC";
					
		return $query;		
	}

	/**
	 * Invoked when special actions are performed on the module.
	 * @param String Module name
	 * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
	 */
	function vtlib_handler($modulename, $event_type) {
		if($event_type == 'module.postinstall') {
			// TODO Handle post installation actions
		} else if($event_type == 'module.disabled') {
			// TODO Handle actions when this module is disabled.
		} else if($event_type == 'module.enabled') {
			// TODO Handle actions when this module is enabled.
		} else if($event_type == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($event_type == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($event_type == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
	}

	/** 
	 * Handle saving related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	// function save_related_module($module, $crmid, $with_module, $with_crmid) { }
	
	/**
	 * Handle deleting related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function delete_related_module($module, $crmid, $with_module, $with_crmid) { }

	/**
	 * Handle getting related list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_related_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	/**
	 * Handle getting dependents list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_dependents_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	// Devuelve el código a utilizar en la facturación.
	function codigo()
	{
		$concepto = substr($this->column_fields["concepto"], 0, 5);

		//switch ($this->column_fields["concepto"])
		switch ($concepto)
		{
			case "Flete":
				$codigo = "9SER MANIOBRA";
			break;
			case "Repar":
				$codigo = "9REP REPARACION";
			break;
			case "Renta":
				if ($this->column_fields["equipo"] != "")
				{
					$flr = new Flota_renta;
					$flr->retrieve_entity_info($this->column_fields["equipo"], "Flota_renta");
					$codigo = $flr->codigo();
				}
			break;
			case "Venta":
				if ($this->column_fields["producto"] != "")
				{
					$prod = new Products;
					$prod->retrieve_entity_info($this->column_fields["producto"], "Products");
					$codigo = $prod->column_fields["productcode"];
				}
			break;
		}

		return $codigo;
	}

	// Devuelve la descripción a utilizar en la facturación.
	function descripcion()
	{
		global $adb;

		require("campos_personalizados.php");

		$concepto = substr($this->column_fields["concepto"], 0, 5);
		//if ($this->column_fields["concepto"] == "Flete" || $this->column_fields["concepto"] == "Reparación")
		if ($concepto == "Flete" || $concepto == "Repar")
		{
			$letrero["Flete"] = "9SER MANIOBRA";
			$letrero["Repar"] = "9REP REPARACION";

			//$descripcion = "RENTA ".$lin->column_fields["nombre"]." $fecha_ini A $fecha_fin | ".$this->column_fields["cantidad"]." UNIDADES.";
			$codigo_remision = substr($this->column_fields["movimiento"], 1 ,1);
			switch ($codigo_remision)
			{
				case "E":
					$tipo_remision = "ENTREGA";
					$consulta = "select ent.fecha_efectiva from vtiger_entregas ent, vtiger_crmentity e where e.crmid = ent.entregasid and e.deleted = '0' and ent.folio = '".$this->column_fields["movimiento"]."'";
					$resultado = $adb->query($consulta);
					$renglon = $adb->fetch_array($resultado);
					$fecha_efectiva = $renglon["fecha_efectiva"];
				break;
				case "C":
					$tipo_remision = "CAMBIO";
					$consulta = "select cam.fecha_efectiva from vtiger_cambios cam, vtiger_crmentity e where e.crmid = cam.cambiosid and e.deleted = '0' and cam.folio = '".$this->column_fields["movimiento"]."'";
					$resultado = $adb->query($consulta);
					$renglon = $adb->fetch_array($resultado);
					$fecha_efectiva = $renglon["fecha_efectiva"];
				break;
				case "R":
					$tipo_remision = "RECOLECCION";
					$consulta = "select rco.fecha_efectiva from vtiger_recolecciones rco, vtiger_crmentity e where e.crmid = rco.recoleccionesid and e.deleted = '0' and rco.folio = '".$this->column_fields["movimiento"]."'";
					$resultado = $adb->query($consulta);
					$renglon = $adb->fetch_array($resultado);
					$fecha_efectiva = $renglon["fecha_efectiva"];
				break;
			}

			//$descripcion = "9SER MANIOBRA | $tipo_remision ".$this->column_fields["movimiento"]." $fecha_efectiva.";
			$descripcion = $letrero[$concepto]." | $tipo_remision ".$this->column_fields["movimiento"]." $fecha_efectiva.";
		}

		if ($this->column_fields["concepto"] == "Renta de equipo" && $this->column_fields["equipo"] != "")
		{
			// Obtiene los objetos en juego.
			$flr = new Flota_renta;
			$flr->retrieve_entity_info($this->column_fields["equipo"], "Flota_renta");

			if ($flr->column_fields["producto"] == "")
			{
				die("<h1>ERROR</h1>Un registro de flota de renta no está asociado a ningún producto.");
			}

			$prod = new Products;
			$prod->retrieve_entity_info($flr->column_fields["producto"], "Products");

			if ($prod->column_fields[$campos_personalizados["products"]["linea"]] == "")
			{
				die("<h1>ERROR</h1>Un producto no está asociado a ninguna línea.");
			}
			
			$lin = new Lineas;
			$lin->retrieve_entity_info($prod->column_fields[$campos_personalizados["products"]["linea"]], "Lineas");

			$fecha_ini = ($this->column_fields["fecha_ini_fac"] != "")?$this->column_fields["fecha_ini_fac"]:$this->column_fields["fecha_ini"];
			$fecha_fin = ($this->column_fields["fecha_fin_fac"] != "")?$this->column_fields["fecha_fin_fac"]:$this->column_fields["fecha_fin"];
			//$descripcion = "RENTA ".$lin->column_fields["nombre"]." ".$this->column_fields["fecha_ini"]." A ".$this->column_fields["fecha_fin"]." | ".$this->column_fields["cantidad"]." UNIDADES.";
			$descripcion = "RENTA ".$lin->column_fields["nombre"]." $fecha_ini A $fecha_fin | ".$this->column_fields["cantidad"]." UNIDADES.";
		}


		if (strpos($this->column_fields["concepto"], "Venta") !== false)
		{
			if ($this->column_fields["producto"] != "")
			{
				$prod = new Products;
				$prod->retrieve_entity_info($this->column_fields["producto"], "Products");
				$descripcion = $prod->column_fields["productname"];
			}

			if ($this->column_fields["numero_serie"] != "")
			{
				$ns = new Numeros_serie;
				$ns->retrieve_entity_info($this->column_fields["numero_serie"], "Numeros_serie");
				$descripcion .= " NS: ".$ns->column_fields["numero_serie"];
				if ($ns->column_fields["numero_interno"])
				{
					$descripcion .= " NI: ".$ns->column_fields["numero_interno"];
				}
			}
		}

		return $descripcion;
	}

	// Devuelve el precio unitario a utilizar en la facturación. Es el precio unitario de la línea multiplicado por las unidades utilizadas. Ése es el precio unitario del día de renta.
	function precio_unitario()
	{
		require("campos_personalizados.php");

		// Si ya hay un precio unitario facturado se toma ese valor.
		if ($this->column_fields["precio_unitario_fac"] != "")
		{
			$precio_unitario = $this->column_fields["precio_unitario_fac"];
		}
		else
		{
			if ($this->column_fields["concepto"] == "Renta de equipo" && $this->column_fields["equipo"] != "")
			{
			// Si ya hay un precio unitario facturado se toma ese valor.
			//if ($this->column_fields["precio_unitario_fac"] != "")
			//{
				//$precio_unitario = $this->column_fields["precio_unitario_fac"];
			//}
			//else
			//{
				// Obtiene los objetos en juego.
				$flr = new Flota_renta;
				$flr->retrieve_entity_info($this->column_fields["equipo"], "Flota_renta");

				if ($flr->column_fields["producto"] == "")
				{
					die("<h1>ERROR</h1>Un registro de flota de renta no está asociado a ningún producto.");
				}

				$prod = new Products;
				$prod->retrieve_entity_info($flr->column_fields["producto"], "Products");

				if ($prod->column_fields[$campos_personalizados["products"]["linea"]] == "")
				{
					die("<h1>ERROR</h1>Un producto no está asociado a ninguna línea.");
				}
			
				$lin = new Lineas;
				$lin->retrieve_entity_info($prod->column_fields[$campos_personalizados["products"]["linea"]], "Lineas");

				if ($lin->column_fields["precio_dia"] == "")
				{
					die("<h1>ERROR</h1>La línea <a href=\"index.php?module=Lineas&action=DetailView&record=".$prod->column_fields[$campos_personalizados["products"]["linea"]]."\">".$lin->column_fields["nombre"]."</a> no tiene definido su precio de día de renta.");
				}

				// Calcula precio unitario.
				$precio_unitario = $this->column_fields["cantidad"] * $lin->column_fields["precio_dia"];
			}
		}

		return $precio_unitario;
	}

	// Actualiza el detalle del por facturar.
	function estado($estado)
	{
		$this->column_fields["estado"] = $estado;
		$this->save("Por_facturar", $this->obtener_id());
	}

	// Devuelve la cantidad a facturar de acuerdo al concepto.
	function cantidad_facturar()
	{
		$cantidad_facturar = 1;

		if ($this->column_fields["concepto"] == "Renta de equipo")
		{
			$cantidad_facturar = $this->column_fields["dias"];
		}

		if (strpos($this->column_fields["concepto"], "Venta") !== false)
		{
			$cantidad_facturar = $this->column_fields["cantidad"];
		}

		return $cantidad_facturar;
	}

	// Divide (o agrupa) los por_facturar cuando hay facturación parcial.
	function segmentar($ini, $fin, $cantidad = "", $precio_unitario = "")
	{
		global $adb;

		$pfa_id = $this->obtener_id();

		//echo "Segmentar";
//var_dump($ini, $fin);
		$fecha_ini = new DateTime($this->column_fields["fecha_ini"], new DateTimeZone("America/Mexico_City"));
		$fecha_fin = new DateTime($this->column_fields["fecha_fin"], new DateTimeZone("America/Mexico_City"));
		$fecha_ini_fac = new DateTime($ini, new DateTimeZone("America/Mexico_City"));
		$fecha_fin_fac = new DateTime($fin, new DateTimeZone("America/Mexico_City"));

		// Caso 1: se factura una porción central del por_facturar.
		if (($fecha_ini_fac > $fecha_ini) && ($fecha_fin_fac < $fecha_fin))
		{
			// Genera 3 segmentos. El central queda facturado y los laterales pendientes.
			$segmentos["facturado"] = $this->crear_segmento("Facturado", $ini, $fin, $cantidad, $precio_unitario);
			$fecha_fin_rest = new DateTime($ini . " - 1 day", new DateTimeZone("America/Mexico_City"));
			$segmentos["pendiente"][] = $this->crear_segmento("Pendiente", $this->column_fields["fecha_ini"], $fecha_fin_rest->format("Y-m-d"));
			$fecha_ini_rest = new DateTime($fin . " + 1 day", new DateTimeZone("America/Mexico_City"));
			$segmentos["pendiente"][] = $this->crear_segmento("Pendiente", $fecha_ini_rest->format("Y-m-d"), $this->column_fields["fecha_fin"]);
		}

		// Caso 2: se factura la porción derecha del por_facturar.
		//if ($fecha_ini_fac > $fecha_ini)
		if (($fecha_ini_fac > $fecha_ini) && ($fecha_fin_fac == $fecha_fin))
		{
			// Genera 2 segmentos. El izquierdo queda pendiente y el derecho facturado.
			$segmentos["facturado"] = $this->crear_segmento("Facturado", $ini, $fin, $cantidad, $precio_unitario);
			$fecha_fin_rest = new DateTime($ini . " - 1 day", new DateTimeZone("America/Mexico_City"));
			$segmentos["pendiente"][] = $this->crear_segmento("Pendiente", $this->column_fields["fecha_ini"], $fecha_fin_rest->format("Y-m-d"));
		}

		// Caso 3: se factura la porción izquierda del por_facturar.
		//if ($fecha_fin_fac < $fecha_fin)
		if (($fecha_ini_fac == $fecha_ini) && ($fecha_fin_fac < $fecha_fin))
		{
			// Genera 2 segmentos. El izquierdo queda facturado y el derecho pendiente.
			$segmentos["facturado"] = $this->crear_segmento("Facturado", $ini, $fin, $cantidad, $precio_unitario);
			$fecha_ini_rest = new DateTime($fin . " + 1 day", new DateTimeZone("America/Mexico_City"));
			$segmentos["pendiente"][] = $this->crear_segmento("Pendiente", $fecha_ini_rest->format("Y-m-d"), $this->column_fields["fecha_fin"]);
		}

		if ($this->column_fields["segmento"])
		{
			// Si se segmenta un segmento, éste debe desaparecer.
			$consulta = "update vtiger_crmentity e set e.deleted = '1'  where e.crmid = '$pfa_id'";
			$adb->query($consulta);
		}
		else
		{
			$this->column_fields["estado"] = "Segmentado";
			$this->save("Por_facturar", $pfa_id);
		}

		return $segmentos;
	}

	// Genera un segmento de por_facturar.
	function crear_segmento($tipo, $ini, $fin, $cantidad = "", $precio_unitario = "")
	{
		$fecha_ini = new DateTime($ini, new DateTimeZone("America/Mexico_City"));
		$fecha_fin = new DateTime($fin, new DateTimeZone("America/Mexico_City"));

		$pfa = new Por_facturar;

		$pfa->column_fields["assigned_user_id"] = $this->column_fields["assigned_user_id"];
		$pfa->column_fields["sucursal"] = $this->column_fields["sucursal"];
		$pfa->column_fields["cliente"] = $this->column_fields["cliente"];
		$pfa->column_fields["obra"] = $this->column_fields["obra"];
		$pfa->column_fields["producto"] = $this->column_fields["producto"];
		$pfa->column_fields["equipo"] = $this->column_fields["equipo"];
		$pfa->column_fields["numero_serie"] = $this->column_fields["numero_serie"];
		$pfa->column_fields["periodo"] = $this->column_fields["periodo"];
		$pfa->column_fields["fecha_ini"] = $ini;
		$pfa->column_fields["fecha_fin"] = $fin;
		$pfa->column_fields["cantidad"] = $this->column_fields["cantidad"];
		$pfa->column_fields["concepto"] = $this->column_fields["concepto"];
		$diferencia = $fecha_fin->diff($fecha_ini);
		$pfa->column_fields["dias"] = $diferencia->d + 1;
		if ($tipo == "Facturado")
		{
			if ($valores["cantidad"] != "")
			{
				$pfa->column_fields["dias"] = $cantidad;
			}
			$pfa->column_fields["dias_fac"] = $pfa->column_fields["dias"];
			$pfa->column_fields["cantidad_fac"] = $pfa->column_fields["cantidad"];
			$pfa->column_fields["precio_unitario_fac"] = $precio_unitario;
		}
		$pfa->column_fields["estado"] = $tipo;
		$pfa->column_fields["segmento"] = 1;
		if ($this->column_fields["segmento"])
		{
			$pfa->column_fields["contenedor"] = $this->column_fields["contenedor"];
		}
		else
		{
			$pfa->column_fields["contenedor"] = $this->obtener_id();
		}
		$pfa->save("Por_facturar");

		return $pfa->obtener_id();
	}

	// Une segmentos consecutivos.
	function unir()
	{
		global $adb;

		$pfa_id = $this->obtener_id();

		// Primero revisa si todos los segmentos están disponibles (no hay ninguno facturado).
		$consulta = "select count(pfa.por_facturarid) as existe from vtiger_por_facturar pfa, vtiger_crmentity e where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.contenedor = '$pfa_id' and pfa.estado = 'Facturado' and pfa.segmento = '1'";
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);

//var_dump($renglon);
		if ($renglon["existe"] == "0")
		{
			$this->estado("Pendiente");

			$consulta = "update vtiger_por_facturar pfa, vtiger_crmentity e set e.deleted = '1' where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.contenedor = '$pfa_id' and pfa.estado = 'Pendiente' and pfa.segmento = '1'";
			$adb->query($consulta);
		}
		else
		{
			// Este por_facturar (contenedor) permanece segmentado y se busca unir los segmentos pendientes contiguos.
			$consulta = "select pfa.* from vtiger_por_facturar pfa, vtiger_crmentity e where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.contenedor = '$pfa_id' and pfa.segmento = '1' order by pfa.fecha_ini";
			$resultado = $adb->query($consulta);
			$i = 0;
			while ($renglon = $adb->fetch_array($resultado))
			{
				//var_dump($renglon["idv"]);
				if ($renglon["estado"] == "Pendiente")
				{
					if ($segmentos[$i]["ini"] == "")
					{
						$segmentos[$i]["ini"] = $renglon["fecha_ini"];
					}
					$segmentos[$i]["fin"] = $renglon["fecha_fin"];
				}
				else
				{
					$i++;
				}
			}

			// Borra los segmentos pendientes anteriores para generar los nuevos.
			$consulta = "update vtiger_por_facturar pfa, vtiger_crmentity e set e.deleted = '1' where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.contenedor = '$pfa_id' and pfa.estado = 'Pendiente' and pfa.segmento = '1'";
			$adb->query($consulta);

			// Crea los nuevos segmentos.
			if (is_array($segmentos))
			{
				foreach ($segmentos as $segmento)
				{
					//echo "<pre>";
					//var_dump($segmento);
					//echo "</pre>";
					$this->crear_segmento("Pendiente", $segmento["ini"], $segmento["fin"]);
				}
			}
		}
	}
}
?>
