<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
require_once("config.php");
require_once('include/utils/utils.php');
require_once('modules/Periodos/Periodos.php');
require_once('modules/Flota_renta/Flota_renta.php');
require_once('modules/Kardex/Kardex.php');
require_once('modules/Ordenes_trabajo/Ordenes_trabajo.php');
require_once('modules/Por_facturar/Por_facturar.php');
require_once('modules/Users/Users.php');

class Cambios extends CRMEntity {
	var $db, $log; // Used in class functions of CRMEntity

	var $table_name = 'vtiger_cambios';
	var $table_index= 'cambiosid';
	var $column_fields = Array();

	/** Indicator if this is a custom module or standard module */
	var $IsCustomModule = true;

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_cambioscf', 'cambiosid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_cambios', 'vtiger_cambioscf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_cambios'   => 'cambiosid',
	    'vtiger_cambioscf' => 'cambiosid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Cambios Name'=> Array('cambios', 'idv'),
		'Assigned To' => Array('crmentity','smownerid')
	);
	var $list_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Cambios Name'=> 'idv',
		'Assigned To' => 'assigned_user_id'
	);

	// Make the field link to detail view from list view (Fieldname)
	var $list_link_field = 'idv';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Cambios Name'=> Array('cambios', 'idv')
	);
	var $search_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Cambios Name'=> 'idv'
	);

	// For Popup window record selection
	var $popup_fields = Array('idv');

	// Placeholder for sort fields - All the fields will be initialized for Sorting through initSortFields
	var $sortby_fields = Array();

	// For Alphabetical search
	var $def_basicsearch_col = 'idv';

	// Column value to use on detail view record text display
	var $def_detailview_recname = 'idv';

	// Required Information for enabling Import feature
	var $required_fields = Array('idv'=>1);

	// Callback function list during Importing
	var $special_functions = Array('set_import_assigned_user');

	var $default_order_by = 'idv';
	var $default_sort_order='ASC';
	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('createdtime', 'modifiedtime', 'idv');
	
	function __construct() {
		global $log, $currentModule;
		$this->column_fields = getColumnFields($currentModule);
		$this->db = PearDatabase::getInstance();
		$this->log = $log;
	}

	function getSortOrder() {
		global $currentModule;

		$sortorder = $this->default_sort_order;
		if($_REQUEST['sorder']) $sortorder = $this->db->sql_escape_string($_REQUEST['sorder']);
		else if($_SESSION[$currentModule.'_Sort_Order']) 
			$sortorder = $_SESSION[$currentModule.'_Sort_Order'];

		return $sortorder;
	}

	function getOrderBy() {
		global $currentModule;
		
		$use_default_order_by = '';		
		if(PerformancePrefs::getBoolean('LISTVIEW_DEFAULT_SORTING', true)) {
			$use_default_order_by = $this->default_order_by;
		}
		
		$orderby = $use_default_order_by;
		if($_REQUEST['order_by']) $orderby = $this->db->sql_escape_string($_REQUEST['order_by']);
		else if($_SESSION[$currentModule.'_Order_By'])
			$orderby = $_SESSION[$currentModule.'_Order_By'];
		return $orderby;
	}

	function save_module($module) {
		$this->asignar_dueno();
		$this->concatenar_numeros_internos("Cambios");
	}

	/**
	 * Return query to use based on given modulename, fieldname
	 * Useful to handle specific case handling for Popup
	 */
	function getQueryByModuleField($module, $fieldname, $srcrecord, $query='') {
		// $srcrecord could be empty
	}

	/**
	 * Get list view query (send more WHERE clause condition if required)
	 */
	function getListQuery($module, $usewhere='') {
		$query = "SELECT vtiger_crmentity.*, $this->table_name.*";
		
		// Keep track of tables joined to avoid duplicates
		$joinedTables = array();

		// Select Custom Field Table Columns if present
		if(!empty($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$query .= " FROM $this->table_name";

		$query .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		$joinedTables[] = $this->table_name;
		$joinedTables[] = 'vtiger_crmentity';
		
		// Consider custom table join as well.
		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index";
			$joinedTables[] = $this->customFieldTable[0]; 
		}
		$query .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";

		$joinedTables[] = 'vtiger_users';
		$joinedTables[] = 'vtiger_groups';
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($module));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);
		
		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other =  CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			if(!in_array($other->table_name, $joinedTables)) {
				$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
				$joinedTables[] = $other->table_name;
			}
		}

		global $current_user;
		$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
		$query .= "	WHERE vtiger_crmentity.deleted = 0 ".$usewhere;
		return $query;
	}

	/**
	 * Apply security restriction (sharing privilege) query part for List view.
	 */
	function getListViewSecurityParameter($module) {
		global $current_user;
		require('user_privileges/user_privileges_'.$current_user->id.'.php');
		require('user_privileges/sharing_privileges_'.$current_user->id.'.php');

		$sec_query = '';
		$tabid = getTabid($module);

		if($is_admin==false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 
			&& $defaultOrgSharingPermission[$tabid] == 3) {

				$sec_query .= " AND (vtiger_crmentity.smownerid in($current_user->id) OR vtiger_crmentity.smownerid IN 
					(
						SELECT vtiger_user2role.userid FROM vtiger_user2role 
						INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid 
						INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid 
						WHERE vtiger_role.parentrole LIKE '".$current_user_parent_role_seq."::%'
					) 
					OR vtiger_crmentity.smownerid IN 
					(
						SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per 
						WHERE userid=".$current_user->id." AND tabid=".$tabid."
					) 
					OR 
						(";
		
					// Build the query based on the group association of current user.
					if(sizeof($current_user_groups) > 0) {
						$sec_query .= " vtiger_groups.groupid IN (". implode(",", $current_user_groups) .") OR ";
					}
					$sec_query .= " vtiger_groups.groupid IN 
						(
							SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid 
							FROM vtiger_tmp_read_group_sharing_per
							WHERE userid=".$current_user->id." and tabid=".$tabid."
						)";
				$sec_query .= ")
				)";
		}
		return $sec_query;
	}

	/**
	 * Create query to export the records.
	 */
	function create_export_query($where)
	{
		global $current_user;
		$thismodule = $_REQUEST['module'];
		
		include("include/utils/ExportUtils.php");

		//To get the Permitted fields query and the permitted fields list
		$sql = getPermittedFieldsQuery($thismodule, "detail_view");
		
		$fields_list = getFieldsListFromQuery($sql);

		$query = "SELECT $fields_list, vtiger_users.user_name AS user_name 
					FROM vtiger_crmentity INNER JOIN $this->table_name ON vtiger_crmentity.crmid=$this->table_name.$this->table_index";

		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}

		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id and vtiger_users.status='Active'";
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($thismodule));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);

		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other = CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
		}

		$query .= $this->getNonAdminAccessControlQuery($thismodule,$current_user);
		$where_auto = " vtiger_crmentity.deleted=0";

		if($where != '') $query .= " WHERE ($where) AND $where_auto";
		else $query .= " WHERE $where_auto";

		return $query;
	}

	/**
	 * Initialize this instance for importing.
	 */
	function initImport($module) {
		$this->db = PearDatabase::getInstance();
		$this->initImportableFields($module);
	}

	/**
	 * Create list query to be shown at the last step of the import.
	 * Called From: modules/Import/UserLastImport.php
	 */
	function create_import_query($module) {
		global $current_user;
		$query = "SELECT vtiger_crmentity.crmid, case when (vtiger_users.user_name not like '') then vtiger_users.user_name else vtiger_groups.groupname end as user_name, $this->table_name.* FROM $this->table_name
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index
			LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=vtiger_crmentity.crmid
			LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			WHERE vtiger_users_last_import.assigned_user_id='$current_user->id'
			AND vtiger_users_last_import.bean_type='$module'
			AND vtiger_users_last_import.deleted=0";
		return $query;
	}

	/**
	 * Delete the last imported records.
	 */
	function undo_import($module, $user_id) {
		global $adb;
		$count = 0;
		$query1 = "select bean_id from vtiger_users_last_import where assigned_user_id=? AND bean_type='$module' AND deleted=0";
		$result1 = $adb->pquery($query1, array($user_id)) or die("Error getting last import for undo: ".mysql_error()); 
		while ( $row1 = $adb->fetchByAssoc($result1))
		{
			$query2 = "update vtiger_crmentity set deleted=1 where crmid=?";
			$result2 = $adb->pquery($query2, array($row1['bean_id'])) or die("Error undoing last import: ".mysql_error()); 
			$count++;			
		}
		return $count;
	}
	
	/**
	 * Transform the value while exporting
	 */
	function transform_export_value($key, $value) {
		return parent::transform_export_value($key, $value);
	}

	/**
	 * Function which will set the assigned user id for import record.
	 */
	function set_import_assigned_user()
	{
		global $current_user, $adb;
		$record_user = $this->column_fields["assigned_user_id"];
		
		if($record_user != $current_user->id){
			$sqlresult = $adb->pquery("select id from vtiger_users where id = ? union select groupid as id from vtiger_groups where groupid = ?", array($record_user, $record_user));
			if($this->db->num_rows($sqlresult)!= 1) {
				$this->column_fields["assigned_user_id"] = $current_user->id;
			} else {			
				$row = $adb->fetchByAssoc($sqlresult, -1, false);
				if (isset($row['id']) && $row['id'] != -1) {
					$this->column_fields["assigned_user_id"] = $row['id'];
				} else {
					$this->column_fields["assigned_user_id"] = $current_user->id;
				}
			}
		}
	}
	
	/** 
	 * Function which will give the basic query to find duplicates
	 */
	function getDuplicatesQuery($module,$table_cols,$field_values,$ui_type_arr,$select_cols='') {
		$select_clause = "SELECT ". $this->table_name .".".$this->table_index ." AS recordid, vtiger_users_last_import.deleted,".$table_cols;

		// Select Custom Field Table Columns if present
		if(isset($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$from_clause = " FROM $this->table_name";

		$from_clause .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		// Consider custom table join as well.
		if(isset($this->customFieldTable)) {
			$from_clause .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}
		$from_clause .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
						LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		
		$where_clause = "	WHERE vtiger_crmentity.deleted = 0";
		$where_clause .= $this->getListViewSecurityParameter($module);
					
		if (isset($select_cols) && trim($select_cols) != '') {
			$sub_query = "SELECT $select_cols FROM  $this->table_name AS t " .
				" INNER JOIN vtiger_crmentity AS crm ON crm.crmid = t.".$this->table_index;
			// Consider custom table join as well.
			if(isset($this->customFieldTable)) {
				$sub_query .= " LEFT JOIN ".$this->customFieldTable[0]." tcf ON tcf.".$this->customFieldTable[1]." = t.$this->table_index";
			}
			$sub_query .= " WHERE crm.deleted=0 GROUP BY $select_cols HAVING COUNT(*)>1";	
		} else {
			$sub_query = "SELECT $table_cols $from_clause $where_clause GROUP BY $table_cols HAVING COUNT(*)>1";
		}	
		
		
		$query = $select_clause . $from_clause .
					" LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=" . $this->table_name .".".$this->table_index .
					" INNER JOIN (" . $sub_query . ") AS temp ON ".get_on_clause($field_values,$ui_type_arr,$module) .
					$where_clause .
					" ORDER BY $table_cols,". $this->table_name .".".$this->table_index ." ASC";
					
		return $query;		
	}

	/**
	 * Invoked when special actions are performed on the module.
	 * @param String Module name
	 * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
	 */
	function vtlib_handler($modulename, $event_type) {
		if($event_type == 'module.postinstall') {
			// TODO Handle post installation actions
		} else if($event_type == 'module.disabled') {
			// TODO Handle actions when this module is disabled.
		} else if($event_type == 'module.enabled') {
			// TODO Handle actions when this module is enabled.
		} else if($event_type == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($event_type == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($event_type == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
	}

	/** 
	 * Handle saving related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	// function save_related_module($module, $crmid, $with_module, $with_crmid) { }
	
	/**
	 * Handle deleting related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function delete_related_module($module, $crmid, $with_module, $with_crmid) { }

	/**
	 * Handle getting related list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_related_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	/**
	 * Handle getting dependents list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_dependents_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	function procesar()
	{
        	// Abre la sesión PHP.
        	session_start();

        	// Carga definiciones de campos personalizados.
        	require("campos_personalizados.php");

/**********************************
echo "<pre>";
var_dump($this->column_fields);
die;
        	// Carga usuario actual.
        	$current_user = new Users();
        	$current_user->retrieveCurrentUserInfoFromFile($_SESSION["authenticated_user_id"]);
**********************************/

        	global $adb, $current_user;

                $id_cambio = (int)$this->column_fields["record_id"];
                $folio_cambio = $this->column_fields["folio"];

        	// Obtiene el id del cliente.
        	$id_cliente = $this->column_fields["cliente"];

        	// Obtiene el id de la obra.
        	$id_obra = $this->column_fields["obra"];
	
        	// Obtiene el id de la sucursal.
        	$id_sucursal = $this->column_fields["sucursal"];
	
        	// Carga la sucursal.
        	$sucursal = new Sucursales;
        	$sucursal->retrieve_entity_info($id_sucursal, "Sucursales");
	
        	// Hace un barrido para aplicar las recolecciones y las nuevas entregas.
        	for ($i = 1; $i <= 5; $i++)
        	{
                	// Obtiene el id de los equipos a recoger y a entregar.
                	$id_equipo_recoger = $this->column_fields["recoger{$i}_equipo"];
                	$id_equipo_entregar = $this->column_fields["entrega{$i}_equipo"];
	
			$cantidad_recoleccion = $this->column_fields["recoger{$i}_cantidad"];
			$cantidad_entrega = $this->column_fields["entrega{$i}_cantidad"];

                	if ($id_equipo_recoger)
                	{
                        	if (!$id_equipo_entregar)
                        	{
                                	die("<h1>ERROR</h1>No se indicó el equipo a entregar.");
                        	}
                        	// Actualiza el registro de flota de renta correspondiente al equipo que se recoge.
                        	$flota_renta_recoger = new Flota_renta;
                        	$flota_renta_recoger->retrieve_entity_info($id_equipo_recoger, "Flota_renta");
				$producto = new Products;
				$producto->retrieve_entity_info($flota_renta_recoger->column_fields["producto"], "Products");
				$individual = $producto->individual();

				if ($individual)
				{
                        		$flota_renta_recoger->column_fields["estado"] = "En servicio";
                        		$flota_renta_recoger->column_fields["cliente"] = $sucursal->column_fields["cliente_mks"];
                        		$flota_renta_recoger->column_fields["obra"] = $sucursal->column_fields["obra_mks"];
                        		$flota_renta_recoger->save("Flota_renta", $id_equipo_recoger);
				}
				else
				{
					// Crea o actualiza, según sea el caso, el registro de detalle de flota.
					$flota_renta_recoger->detalle($folio_cambio, $cantidad_recoleccion * -1);
		
					// Actualiza la cantidad del registro de flota.
					$flota_renta_recoger->actualizar_cantidad();

					// Busca un posible registro existente de flota en servicio.
					$consulta = "select flr.flota_rentaid, flr.numeros_serieid from vtiger_flota_renta flr, vtiger_crmentity e where e.crmid = flr.flota_rentaid and e.deleted = '0' and flr.estado = 'En servicio' and flr.obrasid = '".$sucursal->column_fields["obra_mks"]."' and flr.numero_interno = '".$flota_renta_recoger->column_fields["numero_interno"]."'";
                                	$resultado = $adb->query($consulta);
                                	$renglon = $adb->fetch_array($resultado);

					$id_flr_servicio = $renglon["flota_rentaid"];

                                	$flota_renta_servicio = new Flota_renta;
					if ($id_flr_servicio != "")
					{
                                		$flota_renta_servicio->retrieve_entity_info($id_flr_servicio, "Flota_renta");
					}
                                	$flota_renta_servicio->column_fields["assigned_user_id"] = $current_user->id;
                                	$flota_renta_servicio->column_fields["estado"] = "En servicio";
                                	$flota_renta_servicio->column_fields["cliente"] = $sucursal->column_fields["cliente_mks"];
                                	$flota_renta_servicio->column_fields["obra"] = $sucursal->column_fields["obra_mks"];
                                	$flota_renta_servicio->column_fields["numero_interno"] = $flota_renta->column_fields["numero_interno"];
                                	$flota_renta_servicio->column_fields["producto"] = $flota_renta->column_fields["producto"];
                                	$flota_renta_servicio->save("Flota_renta", $id_flr_servicio);
//var_dump($renglon);
//var_dump($consulta);
					// Crea o actualiza, según sea el caso, el registro de detalle de flota.
					$flota_renta_servicio->detalle($folio_recoleccion, $cantidad_recoleccion);
		
					// Actualiza la cantidad del registro de flota.
					$flota_renta_servicio->actualizar_cantidad();
				}
	
                        	// Actualiza el registro de flota de renta correspondiente al equipo que se entrega.
                        	$flota_renta_entregar = new Flota_renta;
                        	$flota_renta_entregar->retrieve_entity_info($id_equipo_entregar, "Flota_renta");

				$producto = new Products;
				$producto->retrieve_entity_info($flota_renta_entregar->column_fields["producto"], "Products");
				$individual = $producto->individual();

				if ($individual)
				{
                        		$flota_renta_entregar->column_fields["estado"] = "En obra";
                        		$flota_renta_entregar->column_fields["cliente"] = $id_cliente;
                        		$flota_renta_entregar->column_fields["obra"] = $id_obra;
                        		$flota_renta_entregar->save("Flota_renta", $id_equipo_entregar);
				}
				else
				{
					// Crea o actualiza, según sea el caso, el registro de detalle de flota.
					$flota_renta_entregar->detalle($folio_cambio, $cantidad_entrega * -1);
		
					// Actualiza la cantidad del registro de flota.
					$flota_renta_entregar->actualizar_cantidad();

					// Busca un posible registro existente de flota en esta obra.
					$consulta = "select flr.flota_rentaid, flr.numeros_serieid from vtiger_flota_renta flr, vtiger_crmentity e where e.crmid = flr.flota_rentaid and e.deleted = '0' and flr.estado = 'En obra' and flr.obrasid = '".$this->column_fields["obra"]."' and flr.numero_interno = '".$flota_renta_entregar->column_fields["numero_interno"]."'";
                                	$resultado = $adb->query($consulta);
                                	$renglon = $adb->fetch_array($resultado);

					$id_flr_obra = $renglon["flota_rentaid"];

                                	$flota_renta_obra = new Flota_renta;
					if ($id_flr_obra != "")
					{
                                		$flota_renta_obra->retrieve_entity_info($id_flr_obra, "Flota_renta");
					}
                                	$flota_renta_obra->column_fields["assigned_user_id"] = $current_user->id;
                                	$flota_renta_obra->column_fields["estado"] = "En obra";
                                	$flota_renta_obra->column_fields["cliente"] = $this->column_fields["cliente"];
                                	$flota_renta_obra->column_fields["obra"] = $this->column_fields["obra"];
                                	$flota_renta_obra->column_fields["numero_interno"] = $flota_renta->column_fields["numero_interno"];
                                	$flota_renta_obra->column_fields["producto"] = $flota_renta->column_fields["producto"];
                                	$flota_renta_obra->save("Flota_renta", $id_flr_obra);
//var_dump($renglon);
				}
	
	
/*********************reco
				$id_flr = ($individual)?$id_equipo:$flota_renta_servicio->obtener_id();
				// Busca si ya existe un periodo registrado para esta recolección.
				//$consulta = "select per.periodosid from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.movimiento_cierre = '$folio_recoleccion'";
				$consulta = "select per.periodosid from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.flota_rentaid = '$id_flr' and per.movimiento_cierre = '$folio_recoleccion'";
*************************/
                        	// Busca el periodo de renta abierto del equipo que se recoge.
                        	$consulta = "select per.periodosid from vtiger_periodos per, vtiger_crmentity e where per.flota_rentaid = '$id_equipo_recoger' and per.estado = 'Abierto' and e.crmid = per.periodosid and e.deleted = '0'";
                        	$resultado = $adb->query($consulta);
                        	$renglon = $adb->fetch_array($resultado);
	
                        	// Instancia el periodo de renta y lo cierra.
                        	if ($renglon["periodosid"])
                        	{
                                	$periodo_recoger = new Periodos;
                                	$periodo_recoger->retrieve_entity_info($renglon["periodosid"], "Periodos");
                                	$periodo_recoger->column_fields["estado"] = "Cerrado";
                                	$periodo_recoger->column_fields["fecha_fin"] = $this->column_fields["fecha_efectiva"];
                                	$periodo_recoger->column_fields["movimiento_cierre"] = $this->column_fields["folio"];
                                	$periodo_recoger->save("Periodos", $renglon["periodosid"]);
                                	$periodo_recoger->facturar($this->column_fields["fecha_efectiva"], TRUE);
                        	}
	
/************************entr
                                // Crea o actualiza, según sea el caso, el periodo de renta correspondiente.
				$id_flr = ($individual)?$id_equipo:$flota_renta_obra->obtener_id();
				//$consulta = "select per.* from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.flota_rentaid = '$id_equipo'";
				//$consulta = "select per.* from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.flota_rentaid = '$id_flr'";
				$consulta = "select per.* from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.flota_rentaid = '$id_flr' and per.movimiento_apertura = '".$this->column_fields["folio"]."'";
**************************/
                        	// Abre un nuevo periodo de renta, correspondiente al equipo que se entrega.
                                // Crea o actualiza, según sea el caso, el periodo de renta correspondiente.
				$id_flr = ($individual)?$id_equipo_entregar:$flota_renta_obra->obtener_id();
				$consulta = "select per.* from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.flota_rentaid = '$id_flr' and per.movimiento_apertura = '".$this->column_fields["folio"]."'";
//var_dump($consulta);
                                $resultado = $adb->query($consulta);
                                $renglon = $adb->fetch_array($resultado);
                                $id_periodo = $renglon["periodosid"];

                        	$periodo_entregar = new Periodos;
                                if ($id_periodo != "")
                                {
                                        $periodo_entregar->retrieve_entity_info($id_periodo, "Periodos");
                                }

                        	$periodo_entregar->column_fields["estado"] = "Abierto";
                        	$periodo_entregar->column_fields["assigned_user_id"] = $current_user->id;
                        	$periodo_entregar->column_fields["sucursal"] = $id_sucursal;
                        	$periodo_entregar->column_fields["cliente"] = $id_cliente;
                        	$periodo_entregar->column_fields["obra"] = $id_obra;
                        	//$periodo_entregar->column_fields["equipo"] = $id_equipo_entregar;
                        	$periodo_entregar->column_fields["equipo"] = $id_flr;
                                $periodo_entregar->column_fields["cantidad"] = $cantidad_entrega;
                        	$periodo_entregar->column_fields["fecha_ini"] = $this->column_fields["fecha_efectiva"];
                                $periodo_entregar->column_fields["movimiento_apertura"] = $this->column_fields["folio"];
                        	$periodo_entregar->save("Periodos", $id_periodo);
	
	
                                // Crea o actualiza, según sea el caso, la correspondiente orden de trabajo.
				$consulta = "select ot.ordenes_trabajoid from vtiger_ordenes_trabajo ot, vtiger_crmentity e where e.crmid = ot.ordenes_trabajoid and e.deleted = '0' and ot.movimiento = '".$this->column_fields["folio"]."'";
//var_dump($consulta);
//echo "<pre>";
                        	$resultado = $adb->query($consulta);
                        	$renglon = $adb->fetch_array($resultado);
//var_dump($renglon);
				$id_ot = $renglon["ordenes_trabajoid"];

                        	$ot = new Ordenes_trabajo;

                                if ($id_ot != "")
                                {
                                        $ot->retrieve_entity_info($id_ot, "Ordenes_trabajo");
                                }

                        	$ot->column_fields["assigned_user_id"] = $current_user->id;
                        	$ot->column_fields["sucursal"] = $this->column_fields["sucursal"];
                        	$ot->column_fields["equipo"] = $id_equipo_recoger;
                        	//$ot->column_fields["estado"] = "Abierta";
                        	$ot->column_fields["estado"] = "Abierto";
                        	$ot->column_fields["fecha_ini"] = $this->column_fields["fecha_efectiva"];
                                $ot->column_fields["movimiento"] = $this->column_fields["folio"];
                        	$ot->save("Ordenes_trabajo", $id_ot);
				if ($ot->column_fields["folio"] == "")
				{
					$ot->asignar_folio();
				}
				$folio_ot = $ot->column_fields["folio"];
//var_dump($folio_ot);
	
				/************************************
                        	// Registra la recolección en el kardex.
                        	$kardex = new Kardex;
                        	$kardex->column_fields["assigned_user_id"] = $current_user->id;
                        	$kardex->column_fields["codigo"] = $flota_renta_recoger->column_fields["numero_interno"];
                        	$kardex->column_fields["numero_serie"] = $flota_renta_recoger->column_fields["numero_serie"];
                        	$kardex->column_fields["fecha"] = $this->column_fields["fecha_efectiva"];
                        	$kardex->column_fields["tipo_documento"] = "Cambio";
                        	$kardex->column_fields["movimiento"] = $this->column_fields["folio"];
                        	$kardex->column_fields["existencia_inicial"] = 1;
                        	$kardex->column_fields["entradas"] = 0;
                        	$kardex->column_fields["salidas"] = 0;
                        	$kardex->column_fields["existencia_final"] = 1;
                        	$kardex->save("Kardex");
	
                        	// Registra la orden de trabajo en el kardex.
                        	$kardex = new Kardex;
                        	$kardex->column_fields["assigned_user_id"] = $current_user->id;
                        	$kardex->column_fields["codigo"] = $flota_renta_recoger->column_fields["numero_interno"];
                        	$kardex->column_fields["numero_serie"] = $flota_renta_recoger->column_fields["numero_serie"];
                        	$kardex->column_fields["fecha"] = $this->column_fields["fecha_efectiva"];
                        	$kardex->column_fields["tipo_documento"] = "Orden de trabajo";
                        	$kardex->column_fields["movimiento"] = $ot->column_fields["folio"];
                        	$kardex->column_fields["existencia_inicial"] = 1;
                        	$kardex->column_fields["entradas"] = 0;
                        	$kardex->column_fields["salidas"] = 0;
                        	$kardex->column_fields["existencia_final"] = 1;
                        	$kardex->save("Kardex");
				************************************/
				// Registra la recolección en kardex y existencias.
				unset($parametros);
				$parametros["sucursal"] = $this->column_fields["sucursal"];
				$parametros["almacen"] = $sucursal->column_fields["almacen_flota"];
                        	$parametros["tipo_documento"] = "Cambio";
				$parametros["folio"] = $this->column_fields["folio"];
				$parametros["fecha"] = $this->column_fields["fecha_efectiva"];
				$parametros["producto"] = $flota_renta_recoger->column_fields["producto"];
                        	$parametros["codigo_articulo"] = $flota_renta_recoger->column_fields["numero_interno"];
				$parametros["entradas"] = 0;
				$parametros["salidas"] = 0;
				$this->kardex($parametros);

				// Registra la orden de trabajo en kardex y existencias.
				unset($parametros);
				$parametros["sucursal"] = $this->column_fields["sucursal"];
				$parametros["almacen"] = $sucursal->column_fields["almacen_flota"];
                        	$parametros["tipo_documento"] = "Orden de trabajo";
				$parametros["folio"] = $ot->column_fields["folio"];
				$parametros["fecha"] = $this->column_fields["fecha_efectiva"];
				$parametros["producto"] = $flota_renta_recoger->column_fields["producto"];
                        	$parametros["codigo_articulo"] = $flota_renta_recoger->column_fields["numero_interno"];
				$parametros["entradas"] = 0;
				$parametros["salidas"] = 0;
				$this->kardex($parametros);
	
				/*************************************
                        	// Registra la entrega en el kardex.
                        	$kardex = new Kardex;
                        	$kardex->column_fields["assigned_user_id"] = $current_user->id;
                        	$kardex->column_fields["codigo"] = $flota_renta_entregar->column_fields["numero_interno"];
                        	$kardex->column_fields["numero_serie"] = $flota_renta_entregar->column_fields["numero_serie"];
                        	$kardex->column_fields["fecha"] = $this->column_fields["fecha_efectiva"];
                        	$kardex->column_fields["tipo_documento"] = "Cambio";
                        	$kardex->column_fields["movimiento"] = $this->column_fields["folio"];
                        	$kardex->column_fields["existencia_inicial"] = 1;
                        	$kardex->column_fields["entradas"] = 0;
                        	$kardex->column_fields["salidas"] = 0;
                        	$kardex->column_fields["existencia_final"] = 1;
                        	$kardex->save("Kardex");
//var_dump($folio_ot);
				************************************/
				// Registra la entrega en kardex y existencias.
				unset($parametros);
				$parametros["sucursal"] = $this->column_fields["sucursal"];
				$parametros["almacen"] = $sucursal->column_fields["almacen_flota"];
                        	$parametros["tipo_documento"] = "Cambio";
				$parametros["folio"] = $this->column_fields["folio"];
				$parametros["fecha"] = $this->column_fields["fecha_efectiva"];
				$parametros["producto"] = $flota_renta_entregar->column_fields["producto"];
                        	$parametros["codigo_articulo"] = $flota_renta_entregar->column_fields["numero_interno"];
				$parametros["entradas"] = 0;
				$parametros["salidas"] = 0;
				$this->kardex($parametros);
                	}
        	}
//die;
	}
}
?>
