<?php
require_once("config.php");
require_once("include/utils/utils.php");
require_once("modules/Movimientos_flota/Movimientos_flota.php");
require_once("modules/Users/Users.php");

// Abre la sesión PHP.
session_start();

// Carga datos de usuario.
$current_user = new Users();
$current_user->retrieveCurrentUserInfoFromFile($_SESSION["authenticated_user_id"]);

global $adb;

$procesar["afr"] = 0;
$procesar["ent"] = 0;
$procesar["rco"] = 0;
$procesar["cam"] = 0;
$procesar["ot"] = 0;

if ($procesar["afr"])
{
	// Carga altas a flota.
	$consulta = "select kdx.*, afr.* from vtiger_kardex kdx, vtiger_crmentity e, vtiger_altas_flota_renta afr, vtiger_crmentity e2 where e.crmid = kdx.kardexid and e.deleted = '0' and e2.crmid = afr.altas_flota_rentaid and e2.deleted = '0' and kdx.tipo_documento like 'Alta%' and kdx.almacenesid = '130' and afr.folio = kdx.movimiento order by afr.fecha_efectiva, afr.hora_efectiva";
	//var_dump($consulta);
	//die;
	$resultado = $adb->query($consulta);
	echo "<table>";
	while ($renglon = $adb->fetch_array($resultado))
	{
		echo "<tr>";
		echo "<td>";
		echo $renglon["folio"];
		echo "</td>";
		echo "<td>";
		echo $renglon["fecha_efectiva"];
		echo "</td>";
		echo "<td>";
		echo $renglon["hora_efectiva"];
		echo "</td>";
		echo "</tr>";
		$mfl = new Movimientos_flota;
		$mfl->column_fields["assigned_user_id"] = $current_user->id;
		$mfl->column_fields["mfl_tipo"] = "Alta a flota de renta";
		$mfl->column_fields["mfl_alta_flota"] = $renglon["altas_flota_rentaid"];
		$mfl->column_fields["mfl_codigo"] = $renglon["codigo"];
		$mfl->column_fields["mfl_cantidad"] = $renglon["cantidad"];
		$mfl->column_fields["mfl_flrd"] = $renglon["cantidad"];
		$mfl->column_fields["mfl_flro"] = 0;
		$mfl->column_fields["mfl_flrs"] = 0;
		$mfl->column_fields["mfl_flroe"] = 0;
		$mfl->column_fields["mfl_fecha_efectiva"] = $renglon["fecha_efectiva"];
		$mfl->column_fields["mfl_hora_efectiva"] = $renglon["hora_efectiva"];
		$mfl->save("Movimientos_flota");
	//die;
	}
	echo "</table>";
	echo "Finalizado.";
}

if ($procesar["ent"])
{
	// Carga entregas.
	$consulta = "select ent.* from vtiger_entregas ent, vtiger_crmentity e where e.crmid = ent.entregasid and e.deleted = '0' and ent.accountid != '' and ent.obrasid != '' order by ent.fecha_efectiva, ent.hora_efectiva";
	//var_dump($consulta);
	//die;
	$resultado = $adb->query($consulta);
	echo "<table>";
	while ($renglon = $adb->fetch_array($resultado))
	{
		echo "<tr>";
		echo "<td>";
		echo $renglon["folio"];
		echo "</td>";
		echo "<td>";
		echo $renglon["fecha_efectiva"];
		echo "</td>";
		echo "<td>";
		echo $renglon["hora_efectiva"];
		echo "</td>";

		for ($i = 1; $i <= 10; $i++)
		{
			if ($renglon["entrega{$i}_equipo"] != "")
			{
				$consulta2 = "select flr.numero_interno from vtiger_flota_renta flr where flr.flota_rentaid = '".$renglon["entrega{$i}_equipo"]."'";
				$resultado2 = $adb->query($consulta2);
				$renglon2 = $adb->fetch_array($resultado2);
				echo "<td>";
				echo $renglon2["numero_interno"];
				echo "</td>";
				echo "<td>";
				echo $renglon["entrega{$i}_cantidad"];
				echo "</td>";

				$mfl = new Movimientos_flota;
				$mfl->column_fields["assigned_user_id"] = $current_user->id;
				$mfl->column_fields["mfl_tipo"] = "Entrega";
				$mfl->column_fields["mfl_entrega"] = $renglon["entregasid"];
				$mfl->column_fields["mfl_codigo"] = $renglon2["numero_interno"];
				$mfl->column_fields["mfl_cantidad"] = $renglon["entrega{$i}_cantidad"];
				$mfl->column_fields["mfl_flrd"] = $renglon["entrega{$i}_cantidad"] * -1;
				$mfl->column_fields["mfl_flro"] = $renglon["entrega{$i}_cantidad"];
				$mfl->column_fields["mfl_flrs"] = 0;
				$mfl->column_fields["mfl_flroe"] = $renglon["entrega{$i}_cantidad"];
				$mfl->column_fields["mfl_cliente"] = $renglon["accountid"];
				$mfl->column_fields["mfl_obra"] = $renglon["obrasid"];
				$mfl->column_fields["mfl_fecha_efectiva"] = $renglon["fecha_efectiva"];
				$mfl->column_fields["mfl_hora_efectiva"] = $renglon["hora_efectiva"];
				$mfl->save("Movimientos_flota");
			}
		}
		echo "</tr>";
	//die;
	}
	echo "</table>";
	echo "Finalizado.";
}

if ($procesar["rco"])
{
	// Carga recolecciones.
	$consulta = "select rco.* from vtiger_recolecciones rco, vtiger_crmentity e where e.crmid = rco.recoleccionesid and e.deleted = '0' and rco.accountid != '' and rco.obrasid != '' order by rco.fecha_efectiva, rco.hora_efectiva";
	//var_dump($consulta);
	//die;
	$resultado = $adb->query($consulta);
	echo "<table>";
	while ($renglon = $adb->fetch_array($resultado))
	{
		echo "<tr>";
		echo "<td>";
		echo $renglon["folio"];
		echo "</td>";
		echo "<td>";
		echo $renglon["fecha_efectiva"];
		echo "</td>";
		echo "<td>";
		echo $renglon["hora_efectiva"];
		echo "</td>";

		for ($i = 1; $i <= 10; $i++)
		{
			if ($renglon["recoger{$i}_equipo"] != "")
			{
				$consulta2 = "select flr.numero_interno from vtiger_flota_renta flr where flr.flota_rentaid = '".$renglon["recoger{$i}_equipo"]."'";
				$resultado2 = $adb->query($consulta2);
				$renglon2 = $adb->fetch_array($resultado2);
				echo "<td>";
				echo $renglon2["numero_interno"];
				echo "</td>";
				echo "<td>";
				echo $renglon["recoger{$i}_cantidad"];
				echo "</td>";

				$mfl = new Movimientos_flota;
				$mfl->column_fields["assigned_user_id"] = $current_user->id;
				$mfl->column_fields["mfl_tipo"] = "Recolección";
				$mfl->column_fields["mfl_recoleccion"] = $renglon["recoleccionesid"];
				$mfl->column_fields["mfl_codigo"] = $renglon2["numero_interno"];
				$mfl->column_fields["mfl_cantidad"] = $renglon["recoger{$i}_cantidad"];
				$mfl->column_fields["mfl_flrd"] = 0;
				$mfl->column_fields["mfl_flro"] = $renglon["recoger{$i}_cantidad"] * -1;
				$mfl->column_fields["mfl_flrs"] = $renglon["recoger{$i}_cantidad"];
				$mfl->column_fields["mfl_flroe"] = $renglon["recoger{$i}_cantidad"] * -1;
				$mfl->column_fields["mfl_cliente"] = $renglon["accountid"];
				$mfl->column_fields["mfl_obra"] = $renglon["obrasid"];
				$mfl->column_fields["mfl_fecha_efectiva"] = $renglon["fecha_efectiva"];
				$mfl->column_fields["mfl_hora_efectiva"] = $renglon["hora_efectiva"];
				$mfl->save("Movimientos_flota");
			}
		}
		echo "</tr>";
	//die;
	}
	echo "</table>";
	echo "Finalizado.";
}

if ($procesar["cam"])
{
	// Carga cambios.
	$consulta = "select cam.* from vtiger_cambios cam, vtiger_crmentity e where e.crmid = cam.cambiosid and e.deleted = '0' and cam.accountid != '' and cam.obrasid != '' order by cam.fecha_efectiva, cam.hora_efectiva";
	//var_dump($consulta);
	//die;
	$resultado = $adb->query($consulta);
	echo "<table>";
	while ($renglon = $adb->fetch_array($resultado))
	{
		echo "<tr>";
		echo "<td>";
		echo $renglon["folio"];
		echo "</td>";
		echo "<td>";
		echo $renglon["fecha_efectiva"];
		echo "</td>";
		echo "<td>";
		echo $renglon["hora_efectiva"];
		echo "</td>";

		for ($i = 1; $i <= 5; $i++)
		{
			if ($renglon["entrega{$i}_equipo"] != "")
			{
				$consulta2 = "select flr.numero_interno from vtiger_flota_renta flr where flr.flota_rentaid = '".$renglon["entrega{$i}_equipo"]."'";
				$resultado2 = $adb->query($consulta2);
				$renglon2 = $adb->fetch_array($resultado2);
				echo "<td>";
				echo $renglon2["numero_interno"];
				echo "</td>";
				echo "<td>";
				echo $renglon["entrega{$i}_cantidad"];
				echo "</td>";

				$mfl = new Movimientos_flota;
				$mfl->column_fields["assigned_user_id"] = $current_user->id;
				$mfl->column_fields["mfl_tipo"] = "Cambio";
				$mfl->column_fields["mfl_cambio"] = $renglon["cambiosid"];
				$mfl->column_fields["mfl_codigo"] = $renglon2["numero_interno"];
				$mfl->column_fields["mfl_cantidad"] = $renglon["entrega{$i}_cantidad"];
				$mfl->column_fields["mfl_flrd"] = $renglon["entrega{$i}_cantidad"] * -1;
				$mfl->column_fields["mfl_flro"] = $renglon["entrega{$i}_cantidad"];
				$mfl->column_fields["mfl_flrs"] = 0;
				$mfl->column_fields["mfl_flroe"] = $renglon["entrega{$i}_cantidad"];
				$mfl->column_fields["mfl_cliente"] = $renglon["accountid"];
				$mfl->column_fields["mfl_obra"] = $renglon["obrasid"];
				$mfl->column_fields["mfl_fecha_efectiva"] = $renglon["fecha_efectiva"];
				$mfl->column_fields["mfl_hora_efectiva"] = $renglon["hora_efectiva"];
				$mfl->save("Movimientos_flota");
			}

			if ($renglon["recoger{$i}_equipo"] != "")
			{
				$consulta2 = "select flr.numero_interno from vtiger_flota_renta flr where flr.flota_rentaid = '".$renglon["recoger{$i}_equipo"]."'";
				$resultado2 = $adb->query($consulta2);
				$renglon2 = $adb->fetch_array($resultado2);
				echo "<td>";
				echo $renglon2["numero_interno"];
				echo "</td>";
				echo "<td>";
				echo $renglon["recoger{$i}_cantidad"];
				echo "</td>";

				$mfl = new Movimientos_flota;
				$mfl->column_fields["assigned_user_id"] = $current_user->id;
				$mfl->column_fields["mfl_tipo"] = "Cambio";
				$mfl->column_fields["mfl_cambio"] = $renglon["cambiosid"];
				$mfl->column_fields["mfl_codigo"] = $renglon2["numero_interno"];
				$mfl->column_fields["mfl_cantidad"] = $renglon["recoger{$i}_cantidad"];
				$mfl->column_fields["mfl_flrd"] = 0;
				$mfl->column_fields["mfl_flro"] = $renglon["recoger{$i}_cantidad"] * -1;
				$mfl->column_fields["mfl_flrs"] = $renglon["recoger{$i}_cantidad"];
				$mfl->column_fields["mfl_flroe"] = $renglon["recoger{$i}_cantidad"] * -1;
				$mfl->column_fields["mfl_cliente"] = $renglon["accountid"];
				$mfl->column_fields["mfl_obra"] = $renglon["obrasid"];
				$mfl->column_fields["mfl_fecha_efectiva"] = $renglon["fecha_efectiva"];
				$mfl->column_fields["mfl_hora_efectiva"] = $renglon["hora_efectiva"];
				$mfl->save("Movimientos_flota");
			}
		}
		echo "</tr>";
	//die;
	}
	echo "</table>";
	echo "Finalizado.";
}

if ($procesar["ot"])
{
	// Carga órdenes de trabajo cerradas.
	$consulta = "select ot.* from vtiger_ordenes_trabajo ot, vtiger_crmentity e where e.crmid = ot.ordenes_trabajoid and e.deleted = '0' and ot.flota_rentaid != '' and ot.movimiento != '' and ot.estado like 'Cerrad%' order by ot.fecha_fin";
	//var_dump($consulta);
	//die;
	$resultado = $adb->query($consulta);
	echo "<table>";
	while ($renglon = $adb->fetch_array($resultado))
	{
		unset ($cantidad);
		if ($renglon["parcial"])
		{
			$cantidad = $renglon["cantidad_parcial"];
		}
		else
		{
			$cantidad = $renglon["cantidad"];
		}

		echo "<tr>";
		echo "<td>";
		echo $renglon["folio"];
		echo "</td>";
		echo "<td>";
		echo $renglon["fecha_fin"];
		echo "</td>";
		//echo "<td>";
		//echo $renglon["hora_efectiva"];
		//echo "</td>";

		$consulta2 = "select flr.numero_interno from vtiger_flota_renta flr where flr.flota_rentaid = '".$renglon["flota_rentaid"]."'";
		$resultado2 = $adb->query($consulta2);
		$renglon2 = $adb->fetch_array($resultado2);
		echo "<td>";
		echo $renglon2["numero_interno"];
		echo "</td>";
		echo "<td>";
		echo $cantidad;
		echo "</td>";

		$mfl = new Movimientos_flota;
		$mfl->column_fields["assigned_user_id"] = $current_user->id;
		$mfl->column_fields["mfl_tipo"] = "Orden de trabajo";
		$mfl->column_fields["mfl_orden_trabajo"] = $renglon["ordenes_trabajoid"];
		$mfl->column_fields["mfl_codigo"] = $renglon2["numero_interno"];
		$mfl->column_fields["mfl_cantidad"] = $cantidad;
		$mfl->column_fields["mfl_flrd"] = $cantidad;
		$mfl->column_fields["mfl_flro"] = 0;
		$mfl->column_fields["mfl_flrs"] = $cantidad * -1;
		$mfl->column_fields["mfl_flroe"] = 0;
		$mfl->column_fields["mfl_fecha_efectiva"] = $renglon["fecha_fin"];
		$mfl->save("Movimientos_flota");
		echo "</tr>";
	//die;
	}
	echo "</table>";
	echo "Finalizado.";
}
?>
