<?php
require_once("config.php");
require_once("include/utils/utils.php");
require_once("Smarty_setup.php");
require_once("modules/Facturas/Facturas.php");
require_once("modules/Por_facturar/Por_facturar.php");
require_once("modules/Users/Users.php");
require("campos_personalizados.php");

// Abre la sesión PHP.
session_start();

// Carga datos de usuario.
$current_user = new Users();
$current_user->retrieveCurrentUserInfoFromFile($_SESSION["authenticated_user_id"]);

global $adb;

// Construye la lista de por_facturar elegidos.
$lista_pfa = implode(", ", array_keys($_POST["por_facturar"]));
$campo_linea = $campos_personalizados["products"]["linea"];

//$consulta = "select cli.accountname as cliente, obr.nombre as obra, flr.numero_interno as equipo, per.idv as periodo, pfa.* from vtiger_por_facturar pfa, vtiger_crmentity e, vtiger_account cli, vtiger_obras obr, vtiger_flota_renta flr, vtiger_periodos per where pfa.por_facturarid in ($lista_pfa) and e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.estado = 'Pendiente' and cli.accountid = pfa.accountid and obr.obrasid = pfa.obrasid and flr.flota_rentaid = pfa.flota_rentaid and per.periodosid = pfa.periodosid";
$consulta = "select cli.accountname as cliente, obr.nombre as obra, flr.numero_interno as equipo, per.idv as periodo, pro.productname as producto, lin.nombre as linea, lin.equivalencia_diaria_mes, lin.equivalencia_diaria_semana, lin.precio_dia, pfa.* from vtiger_por_facturar pfa, vtiger_crmentity e, vtiger_account cli, vtiger_obras obr, vtiger_flota_renta flr, vtiger_periodos per, vtiger_products pro, vtiger_productcf pro2, vtiger_lineas lin where pfa.por_facturarid in ($lista_pfa) and e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.estado = 'Pendiente' and cli.accountid = pfa.accountid and obr.obrasid = pfa.obrasid and flr.flota_rentaid = pfa.flota_rentaid and per.periodosid = pfa.periodosid  and pro.productid = flr.productid and pro2.productid = flr.productid and lin.lineasid = pro2.$campo_linea";
/***************************************
var_dump($consulta);
echo "<pre>";
var_dump($lista_pfa);
var_dump($_POST);
die;
*****************************************/
$resultado = $adb->query($consulta);

// Validaciones.
// ...

// Crea una factura (encabezado).
$factura = new Facturas;
$factura->column_fields["assigned_user_id"] = $current_user->id;
$factura->column_fields["moneda"] = "MXN";
$factura->save("Facturas");

// Hace un barrido de los por_facturar, los actualiza y los asocia a la factura.
$subtotal = 0;
while ($renglon = $adb->fetch_array($resultado))
{
//var_dump($subtotal);
	//echo $renglon["idv"]."<br>";
	$por_facturar = new Por_facturar;
	$por_facturar->retrieve_entity_info($renglon["por_facturarid"], "Por_facturar");
	$por_facturar->column_fields["estado"] = "Facturado";
	$por_facturar->column_fields["factura"] = $factura->id;
	$por_facturar->column_fields["fecha_ini"] = $fecha_ini[$renglon["por_facturarid"]];
	$por_facturar->column_fields["fecha_fin"] = $fecha_fin[$renglon["por_facturarid"]];
	$por_facturar->column_fields["dias"] = $dias[$renglon["por_facturarid"]];

	// Genera un nuevo por_facturar si las fechas fueron manipuladas.
	// Casos posibles: fecha inicial manipulada, ambas fechas manipuladas y fecha final manipulada.
	if ($renglon["fecha_ini"] != $fecha_ini[$renglon["por_facturarid"]])
	{
		// Fecha inicial modificada.
		if ($renglon["fecha_fin"] != $fecha_fin[$renglon["por_facturarid"]])
		{
			// Fecha final modificada: ambas cambiaron.
			$fecha_ini_nuevo = new DateTime($renglon["fecha_ini"]);
			$fecha_fin_nuevo = new DateTime($fecha_ini[$renglon["por_facturarid"]]." - 1 day");

			// Crea los nuevos por_facturar.
        		$por_facturar_nuevo1 = new Por_facturar;
        		$por_facturar_nuevo1->retrieve_entity_info($renglon["por_facturarid"], "Por_facturar");
        		$por_facturar_nuevo1->column_fields["fecha_fin"] = $fecha_fin_nuevo->format("Y-m-d");
        		$por_facturar_nuevo1->column_fields["dias"] = $fecha_fin_nuevo->diff($fecha_ini_nuevo)->d;
        		$por_facturar_nuevo1->save("Por_facturar");

			$fecha_ini_nuevo = new DateTime($fecha_fin[$renglon["por_facturarid"]]." + 1 day");
			$fecha_fin_nuevo = new DateTime($renglon["fecha_fin"]);

        		$por_facturar_nuevo2 = new Por_facturar;
        		$por_facturar_nuevo2->retrieve_entity_info($renglon["por_facturarid"], "Por_facturar");
        		$por_facturar_nuevo2->column_fields["fecha_ini"] = $fecha_ini_nuevo->format("Y-m-d");
        		$por_facturar_nuevo2->column_fields["dias"] = $fecha_fin_nuevo->diff($fecha_ini_nuevo)->d;
        		$por_facturar_nuevo2->save("Por_facturar");
		}
		else
		{
			// Fecha final intacta: sólo cambió fecha inicial.

			$fecha_ini_nuevo = new DateTime($renglon["fecha_ini"]);
			$fecha_fin_nuevo = new DateTime($fecha_ini[$renglon["por_facturarid"]]." - 1 day");

			// Crea los nuevos por_facturar.
        		$por_facturar_nuevo1 = new Por_facturar;
        		$por_facturar_nuevo1->retrieve_entity_info($renglon["por_facturarid"], "Por_facturar");
        		$por_facturar_nuevo1->column_fields["fecha_fin"] = $fecha_fin_nuevo->format("Y-m-d");
        		$por_facturar_nuevo1->column_fields["dias"] = $fecha_fin_nuevo->diff($fecha_ini_nuevo)->d;
        		$por_facturar_nuevo1->save("Por_facturar");
		}
	}
	else
	{
		// Fecha inicial intacta.
		if ($renglon["fecha_fin"] != $fecha_fin[$renglon["por_facturarid"]])
		{
			// Fecha final modificada: sólo cambió fecha final.
			$fecha_ini_nuevo = new DateTime($fecha_fin[$renglon["por_facturarid"]]." + 1 day");
			$fecha_fin_nuevo = new DateTime($renglon["fecha_fin"]);

        		$por_facturar_nuevo2 = new Por_facturar;
        		$por_facturar_nuevo2->retrieve_entity_info($renglon["por_facturarid"], "Por_facturar");
        		$por_facturar_nuevo2->column_fields["fecha_ini"] = $fecha_ini_nuevo->format("Y-m-d");
        		$por_facturar_nuevo2->column_fields["dias"] = $fecha_fin_nuevo->diff($fecha_ini_nuevo)->d;
        		$por_facturar_nuevo2->save("Por_facturar");
		}
	}

	// Graba el por_facturar original.
	$por_facturar->save("Por_facturar", $renglon["por_facturarid"]);
/************************************************************************************
***************************************************************************************/

	// Obtiene el cliente.
	$id_cliente = $renglon["accountid"];

        // Obtiene el precio unitario.
        $precio_unitario = $renglon["equivalencia_diaria_mes"];
//var_dump($precio_unitario);

	// Acumula subtotal.
	$subtotal += ($por_facturar->column_fields["dias"] * $precio_unitario);
}
//var_dump($subtotal);

// Graba cliente y totales en la factura.
$factura->column_fields["cliente"] = $id_cliente;
$factura->column_fields["subtotal"] = $subtotal;
$factura->column_fields["porcentaje_iva"] = 16;
$factura->column_fields["iva"] = $subtotal * ($factura->column_fields["porcentaje_iva"] / 100);
$factura->column_fields["total"] = $subtotal + $factura->column_fields["iva"];
$factura->save("Facturas", $factura->id);

//die;
// Dirige el navegador a la vista de detalle de la factura.
echo "<script language=\"javascript\">";
echo "document.location = 'index.php?module=Facturas&action=DetailView&record=".$factura->id."'";
echo "</script>";
?>
