<?php
require_once("Smarty_setup.php");
require_once("config.php");
require_once("include/utils/utils.php");
require_once("vtlib/Vtiger/Module.php");
require_once("vtlib/Vtiger/Menu.php");

// Inicializa parámetros de la instalación.
$nombre_instalacion = "mks";

// Obtiene la lista de módulos.
exec("rm lista_modulos.php");
exec("wget 'http://www.ideaswww.com/desarrollo/mks/lista_modulos.php'");

// Carga la lista de módulos.
require("lista_modulos.php");
//var_dump($lista_modulos);

// Muestra bitácora de ejecución en pantalla.
$Vtiger_Utils_Log = TRUE;

// Hace un barrido de módulos, los desinstala por si estuvieran ya instalados y los instala.
foreach ($lista_modulos as $codigo => $modulo_actual)
{
	$nombre_modulo = $modulo_actual["nombre"];
	$prefijo_numeracion = $modulo_actual["nombre"];

	// Obtiene la instancia del módulo y lo borra.
	$modulo = Vtiger_Module::getInstance($modulo_actual["nombre"]);
	if ($modulo)
	{
        	$modulo->delete();
	}

	// Genera archivos.
	echo "Generando archivos del módulo $nombre_modulo...<br>";

	// Copia la carpeta modelo del vtlib.
	//system ("cp -R ../../vtlib/ModuleDir/5.4.0 ../../modules/$nombre_modulo");
	system ("cp -R vtlib/ModuleDir/5.4.0 modules/$nombre_modulo");

	// Genera los archivos ajax y javascript propios del módulo.
	system ("cp modules/$nombre_modulo/ModuleFile.js modules/$nombre_modulo/$nombre_modulo.js");
	system ("cp modules/$nombre_modulo/ModuleFileAjax.php modules/$nombre_modulo/{$nombre_modulo}Ajax.php");

	// Genera el archivo principal del módulo reemplazando los campos necesarios.
	$archivo_plantilla = file("modules/$nombre_modulo/ModuleFile.php");
	$archivo_producido = fopen("modules/$nombre_modulo/$nombre_modulo.php", "w");

	// Genera el archivo de configuración del módulo.
	//system ("cp config_modulo.php modules/$nombre_modulo/{$nombre_modulo}_config.php");

	foreach ($archivo_plantilla as $renglon)
	{
        	// Efectúa los reemplazos.
        	$renglon = str_replace("vtiger_payslipcf", "vtiger_{$codigo}cf", $renglon);
        	$renglon = str_replace("vtiger_payslip", "vtiger_$codigo", $renglon);
        	$renglon = str_replace("payslipid", "{$codigo}id", $renglon);
        	$renglon = str_replace("payslipname", "$idv", $renglon);
        	$renglon = str_replace("payslip", "$codigo", $renglon);
        	$renglon = str_replace("'Payslip Name'", "'$nombre_modulo Name'", $renglon);
        	$renglon = str_replace("ModuleClass", "$nombre_modulo", $renglon);
        	fwrite ($archivo_producido, $renglon);
	}

	fclose($archivo_producido);

	// Actualiza desde desarrollo.
	exec("wget 'http://www.ideaswww.com/desarrollo/mks/becvt_exportar_get?m=$nombre_modulo'");
	exec("cp ../../desarrollo/mks/modules/$nombre_modulo/* modules/{$nombre_modulo}/");
	exec("mv modules/{$nombre_modulo}/becvt_config.php modules/{$nombre_modulo}/{$nombre_modulo}_config.php");

	// Instala el módulo.
	unset($bloques);
	unset($campos_filtro);

	// Crea el módulo y lo graba.
	$modulo = new Vtiger_Module;
	$modulo->name = $nombre_modulo;
	$modulo->save();

	// Se inician los servicios web del módulo (es obligatorio hacerlo).
	$modulo->initWebservice();
	// Crea las tablas en la base de datos.
	$modulo->initTables();

	// Se agrega el módulo al menú.
	// (Opciones: "My Home Page", "Marketing", "Sales", "Support", "Analytics", "Inventory", "Tools", "Settings".)
	$menu = Vtiger_Menu::getInstance("Tools");
	$menu->addModule($modulo);

	// Crea el filtro por omisión del módulo.
	$filtro = new Vtiger_Filter;
	$filtro->name = "All";
	$filtro->isdefault = TRUE;
	$modulo->addFilter($filtro);

	// Carga la definición de bloques y campos.
	require("modules/$nombre_modulo/{$nombre_modulo}_config.php");

	// Se agregan los bloques del módulo (se mostrarán en edición y detalle).
	foreach ($bloques as $bloque)
	{
        	$bloque_actual = new Vtiger_Block;
        	$bloque_actual->label = $bloque["etiqueta"];
        	$modulo->addBlock($bloque_actual);

        	// Se agregan los campos del bloque.
        	foreach ($bloque["campos"] as $codigo => $campo)
        	{
                	// Se crea un objeto campo.
                	$campo_actual = new Vtiger_Field;
	
                	// Se agregan sus propiedades según su tipo.
                	switch ($campo["tipo"])
                	{
                        	case "idv":
                                	$campo_actual->name = "idv";
                                	$campo_actual->label = $campo["etiqueta"];
                                	$campo_actual->table = $modulo->basetable;
                                	$campo_actual->column = "idv";
                                	$campo_actual->columntype = "VARCHAR(255)";
                                	$campo_actual->uitype = 4;
                                	$campo_actual->typeofdata = "V~M";

                                	// Por omisión este campo entra en el filtro principal.
                                	$campo["filtro"] = TRUE;

                                	// Lo asigna como identificador del módulo.
                                	//$modulo->setEntityIdentifier($campo_actual);
                        	break;
                        	case "asignado":
                                	$campo_actual->name = "assigned_user_id";
                                	$campo_actual->label = "Assigned To";
                                	$campo_actual->table = "vtiger_crmentity";
                                	$campo_actual->column = "smownerid";
                                	$campo_actual->columntype = "VARCHAR(255)";
                                	$campo_actual->uitype = 53;
                                	$campo_actual->typeofdata = "V~M";

                                	// Por omisión este campo entra en el filtro principal.
                                	$campo["filtro"] = TRUE;
                        	break;
                        	case "creado":
                                	$campo_actual->name = "CreatedTime";
                                	$campo_actual->label = "Created Time";
                                	$campo_actual->table = "vtiger_crmentity";
                                	$campo_actual->column = "createdtime";
                                	$campo_actual->uitype = 70;
                                	$campo_actual->typeofdata = "T~O";
                                	$campo_actual->displaytype = 2;

                                	// Por omisión este campo entra en el filtro principal.
                                	$campo["filtro"] = TRUE;
                        	break;
                        	case "modificado":
                                	$campo_actual->name = "ModifiedTime";
                                	$campo_actual->label = "Modified Time";
                                	$campo_actual->table = "vtiger_crmentity";
                                	$campo_actual->column = "modifiedtime";
                                	$campo_actual->uitype = 70;
                                	$campo_actual->typeofdata = "T~O";
                                	$campo_actual->displaytype = 2;

                                	// Por omisión este campo entra en el filtro principal.
                                	$campo["filtro"] = TRUE;
                        	break;
                        	case "texto_breve":
                                	$campo_actual->name = $codigo;
                                	$campo_actual->label = $campo["etiqueta"];
                                	$campo_actual->table = $modulo->basetable;
                                	$campo_actual->column = $codigo;
                                	$campo_actual->columntype = "VARCHAR(255)";
                                	$campo_actual->uitype = 2;
                                	$campo_actual->typeofdata = ($campo["obligatorio"])?"V~M":"V~O";
                        	break;
                        	case "relacionado":
                                	$campo_actual->name = $codigo;
                                	$campo_actual->label = $campo["etiqueta"];
                                	$campo_actual->table = $modulo->basetable;
                                	$campo_actual->column = $campo["modrelid"];
                                	$campo_actual->columntype = "VARCHAR(150)";
                                	$campo_actual->uitype = 10;
                                	$campo_actual->typeofdata = "V~O";
                                	if ($campo["ayuda"] != "")
                                	{
                                        	$campo_actual->helpinfo = $campo["ayuda"];
                                	}
                        	break;
                        	case "comentario":
                                	$campo_actual->name = $codigo;
                                	$campo_actual->label = $campo["etiqueta"];
                                	$campo_actual->table = $modulo->basetable;
                                	$campo_actual->column = $codigo;
                                	$campo_actual->columntype = "VARCHAR(255)";
                                	$campo_actual->uitype = 19;
                                	$campo_actual->typeofdata = "V~O";
                        	break;
                        	case "fecha_ini":
                                	$campo_actual->name = $codigo;
                                	$campo_actual->label = $campo["etiqueta"];
                                	$campo_actual->table = $modulo->basetable;
                                	$campo_actual->column = $codigo;
                                	$campo_actual->columntype = "date";
                                	$campo_actual->uitype = 5;
                                	$campo_actual->typeofdata = "D~O";
                        	break;
                        	case "fecha_fin":
                                	$campo_actual->name = $codigo;
                                	$campo_actual->label = $campo["etiqueta"];
                                	$campo_actual->table = $modulo->basetable;
                                	$campo_actual->column = $codigo;
                                	$campo_actual->columntype = "date";
                                	$campo_actual->uitype = 23;
                                	$campo_actual->typeofdata = "D~O";
                        	break;
                        	case "casilla":
                                	$campo_actual->name = $codigo;
                                	$campo_actual->label = $campo["etiqueta"];
                                	$campo_actual->table = $modulo->basetable;
                                	$campo_actual->column = $codigo;
                                	$campo_actual->columntype = "varchar(3)";
                                	$campo_actual->uitype = 56;
                                	$campo_actual->typeofdata = "C~O";
                        	break;
                        	case "fecha":
                                	$campo_actual->name = $codigo;
                                	$campo_actual->label = $campo["etiqueta"];
                                	$campo_actual->table = $modulo->basetable;
                                	$campo_actual->column = $codigo;
                                	$campo_actual->columntype = "date";
                                	$campo_actual->uitype = 5;
                                	$campo_actual->typeofdata = "D~O";
                        	break;
                        	case "hora":
                                	$campo_actual->name = $codigo;
                                	$campo_actual->label = $campo["etiqueta"];
                                	$campo_actual->table = $modulo->basetable;
                                	$campo_actual->column = $codigo;
                                	$campo_actual->columntype = "time";
                                	$campo_actual->uitype = 14;
                                	$campo_actual->typeofdata = "T~O";
                        	break;
                        	case "fechayhora":
                                	$campo_actual->name = $codigo;
                                	$campo_actual->label = $campo["etiqueta"];
                                	$campo_actual->table = $modulo->basetable;
                                	$campo_actual->column = $codigo;
                                	$campo_actual->columntype = "datetime";
                                	$campo_actual->uitype = 6;
                                	$campo_actual->typeofdata = "DT~O";
                        	break;
                        	case "lista":
                                	$campo_actual->name = $codigo;
                                	$campo_actual->label = $campo["etiqueta"];
                                	$campo_actual->table = $modulo->basetable;
                                	$campo_actual->column = $codigo;
                                	$campo_actual->columntype = "VARCHAR(255)";
                                	$campo_actual->uitype = 15;
                                	$campo_actual->typeofdata = "V~O";
                                	$valores_lista = explode("|", html_entity_decode($campo["ayuda"], ENT_NOQUOTES, "UTF-8"));
                                	$campo_actual->setPicklistValues($valores_lista);
				break;
                        	default:
                                	$campo_actual->name = $codigo;
                                	$campo_actual->label = $campo["etiqueta"];
                                	$campo_actual->table = $modulo->basetable;
                                	$campo_actual->column = $codigo;
                                	$campo_actual->columntype = "VARCHAR(255)";
                                	$campo_actual->uitype = 1;
                                	$campo_actual->typeofdata = "V~O";
                        	break;
                	}
                	// Lo asigna como identificador del módulo si es de tipo idvisual.
                	if ($campo["idvisual"])
                	{
                        	$modulo->setEntityIdentifier($campo_actual);
                        	$campo["filtro"] = TRUE;
                	}

                	// Se agrega el campo al bloque.
                	$bloque_actual->addField($campo_actual);

                	// Si es un campo de tipo "relacionado" se ligan los módulos.
                	// Es muy importante hacerlo después de haberlo agregado al bloque y no antes porque si no no funciona.
                	if ($campo["tipo"] == "relacionado")
                	{
                        	$campo_actual->setRelatedModules(array($campo["modrel"]));
                	}

                	// Se agrega el campo al filtro si corresponde.
                	//$filtro->addField($campo_actual);
                	if ($campo["filtro"])
                	{
                        	$campos_filtro[] = $campo_actual;
                	}
        	}
	}

	// Agrega campos al filtro principal.
	foreach (array_reverse($campos_filtro) as $campo_filtro)
	{
        	$filtro->addField($campo_filtro);
	}

	// Registra el prefijo de numeración del módulo.
	$entidad = new CRMEntity;
	$entidad->setModuleSeqNumber("configure", $modulo->name, $prefijo_numeracion, 1);

	// Define visibilidad del módulo.
	$modulo->setDefaultSharing("Private");

	// Establece herramientas disponibles.
	$modulo->enableTools(array("Import", "Export"));
	$modulo->disableTools("Merge");
}

// Genera la pantalla a través de Smarty.
$smarty = new vtigerCRM_Smarty;
//$smarty->assign("oculto_id", $oculto_id);
//$smarty->assign("tabla", $tabla);
$smarty->display("instalador.tpl");
?>
