<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');

class Notas_credito extends CRMEntity {
	var $db, $log; // Used in class functions of CRMEntity

	var $table_name = 'vtiger_notas_credito';
	var $table_index= 'notas_creditoid';
	var $column_fields = Array();

	/** Indicator if this is a custom module or standard module */
	var $IsCustomModule = true;

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_notas_creditocf', 'notas_creditoid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_notas_credito', 'vtiger_notas_creditocf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_notas_credito'   => 'notas_creditoid',
	    'vtiger_notas_creditocf' => 'notas_creditoid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Notas_credito Name'=> Array('notas_credito', ''),
		'Assigned To' => Array('crmentity','smownerid')
	);
	var $list_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Notas_credito Name'=> '',
		'Assigned To' => 'assigned_user_id'
	);

	// Make the field link to detail view from list view (Fieldname)
	var $list_link_field = '';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Notas_credito Name'=> Array('notas_credito', '')
	);
	var $search_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Notas_credito Name'=> ''
	);

	// For Popup window record selection
	var $popup_fields = Array('');

	// Placeholder for sort fields - All the fields will be initialized for Sorting through initSortFields
	var $sortby_fields = Array();

	// For Alphabetical search
	var $def_basicsearch_col = '';

	// Column value to use on detail view record text display
	var $def_detailview_recname = '';

	// Required Information for enabling Import feature
	var $required_fields = Array(''=>1);

	// Callback function list during Importing
	var $special_functions = Array('set_import_assigned_user');

	var $default_order_by = '';
	var $default_sort_order='ASC';
	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('createdtime', 'modifiedtime', '');
	
	function __construct() {
		global $log, $currentModule;
		$this->column_fields = getColumnFields($currentModule);
		$this->db = PearDatabase::getInstance();
		$this->log = $log;
	}

	function getSortOrder() {
		global $currentModule;

		$sortorder = $this->default_sort_order;
		if($_REQUEST['sorder']) $sortorder = $this->db->sql_escape_string($_REQUEST['sorder']);
		else if($_SESSION[$currentModule.'_Sort_Order']) 
			$sortorder = $_SESSION[$currentModule.'_Sort_Order'];

		return $sortorder;
	}

	function getOrderBy() {
		global $currentModule;
		
		$use_default_order_by = '';		
		if(PerformancePrefs::getBoolean('LISTVIEW_DEFAULT_SORTING', true)) {
			$use_default_order_by = $this->default_order_by;
		}
		
		$orderby = $use_default_order_by;
		if($_REQUEST['order_by']) $orderby = $this->db->sql_escape_string($_REQUEST['order_by']);
		else if($_SESSION[$currentModule.'_Order_By'])
			$orderby = $_SESSION[$currentModule.'_Order_By'];
		return $orderby;
	}

	function save_module($module) {
	}

	/**
	 * Return query to use based on given modulename, fieldname
	 * Useful to handle specific case handling for Popup
	 */
	function getQueryByModuleField($module, $fieldname, $srcrecord, $query='') {
		// $srcrecord could be empty
	}

	/**
	 * Get list view query (send more WHERE clause condition if required)
	 */
	function getListQuery($module, $usewhere='') {
		$query = "SELECT vtiger_crmentity.*, $this->table_name.*";
		
		// Keep track of tables joined to avoid duplicates
		$joinedTables = array();

		// Select Custom Field Table Columns if present
		if(!empty($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$query .= " FROM $this->table_name";

		$query .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		$joinedTables[] = $this->table_name;
		$joinedTables[] = 'vtiger_crmentity';
		
		// Consider custom table join as well.
		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index";
			$joinedTables[] = $this->customFieldTable[0]; 
		}
		$query .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";

		$joinedTables[] = 'vtiger_users';
		$joinedTables[] = 'vtiger_groups';
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($module));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);
		
		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other =  CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			if(!in_array($other->table_name, $joinedTables)) {
				$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
				$joinedTables[] = $other->table_name;
			}
		}

		global $current_user;
		$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
		$query .= "	WHERE vtiger_crmentity.deleted = 0 ".$usewhere;
		return $query;
	}

	/**
	 * Apply security restriction (sharing privilege) query part for List view.
	 */
	function getListViewSecurityParameter($module) {
		global $current_user;
		require('user_privileges/user_privileges_'.$current_user->id.'.php');
		require('user_privileges/sharing_privileges_'.$current_user->id.'.php');

		$sec_query = '';
		$tabid = getTabid($module);

		if($is_admin==false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 
			&& $defaultOrgSharingPermission[$tabid] == 3) {

				$sec_query .= " AND (vtiger_crmentity.smownerid in($current_user->id) OR vtiger_crmentity.smownerid IN 
					(
						SELECT vtiger_user2role.userid FROM vtiger_user2role 
						INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid 
						INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid 
						WHERE vtiger_role.parentrole LIKE '".$current_user_parent_role_seq."::%'
					) 
					OR vtiger_crmentity.smownerid IN 
					(
						SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per 
						WHERE userid=".$current_user->id." AND tabid=".$tabid."
					) 
					OR 
						(";
		
					// Build the query based on the group association of current user.
					if(sizeof($current_user_groups) > 0) {
						$sec_query .= " vtiger_groups.groupid IN (". implode(",", $current_user_groups) .") OR ";
					}
					$sec_query .= " vtiger_groups.groupid IN 
						(
							SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid 
							FROM vtiger_tmp_read_group_sharing_per
							WHERE userid=".$current_user->id." and tabid=".$tabid."
						)";
				$sec_query .= ")
				)";
		}
		return $sec_query;
	}

	/**
	 * Create query to export the records.
	 */
	function create_export_query($where)
	{
		global $current_user;
		$thismodule = $_REQUEST['module'];
		
		include("include/utils/ExportUtils.php");

		//To get the Permitted fields query and the permitted fields list
		$sql = getPermittedFieldsQuery($thismodule, "detail_view");
		
		$fields_list = getFieldsListFromQuery($sql);

		$query = "SELECT $fields_list, vtiger_users.user_name AS user_name 
					FROM vtiger_crmentity INNER JOIN $this->table_name ON vtiger_crmentity.crmid=$this->table_name.$this->table_index";

		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}

		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id and vtiger_users.status='Active'";
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($thismodule));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);

		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other = CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
		}

		$query .= $this->getNonAdminAccessControlQuery($thismodule,$current_user);
		$where_auto = " vtiger_crmentity.deleted=0";

		if($where != '') $query .= " WHERE ($where) AND $where_auto";
		else $query .= " WHERE $where_auto";

		return $query;
	}

	/**
	 * Initialize this instance for importing.
	 */
	function initImport($module) {
		$this->db = PearDatabase::getInstance();
		$this->initImportableFields($module);
	}

	/**
	 * Create list query to be shown at the last step of the import.
	 * Called From: modules/Import/UserLastImport.php
	 */
	function create_import_query($module) {
		global $current_user;
		$query = "SELECT vtiger_crmentity.crmid, case when (vtiger_users.user_name not like '') then vtiger_users.user_name else vtiger_groups.groupname end as user_name, $this->table_name.* FROM $this->table_name
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index
			LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=vtiger_crmentity.crmid
			LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			WHERE vtiger_users_last_import.assigned_user_id='$current_user->id'
			AND vtiger_users_last_import.bean_type='$module'
			AND vtiger_users_last_import.deleted=0";
		return $query;
	}

	/**
	 * Delete the last imported records.
	 */
	function undo_import($module, $user_id) {
		global $adb;
		$count = 0;
		$query1 = "select bean_id from vtiger_users_last_import where assigned_user_id=? AND bean_type='$module' AND deleted=0";
		$result1 = $adb->pquery($query1, array($user_id)) or die("Error getting last import for undo: ".mysql_error()); 
		while ( $row1 = $adb->fetchByAssoc($result1))
		{
			$query2 = "update vtiger_crmentity set deleted=1 where crmid=?";
			$result2 = $adb->pquery($query2, array($row1['bean_id'])) or die("Error undoing last import: ".mysql_error()); 
			$count++;			
		}
		return $count;
	}
	
	/**
	 * Transform the value while exporting
	 */
	function transform_export_value($key, $value) {
		return parent::transform_export_value($key, $value);
	}

	/**
	 * Function which will set the assigned user id for import record.
	 */
	function set_import_assigned_user()
	{
		global $current_user, $adb;
		$record_user = $this->column_fields["assigned_user_id"];
		
		if($record_user != $current_user->id){
			$sqlresult = $adb->pquery("select id from vtiger_users where id = ? union select groupid as id from vtiger_groups where groupid = ?", array($record_user, $record_user));
			if($this->db->num_rows($sqlresult)!= 1) {
				$this->column_fields["assigned_user_id"] = $current_user->id;
			} else {			
				$row = $adb->fetchByAssoc($sqlresult, -1, false);
				if (isset($row['id']) && $row['id'] != -1) {
					$this->column_fields["assigned_user_id"] = $row['id'];
				} else {
					$this->column_fields["assigned_user_id"] = $current_user->id;
				}
			}
		}
	}
	
	/** 
	 * Function which will give the basic query to find duplicates
	 */
	function getDuplicatesQuery($module,$table_cols,$field_values,$ui_type_arr,$select_cols='') {
		$select_clause = "SELECT ". $this->table_name .".".$this->table_index ." AS recordid, vtiger_users_last_import.deleted,".$table_cols;

		// Select Custom Field Table Columns if present
		if(isset($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$from_clause = " FROM $this->table_name";

		$from_clause .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		// Consider custom table join as well.
		if(isset($this->customFieldTable)) {
			$from_clause .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}
		$from_clause .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
						LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		
		$where_clause = "	WHERE vtiger_crmentity.deleted = 0";
		$where_clause .= $this->getListViewSecurityParameter($module);
					
		if (isset($select_cols) && trim($select_cols) != '') {
			$sub_query = "SELECT $select_cols FROM  $this->table_name AS t " .
				" INNER JOIN vtiger_crmentity AS crm ON crm.crmid = t.".$this->table_index;
			// Consider custom table join as well.
			if(isset($this->customFieldTable)) {
				$sub_query .= " LEFT JOIN ".$this->customFieldTable[0]." tcf ON tcf.".$this->customFieldTable[1]." = t.$this->table_index";
			}
			$sub_query .= " WHERE crm.deleted=0 GROUP BY $select_cols HAVING COUNT(*)>1";	
		} else {
			$sub_query = "SELECT $table_cols $from_clause $where_clause GROUP BY $table_cols HAVING COUNT(*)>1";
		}	
		
		
		$query = $select_clause . $from_clause .
					" LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=" . $this->table_name .".".$this->table_index .
					" INNER JOIN (" . $sub_query . ") AS temp ON ".get_on_clause($field_values,$ui_type_arr,$module) .
					$where_clause .
					" ORDER BY $table_cols,". $this->table_name .".".$this->table_index ." ASC";
					
		return $query;		
	}

	/**
	 * Invoked when special actions are performed on the module.
	 * @param String Module name
	 * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
	 */
	function vtlib_handler($modulename, $event_type) {
		if($event_type == 'module.postinstall') {
			// TODO Handle post installation actions
		} else if($event_type == 'module.disabled') {
			// TODO Handle actions when this module is disabled.
		} else if($event_type == 'module.enabled') {
			// TODO Handle actions when this module is enabled.
		} else if($event_type == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($event_type == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($event_type == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
	}

	/** 
	 * Handle saving related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	// function save_related_module($module, $crmid, $with_module, $with_crmid) { }
	
	/**
	 * Handle deleting related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function delete_related_module($module, $crmid, $with_module, $with_crmid) { }

	/**
	 * Handle getting related list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_related_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	/**
	 * Handle getting dependents list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_dependents_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	function tabla_detalles()
	{
		global $adb;

        	$nc_id = $this->obtener_id();

		// Consulta para por facturar.
		//$consulta = "select ncd.*, obr.nombre as obra, pfa.periodosid, pfa.movimiento, pfa.fecha_ini, pfa.fecha_ini_fac, pfa.fecha_fin, pfa.fecha_fin_fac, pfa.concepto, pfa.productid, pfa.flota_rentaid, pfa.numeros_serieid, pfa.cantidad as unidades from vtiger_notas_credito_det ncd, vtiger_crmentity e, vtiger_por_facturar pfa, vtiger_obras obr where e.crmid = ncd.notas_credito_detid and e.deleted = '0' and ncd.notas_creditoid = '$nc_id' and pfa.por_facturarid = ncd.por_facturarid and obr.obrasid = pfa.obrasid order by ncd.notas_credito_detid limit 0, 13";
		//$consulta = "select ncd.*, obr.nombre as obra, pfa.periodosid, pfa.movimiento, pfa.fecha_ini, pfa.fecha_ini_fac, pfa.fecha_fin, pfa.fecha_fin_fac, pfa.concepto, pfa.productid, pfa.flota_rentaid, pfa.numeros_serieid, pfa.cantidad as unidades from vtiger_notas_credito_det ncd, vtiger_crmentity e, vtiger_por_facturar pfa, vtiger_obras obr where e.crmid = ncd.notas_credito_detid and e.deleted = '0' and ncd.notas_creditoid = '$nc_id' and pfa.por_facturarid = ncd.por_facturarid and obr.obrasid = pfa.obrasid order by ncd.fecha_ini, ncd.fecha_fin limit 0, 13";
		$consulta = "select ncd.*, obr.nombre as obra, pfa.periodosid, pfa.movimiento, pfa.concepto, pfa.productid, pfa.flota_rentaid, pfa.numeros_serieid, pfa.cantidad as unidades from vtiger_notas_credito_det ncd, vtiger_crmentity e, vtiger_por_facturar pfa, vtiger_obras obr where e.crmid = ncd.notas_credito_detid and e.deleted = '0' and ncd.notas_creditoid = '$nc_id' and pfa.por_facturarid = ncd.por_facturarid and obr.obrasid = pfa.obrasid order by ncd.fecha_ini, ncd.fecha_fin limit 0, 13";
//var_dump($consulta);
		$resultado = $adb->query($consulta);

		while ($renglon = $adb->fetch_array($resultado))
		{
			if (($renglon["concepto"] == "Flete") || (strpos($renglon["concepto"], "Reparaci") !== false))
			{
				$renglon["rem1"] = $renglon["movimiento"];
			}

			if ($renglon["productid"] != "")
			{
				$consulta2 = "select prod.* from vtiger_products prod, vtiger_crmentity e where e.crmid = prod.productid and e.deleted = '0' and prod.productid = '".$renglon["productid"]."'";
//var_dump($consulta2);
				$resultado2 = $adb->query($consulta2);
				$renglon2 = $adb->fetch_array($resultado2);
	//echo "<pre>";
	//var_dump($renglon2);
	//echo "</pre>";
//die;
				$prod_id = $renglon2["productid"];
				$prod_nombre = $renglon2["productname"];

				$renglon["producto"] = $prod_nombre;
			}

			if ($renglon["flota_rentaid"] != "")
			{
				$consulta2 = "select flr.* from vtiger_flota_renta flr, vtiger_crmentity e where e.crmid = flr.flota_rentaid and e.deleted = '0' and flr.flota_rentaid = '".$renglon["flota_rentaid"]."'";
//var_dump($consulta2);
				$resultado2 = $adb->query($consulta2);
				$renglon2 = $adb->fetch_array($resultado2);
	//echo "<pre>";
	//var_dump($renglon2);
	//echo "</pre>";
//die;
				$flr_id = $renglon2["flota_rentaid"];
				$renglon["numero_interno"] = $renglon2["numero_interno"];
			}

			if ($renglon["numeros_serieid"] != "")
			{
				$consulta2 = "select ns.* from vtiger_numeros_serie ns, vtiger_crmentity e where e.crmid = ns.numeros_serieid and e.deleted = '0' and ns.numeros_serieid = '".$renglon["numeros_serieid"]."'";
//var_dump($consulta2);
				$resultado2 = $adb->query($consulta2);
				$renglon2 = $adb->fetch_array($resultado2);
	//echo "<pre>";
	//var_dump($renglon2);
	//echo "</pre>";
//die;
				$ns_id = $renglon2["numeros_serieid"];
				$renglon["numero_serie"] = $renglon2["numero_serie"];
			}

			if ($renglon["periodosid"] != "")
			{
				$consulta2 = "select per.* from vtiger_periodos per, vtiger_crmentity e where e.crmid = per.periodosid and e.deleted = '0' and per.periodosid = '".$renglon["periodosid"]."'";
//var_dump($consulta2);
				$resultado2 = $adb->query($consulta2);
				$renglon2 = $adb->fetch_array($resultado2);
	//echo "<pre>";
	//var_dump($renglon2);
	//echo "</pre>";
//die;
				$per_id = $renglon2["periodosid"];
				$per_idv = $renglon2["idv"];
				$per_apertura = $renglon2["movimiento_apertura"];
				$per_cierre = $renglon2["movimiento_cierre"];

				$renglon["periodo"] = $per_idv;
				$renglon["rem1"] = $per_apertura;
				$renglon["rem2"] = $per_cierre;

				//if ($renglon["fecha_ini_fac"] != "")
/****************************************
				if (($renglon["fecha_ini_fac"] != "") && ($renglon["fecha_ini_fac"] != "0000-00-00"))
				{
					$renglon["ini"] = $renglon["fecha_ini_fac"];
				}
				else
				{
					$renglon["ini"] = $renglon["fecha_ini"];
				}

				//if ($renglon["fecha_fin_fac"] != "")
				if (($renglon["fecha_fin_fac"] != "") && ($renglon["fecha_fin_fac"] != "0000-00-00"))
				{
					$renglon["fin"] = $renglon["fecha_fin_fac"];
				}
				else
				{
					$renglon["fin"] = $renglon["fecha_fin"];
				}
****************************************/
				$renglon["ini"] = $renglon["fecha_ini"];
				$renglon["fin"] = $renglon["fecha_fin"];
			}

			$renglones[] = $renglon;
		}

/********************************
		// Consulta para productos.
		$consulta = "select facd.* from vtiger_facturas_det facd, vtiger_crmentity e where e.crmid = facd.facturas_detid and e.deleted = '0' and facd.facturasid = '$fac_id' and facd.descripcion_breve like 'Venta%'";
		$resultado = $adb->query($consulta);

		while ($renglon = $adb->fetch_array($resultado))
		{
			$renglones[] = $renglon;
		}
echo "<pre>";
//var_dump($renglones);
$componentes_renglon = each($renglones);
$renglon = $componentes_renglon["value"];
var_dump($renglon);
echo "</pre>";
********************************/
		$iteraciones = 13;

		$tabla_detalles = "<table style=\"width:95%\">";
		if ($this->column_fields["nc_estado"] == "Cancelada")
		{
			$tabla_detalles .= "<tr>";
			$tabla_detalles .= "<td colspan=\"16\" style=\"background:#faa;text-align:center;font-size:24px;color:red;border:1px solid red;padding:3px;\">";
			$tabla_detalles .= "CANCELADA";
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "</tr>";
		}
		$tabla_detalles .= "<tr>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Efecto";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Cantidad";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Artículo";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Obra";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Periodo";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th colspan=\"2\">";
		$tabla_detalles .= "Remisiones";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Inicio";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Fin";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Producto";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Unidades";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "NI";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "NS";
		$tabla_detalles .= "</th>";
/***************
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Descripción";
		$tabla_detalles .= "</th>";
***************/
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Precio unitario";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<th>";
		$tabla_detalles .= "Importe";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "</tr>";

		$subtotal = 0;
		for ($i = 1; $i <= $iteraciones; $i++)
		{
			$color = ($contador_color % 2)?"#eee":"#fed";
		
			//$renglon = $adb->fetch_array($resultado);
			if (!is_array($renglones))
			{
				continue;
			}

			$componentes_renglon = each($renglones);
			$renglon = $componentes_renglon["value"];
		
			$subtotal += $renglon["importe"];

			$tabla_detalles .= "<tr>";
			$tabla_detalles .= "<td style=\"background:$color;text-align:right;\">";
			$tabla_detalles .= "$tipo $i:";
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["ncd_efecto"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;text-align:right;\">";
			$tabla_detalles .= $renglon["cantidad"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["codigo"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["obra"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["periodo"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["rem1"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["rem2"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["ini"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["fin"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["producto"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;text-align:right;\">";
			$tabla_detalles .= $renglon["unidades"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["numero_interno"];
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["numero_serie"];
			$tabla_detalles .= "</td>";
/**************
			$tabla_detalles .= "<td style=\"background:$color;\">";
			$tabla_detalles .= $renglon["descripcion"];
			$tabla_detalles .= "</td>";
***************/
			$tabla_detalles .= "<td style=\"background:$color;text-align:right;\">";
			//$tabla_detalles .= $renglon["precio_unitario"];
			if ($renglon["precio_unitario"] != "")
			{
				$tabla_detalles .= number_format($renglon["precio_unitario"], 2);
			}
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "<td style=\"background:$color;text-align:right;\">";
			//$tabla_detalles .= $renglon["importe"];
			if ($renglon["importe"] != "")
			{
				$tabla_detalles .= number_format($renglon["importe"], 2);
			}
			$tabla_detalles .= "</td>";
			$tabla_detalles .= "</tr>";

			$contador_color++;
		}

		$iva = $subtotal * 0.16;
		$total = $subtotal + $iva;
		$colspan = 15;

		$tabla_detalles .= "<tr>";
		$tabla_detalles .= "<th colspan=\"$colspan\" style=\"text-align:right;\">";
		$tabla_detalles .= "Subtotal";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<td style=\"text-align:right;background:#eee;\">";
		$tabla_detalles .= number_format($subtotal, 2);
		$tabla_detalles .= "</td>";
		$tabla_detalles .= "</tr>";
		$tabla_detalles .= "<tr>";
		$tabla_detalles .= "<th colspan=\"$colspan\" style=\"text-align:right;\">";
		$tabla_detalles .= "IVA ".$this->column_fields["porcentaje_iva"]."%";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<td style=\"text-align:right;background:#eee;\">";
		$tabla_detalles .= number_format($iva, 2);
		$tabla_detalles .= "</td>";
		$tabla_detalles .= "</tr>";
		$tabla_detalles .= "<tr>";
		$tabla_detalles .= "<th colspan=\"$colspan\" style=\"text-align:right;\">";
		$tabla_detalles .= "Total";
		$tabla_detalles .= "</th>";
		$tabla_detalles .= "<td style=\"text-align:right;background:#eee;\">";
		$tabla_detalles .= "<b>";
		$tabla_detalles .= number_format($total, 2);
		$tabla_detalles .= "</b>";
		$tabla_detalles .= "</td>";
		$tabla_detalles .= "</tr>";

		$tabla_detalles .= "</table>";

		return $tabla_detalles;
	}

	function emitir()
	{
//die("emitir");
		global $adb;

		$nc_id = $this->obtener_id();

		// Obtiene la sucursal.
		$suc = new Sucursales;
		$suc->retrieve_entity_info($this->column_fields["sucursal"], "Sucursales");

		// Marca la nota de crédito como emitida y bloqueada.
		$consulta = "update vtiger_notas_credito set nc_estado = 'Emitida' where notas_creditoid = '$nc_id'";
		$adb->query($consulta);
		$this->bloquear("notas_credito");

		// Actualiza totales.
		//$this->totales();

		// Hace un barrido del detalle de la nota de crédito.
		//$consulta = "select ncd.* from vtiger_notas_credito_det ncd, vtiger_crmentity e where e.crmid = ncd.notas_credito_detid and e.deleted = '0' and ncd.notas_creditoid = '$nc_id'";
		$consulta = "select ncd.* from vtiger_notas_credito_det ncd, vtiger_crmentity e where e.crmid = ncd.notas_credito_detid and e.deleted = '0' and ncd.notas_creditoid = '$nc_id' and ncd.ncd_efecto = 'Reabrir' order by ncd.fecha_ini, ncd.fecha_fin";
		$resultado = $adb->query($consulta);
		while ($renglon = $adb->fetch_array($resultado))
		{
			// Determina el almacén a afectar.
			switch ($renglon["concepto"])
			{
				case "Venta usado":
					$almacen = $suc->column_fields["almacen_usado"];
				break;
				case "Venta nuevo":
					$almacen = $suc->column_fields["almacen_nuevo"];
				break;
				case "Venta refacciones":
					$almacen = $suc->column_fields["almacen_refacciones"];
				break;
				case "Renta de equipo":
					$almacen = $suc->column_fields["almacen_codigos"];
				break;
				default:
					$almacen = $suc->column_fields["almacen_servicios"];
				break;
			}

			// Genera una copia no facturada de los por facturar.
			//$pfa_id = $renglon["por_facturarid"];
			//$pfa_folio = $renglon["idv"];
//var_dump($pfa_folio);
			$pfa = new Por_facturar;

			if ($renglon["por_facturarid"] != "")
			{
				$pfa_base = new Por_facturar;
				$pfa_base->retrieve_entity_info($renglon["por_facturarid"], "Por_facturar");
				$pfa->column_fields["equipo"] = $pfa_base->column_fields["equipo"];
				$pfa->column_fields["numero_serie"] = $pfa_base->column_fields["numero_serie"];
				$pfa->column_fields["periodo"] = $pfa_base->column_fields["periodo"];
				$pfa->column_fields["producto"] = $pfa_base->column_fields["producto"];
			}
			$pfa->column_fields["assigned_user_id"] = 1;
			$pfa->column_fields["estado"] = "Pendiente";
			$pfa->column_fields["sucursal"] = $this->column_fields["sucursal"];
			$pfa->column_fields["cliente"] = $this->column_fields["cliente"];
			$pfa->column_fields["obra"] = $this->column_fields["obra"];
			$pfa->column_fields["fecha_ini"] = $renglon["fecha_ini"];
			$pfa->column_fields["fecha_fin"] = $renglon["fecha_fin"];
			$pfa->column_fields["cantidad"] = $renglon["unidades"];
			$pfa->column_fields["dias"] = $renglon["cantidad"];
			$pfa->column_fields["concepto"] = $renglon["descripcion_breve"];
			$pfa->column_fields["movimiento"] = $this->column_fields["folio"];

/**********************
$pfa->column_fields["folio"] = $renglon["folio"];
$pfa->column_fields["factura"] = $renglon["factura"];
$pfa->column_fields["segmento"] = $renglon["segmento"];
$pfa->column_fields["agrupador"] = $renglon["agrupador"];
$pfa->column_fields["contenedor"] = $renglon["contenedor"];
$pfa->column_fields["fecha_ini_fac"] = $renglon["fecha_ini_fac"];
$pfa->column_fields["fecha_fin_fac"] = $renglon["fecha_fin_fac"];
$pfa->column_fields["dias_fac"] = $renglon["dias_fac"];
$pfa->column_fields["cantidad_fac"] = $renglon["cantidad_fac"];
$pfa->column_fields["precio_unitario_fac"] = $renglon["precio_unitario_fac"];
******************/
			$pfa->save("Por_facturar");
//die;

/***********************
			// Acumula cantidades considerando el caso de facturar varios renglones de un mismo producto.
			$cantidad[$renglon["codigo"]] += $renglon["cantidad"];

			// Registra en kardex y existencias.

			unset($parametros);
			$parametros["sucursal"] = $this->column_fields["sucursal"];
			$parametros["almacen"] = $almacen;
			$parametros["tipo_documento"] = "Factura";
			$parametros["folio"] = $this->column_fields["folio"];
			$parametros["fecha"] = $this->column_fields["fecha_facturacion"];
			$parametros["producto"] = $renglon["productid"];
			$parametros["codigo_articulo"] = $renglon["codigo"];
			$parametros["entradas"] = 0;
			//$parametros["salidas"] = $renglon["cantidad"];
			$parametros["salidas"] = $cantidad[$renglon["codigo"]];
//echo "<pre>";
//var_dump($parametros);
//var_dump($renglon);
//echo "</pre>";
			$this->kardex($parametros);

			// Afecta número de serie y flota de renta.
			if (($renglon["numeros_serieid"] != "") && (strpos($this->column_fields["fac_tipo"], "Venta") !== false))
			{
				$ns = new Numeros_serie;
				$ns->retrieve_entity_info($renglon["numeros_serieid"], "Numeros_serie");
				$ns->estado("Vendido");
			}
			if (($renglon["flota_rentaid"] != "") && (strpos($this->column_fields["fac_tipo"], "Venta") !== false))
			{
				$flr = new Flota_renta;
				$flr->retrieve_entity_info($renglon["flota_rentaid"], "Flota_renta");
				//$flr->estado("Vendido");
				$flr->transferir($this->column_fields["sucursal"], "Usado", "Vendido", "", $renglon["cantidad"], $this->column_fields["folio"]);
			}
***********************/
		}
	}

	// Cancela la nota de crédito.
	function cancelar()
	{
		global $adb, $current_user;

		$nc_id = $this->obtener_id();
		$nc_folio = $this->column_fields["folio"];

		if ($this->column_fields["nc_estado"] != "Emitida")
		{
			die ("<h1>ERROR</h1>La nota de crédito debe estar emitida para poder ser cancelada.");
		}

		// Elimina por facturar de esta nota de crédito que aún tengan estado pendiente.
		$consulta = "update vtiger_por_facturar pfa, vtiger_crmentity e set e.deleted = '1' where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.movimiento = '$nc_folio' and pfa.estado = 'Pendiente'";
		$adb->query($consulta);

		// Ajusta el encabezado.
		$consulta = "update vtiger_notas_credito nc set nc.nc_estado = 'Cancelada', nc.fecha_cancelacion = '".date("Y-m-d")."', nc.cancelado_por = '".$current_user->user_name."' where nc.notas_creditoid = '$nc_id'";
		$adb->query($consulta);
	}
}
?>
