<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
require_once("modules/Accounts/Accounts.php");
require_once("modules/Por_facturar/Por_facturar.php");
require_once("modules/Flota_renta/Flota_renta.php");
require_once("modules/Products/Products.php");
require_once("modules/Lineas/Lineas.php");
require_once("modules/Campos_personalizados/Campos_personalizados.php");

class Periodos extends CRMEntity {
	var $db, $log; // Used in class functions of CRMEntity

	var $table_name = 'vtiger_periodos';
	var $table_index= 'periodosid';
	var $column_fields = Array();

	/** Indicator if this is a custom module or standard module */
	var $IsCustomModule = true;

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_periodoscf', 'periodosid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_periodos', 'vtiger_periodoscf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_periodos'   => 'periodosid',
	    'vtiger_periodoscf' => 'periodosid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Periodos Name'=> Array('periodos', 'idv'),
		'Assigned To' => Array('crmentity','smownerid')
	);
	var $list_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Periodos Name'=> 'idv',
		'Assigned To' => 'assigned_user_id'
	);

	// Make the field link to detail view from list view (Fieldname)
	var $list_link_field = 'idv';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Periodos Name'=> Array('periodos', 'idv')
	);
	var $search_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Periodos Name'=> 'idv'
	);

	// For Popup window record selection
	var $popup_fields = Array('idv');

	// Placeholder for sort fields - All the fields will be initialized for Sorting through initSortFields
	var $sortby_fields = Array();

	// For Alphabetical search
	var $def_basicsearch_col = 'idv';

	// Column value to use on detail view record text display
	var $def_detailview_recname = 'idv';

	// Required Information for enabling Import feature
	var $required_fields = Array('idv'=>1);

	// Callback function list during Importing
	var $special_functions = Array('set_import_assigned_user');

	var $default_order_by = 'idv';
	var $default_sort_order='ASC';
	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('createdtime', 'modifiedtime', 'idv');
	
	function __construct() {
		global $log, $currentModule;
		$this->column_fields = getColumnFields($currentModule);
		$this->db = PearDatabase::getInstance();
		$this->log = $log;
	}

	function getSortOrder() {
		global $currentModule;

		$sortorder = $this->default_sort_order;
		if($_REQUEST['sorder']) $sortorder = $this->db->sql_escape_string($_REQUEST['sorder']);
		else if($_SESSION[$currentModule.'_Sort_Order']) 
			$sortorder = $_SESSION[$currentModule.'_Sort_Order'];

		return $sortorder;
	}

	function getOrderBy() {
		global $currentModule;
		
		$use_default_order_by = '';		
		if(PerformancePrefs::getBoolean('LISTVIEW_DEFAULT_SORTING', true)) {
			$use_default_order_by = $this->default_order_by;
		}
		
		$orderby = $use_default_order_by;
		if($_REQUEST['order_by']) $orderby = $this->db->sql_escape_string($_REQUEST['order_by']);
		else if($_SESSION[$currentModule.'_Order_By'])
			$orderby = $_SESSION[$currentModule.'_Order_By'];
		return $orderby;
	}

	function save_module($module) {
		$this->asignar_dueno();
	}

	/**
	 * Return query to use based on given modulename, fieldname
	 * Useful to handle specific case handling for Popup
	 */
	function getQueryByModuleField($module, $fieldname, $srcrecord, $query='') {
		// $srcrecord could be empty
	}

	/**
	 * Get list view query (send more WHERE clause condition if required)
	 */
	function getListQuery($module, $usewhere='') {
		$query = "SELECT vtiger_crmentity.*, $this->table_name.*";
		
		// Keep track of tables joined to avoid duplicates
		$joinedTables = array();

		// Select Custom Field Table Columns if present
		if(!empty($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$query .= " FROM $this->table_name";

		$query .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		$joinedTables[] = $this->table_name;
		$joinedTables[] = 'vtiger_crmentity';
		
		// Consider custom table join as well.
		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index";
			$joinedTables[] = $this->customFieldTable[0]; 
		}
		$query .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";

		$joinedTables[] = 'vtiger_users';
		$joinedTables[] = 'vtiger_groups';
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($module));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);
		
		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other =  CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			if(!in_array($other->table_name, $joinedTables)) {
				$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
				$joinedTables[] = $other->table_name;
			}
		}

		global $current_user;
		$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
		$query .= "	WHERE vtiger_crmentity.deleted = 0 ".$usewhere;
		return $query;
	}

	/**
	 * Apply security restriction (sharing privilege) query part for List view.
	 */
	function getListViewSecurityParameter($module) {
		global $current_user;
		require('user_privileges/user_privileges_'.$current_user->id.'.php');
		require('user_privileges/sharing_privileges_'.$current_user->id.'.php');

		$sec_query = '';
		$tabid = getTabid($module);

		if($is_admin==false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 
			&& $defaultOrgSharingPermission[$tabid] == 3) {

				$sec_query .= " AND (vtiger_crmentity.smownerid in($current_user->id) OR vtiger_crmentity.smownerid IN 
					(
						SELECT vtiger_user2role.userid FROM vtiger_user2role 
						INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid 
						INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid 
						WHERE vtiger_role.parentrole LIKE '".$current_user_parent_role_seq."::%'
					) 
					OR vtiger_crmentity.smownerid IN 
					(
						SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per 
						WHERE userid=".$current_user->id." AND tabid=".$tabid."
					) 
					OR 
						(";
		
					// Build the query based on the group association of current user.
					if(sizeof($current_user_groups) > 0) {
						$sec_query .= " vtiger_groups.groupid IN (". implode(",", $current_user_groups) .") OR ";
					}
					$sec_query .= " vtiger_groups.groupid IN 
						(
							SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid 
							FROM vtiger_tmp_read_group_sharing_per
							WHERE userid=".$current_user->id." and tabid=".$tabid."
						)";
				$sec_query .= ")
				)";
		}
		return $sec_query;
	}

	/**
	 * Create query to export the records.
	 */
	function create_export_query($where)
	{
		global $current_user;
		$thismodule = $_REQUEST['module'];
		
		include("include/utils/ExportUtils.php");

		//To get the Permitted fields query and the permitted fields list
		$sql = getPermittedFieldsQuery($thismodule, "detail_view");
		
		$fields_list = getFieldsListFromQuery($sql);

		$query = "SELECT $fields_list, vtiger_users.user_name AS user_name 
					FROM vtiger_crmentity INNER JOIN $this->table_name ON vtiger_crmentity.crmid=$this->table_name.$this->table_index";

		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}

		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id and vtiger_users.status='Active'";
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($thismodule));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);

		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other = CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
		}

		$query .= $this->getNonAdminAccessControlQuery($thismodule,$current_user);
		$where_auto = " vtiger_crmentity.deleted=0";

		if($where != '') $query .= " WHERE ($where) AND $where_auto";
		else $query .= " WHERE $where_auto";

		return $query;
	}

	/**
	 * Initialize this instance for importing.
	 */
	function initImport($module) {
		$this->db = PearDatabase::getInstance();
		$this->initImportableFields($module);
	}

	/**
	 * Create list query to be shown at the last step of the import.
	 * Called From: modules/Import/UserLastImport.php
	 */
	function create_import_query($module) {
		global $current_user;
		$query = "SELECT vtiger_crmentity.crmid, case when (vtiger_users.user_name not like '') then vtiger_users.user_name else vtiger_groups.groupname end as user_name, $this->table_name.* FROM $this->table_name
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index
			LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=vtiger_crmentity.crmid
			LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			WHERE vtiger_users_last_import.assigned_user_id='$current_user->id'
			AND vtiger_users_last_import.bean_type='$module'
			AND vtiger_users_last_import.deleted=0";
		return $query;
	}

	/**
	 * Delete the last imported records.
	 */
	function undo_import($module, $user_id) {
		global $adb;
		$count = 0;
		$query1 = "select bean_id from vtiger_users_last_import where assigned_user_id=? AND bean_type='$module' AND deleted=0";
		$result1 = $adb->pquery($query1, array($user_id)) or die("Error getting last import for undo: ".mysql_error()); 
		while ( $row1 = $adb->fetchByAssoc($result1))
		{
			$query2 = "update vtiger_crmentity set deleted=1 where crmid=?";
			$result2 = $adb->pquery($query2, array($row1['bean_id'])) or die("Error undoing last import: ".mysql_error()); 
			$count++;			
		}
		return $count;
	}
	
	/**
	 * Transform the value while exporting
	 */
	function transform_export_value($key, $value) {
		return parent::transform_export_value($key, $value);
	}

	/**
	 * Function which will set the assigned user id for import record.
	 */
	function set_import_assigned_user()
	{
		global $current_user, $adb;
		$record_user = $this->column_fields["assigned_user_id"];
		
		if($record_user != $current_user->id){
			$sqlresult = $adb->pquery("select id from vtiger_users where id = ? union select groupid as id from vtiger_groups where groupid = ?", array($record_user, $record_user));
			if($this->db->num_rows($sqlresult)!= 1) {
				$this->column_fields["assigned_user_id"] = $current_user->id;
			} else {			
				$row = $adb->fetchByAssoc($sqlresult, -1, false);
				if (isset($row['id']) && $row['id'] != -1) {
					$this->column_fields["assigned_user_id"] = $row['id'];
				} else {
					$this->column_fields["assigned_user_id"] = $current_user->id;
				}
			}
		}
	}
	
	/** 
	 * Function which will give the basic query to find duplicates
	 */
	function getDuplicatesQuery($module,$table_cols,$field_values,$ui_type_arr,$select_cols='') {
		$select_clause = "SELECT ". $this->table_name .".".$this->table_index ." AS recordid, vtiger_users_last_import.deleted,".$table_cols;

		// Select Custom Field Table Columns if present
		if(isset($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$from_clause = " FROM $this->table_name";

		$from_clause .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		// Consider custom table join as well.
		if(isset($this->customFieldTable)) {
			$from_clause .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}
		$from_clause .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
						LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		
		$where_clause = "	WHERE vtiger_crmentity.deleted = 0";
		$where_clause .= $this->getListViewSecurityParameter($module);
					
		if (isset($select_cols) && trim($select_cols) != '') {
			$sub_query = "SELECT $select_cols FROM  $this->table_name AS t " .
				" INNER JOIN vtiger_crmentity AS crm ON crm.crmid = t.".$this->table_index;
			// Consider custom table join as well.
			if(isset($this->customFieldTable)) {
				$sub_query .= " LEFT JOIN ".$this->customFieldTable[0]." tcf ON tcf.".$this->customFieldTable[1]." = t.$this->table_index";
			}
			$sub_query .= " WHERE crm.deleted=0 GROUP BY $select_cols HAVING COUNT(*)>1";	
		} else {
			$sub_query = "SELECT $table_cols $from_clause $where_clause GROUP BY $table_cols HAVING COUNT(*)>1";
		}	
		
		
		$query = $select_clause . $from_clause .
					" LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=" . $this->table_name .".".$this->table_index .
					" INNER JOIN (" . $sub_query . ") AS temp ON ".get_on_clause($field_values,$ui_type_arr,$module) .
					$where_clause .
					" ORDER BY $table_cols,". $this->table_name .".".$this->table_index ." ASC";
					
		return $query;		
	}

	/**
	 * Invoked when special actions are performed on the module.
	 * @param String Module name
	 * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
	 */
	function vtlib_handler($modulename, $event_type) {
		if($event_type == 'module.postinstall') {
			// TODO Handle post installation actions
		} else if($event_type == 'module.disabled') {
			// TODO Handle actions when this module is disabled.
		} else if($event_type == 'module.enabled') {
			// TODO Handle actions when this module is enabled.
		} else if($event_type == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($event_type == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($event_type == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
	}

	/** 
	 * Handle saving related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	// function save_related_module($module, $crmid, $with_module, $with_crmid) { }
	
	/**
	 * Handle deleting related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function delete_related_module($module, $crmid, $with_module, $with_crmid) { }

	/**
	 * Handle getting related list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_related_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	/**
	 * Handle getting dependents list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_dependents_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	function facturar($fecha_facturar = NULL, $cerrar = FALSE)
	{
//var_dump($fecha_facturar);
		global $adb, $current_user_id;

		// Carga definicin de campos personalizados.
		require("campos_personalizados.php");

// Parámetro temporal para evitar generación de pfa históricos.
$inicio_operaciones = "2013-09-01";
$fecha_ini_oper = new DateTime($inicio_operaciones, new DateTimeZone("America/Mexico_City"));
		//var_dump($this->column_fields);
		// Calcula los borradores de facturas (por facturar).
/*****************************
//$this->column_fields["facturado_hasta"] = "2012-09-20";
//$this->column_fields["facturar_hasta"] = "2013-01-13";
****************************/
		//if (!$this->column_fields["facturado_hasta"])
//var_dump($this->column_fields["facturado_hasta"]);
//die;
		if ($this->column_fields["facturado_hasta"] == "" || $this->column_fields["facturado_hasta"] == "0000-00-00")
		{
			$fecha_ini = new DateTime($this->column_fields["fecha_ini"], new DateTimeZone("America/Mexico_City"));
		}
		else
		{
			$fecha_ini = new DateTime($this->column_fields["facturado_hasta"]." + 1 day", new DateTimeZone("America/Mexico_City"));
		}

		$fecha_fin = new DateTime($fecha_facturar, new DateTimeZone("America/Mexico_City"));
//var_dump($fecha_ini);
//var_dump($fecha_fin);
//var_dump($fecha_ini <= $fecha_fin);
//die;

		$cliente = new Accounts;
		$cliente->retrieve_entity_info($this->column_fields["cliente"], "Accounts");
//die(var_dump($cliente->column_fields[$campos_personalizados["accounts"]["frecuencia_facturacion"]]));

		// Hace el barrido del periodo.
		$frecuencia_facturacion = $cliente->column_fields[$campos_personalizados["accounts"]["frecuencia_facturacion"]];
		$dia_fijo_facturacion = str_pad($cliente->column_fields[$campos_personalizados["accounts"]["dia_facturacion"]], 2, "0", STR_PAD_LEFT);
//var_dump($frecuencia_facturacion);
//var_dump($fecha_ini->format("d"));
//var_dump($fecha_ini->format("Y-m-d"));
//var_dump($fecha_ini->format("Y-m-01"));
		$i = 0;
		while ($fecha_ini <= $fecha_fin)
		{
			// Validacin temporal para que no se cicle.
			//if ($i > 500)
			//if ($i > 50)
			//{
				//die ("ERROR: Se facturaron ms de $i bloques.");
			//}

			// Calcula la prxima fecha de corte segn la frecuencia de facturacin del cliente.
			switch ($frecuencia_facturacion)
			{
				case "Quincenal":
					if ($fecha_ini->format("d") <= 15)
					{
						//echo "1a quincena<br>";
						$fecha_corte = new DateTime($fecha_ini->format("Y-m-15"), new DateTimeZone("America/Mexico_City"));
					}
					else
					{
						//echo "2a quincena<br>";
						//$fecha_corte = new DateTime(date("Y-m-d", strtotime($fecha_ini->format("Y-m-01")." + 1 month - 1 day", new DateTimeZone("America/Mexico_City"))));
						$fecha_corte = new DateTime($fecha_ini->format("Y-m-01")." + 1 month - 1 day", new DateTimeZone("America/Mexico_City"));
					}
				break;
				case "Mes completo natural":
					$fecha_corte = new DateTime($fecha_ini->format("Y-m-01")." + 1 month - 1 day", new DateTimeZone("America/Mexico_City"));
				break;
				case "Bloques de 28":
					$fecha_corte = new DateTime($fecha_ini->format("Y-m-d")." + 27 days", new DateTimeZone("America/Mexico_City"));
				break;
				case "Bloques de 30":
					$fecha_corte = new DateTime($fecha_ini->format("Y-m-d")." + 29 days", new DateTimeZone("America/Mexico_City"));
				break;
				case "Semanal L-D":
					$fecha_corte = new DateTime($fecha_ini->format("Y-m-d")." next Sunday", new DateTimeZone("America/Mexico_City"));
					// Si la fecha original cae en el da que termina la semana de facturacin, debe cortar ese mismo da entonces.
					// Sin la validacin, el prximo corte sera de 8 das y no de 7.
					if ($fecha_corte->diff($fecha_ini)->d >= 7)
					{
						$fecha_corte = $fecha_ini;
					}
				break;
				case "Semanal M-L":
					$fecha_corte = new DateTime($fecha_ini->format("Y-m-d")." next Monday", new DateTimeZone("America/Mexico_City"));
					if ($fecha_corte->diff($fecha_ini)->d >= 7)
					{
						$fecha_corte = $fecha_ini;
					}
				break;
				case "Semanal M-M":
					$fecha_corte = new DateTime($fecha_ini->format("Y-m-d")." next Tuesday", new DateTimeZone("America/Mexico_City"));
					if ($fecha_corte->diff($fecha_ini)->d >= 7)
					{
						$fecha_corte = $fecha_ini;
					}
				break;
				case "Semanal J-M":
					$fecha_corte = new DateTime($fecha_ini->format("Y-m-d")." next Wednesday", new DateTimeZone("America/Mexico_City"));
					if ($fecha_corte->diff($fecha_ini)->d >= 7)
					{
						$fecha_corte = $fecha_ini;
					}
				break;
				case "Semanal V-J":
					$fecha_corte = new DateTime($fecha_ini->format("Y-m-d")." next Thursday", new DateTimeZone("America/Mexico_City"));
					if ($fecha_corte->diff($fecha_ini)->d >= 7)
					{
						$fecha_corte = $fecha_ini;
					}
				break;
				case "Semanal S-V":
					$fecha_corte = new DateTime($fecha_ini->format("Y-m-d")." next Friday", new DateTimeZone("America/Mexico_City"));
					if ($fecha_corte->diff($fecha_ini)->d >= 7)
					{
						$fecha_corte = $fecha_ini;
					}
				break;
				case "Semanal D-S":
					$fecha_corte = new DateTime($fecha_ini->format("Y-m-d")." next Saturday", new DateTimeZone("America/Mexico_City"));
					if ($fecha_corte->diff($fecha_ini)->d >= 7)
					{
						$fecha_corte = $fecha_ini;
					}
				break;
				case "Fijo":
                                        if ($fecha_ini->format("d") <= $dia_fijo_facturacion)
                                        {
                                                $fecha_corte = new DateTime($fecha_ini->format("Y-m-$dia_fijo_facturacion", new DateTimeZone("America/Mexico_City")));
                                        }
                                        else
                                        {
                                                $fecha_corte = new DateTime($fecha_ini->format("Y-m-$dia_fijo_facturacion")." + 1 month", new DateTimeZone("America/Mexico_City"));
                                        }
				break;
			}
//var_dump($fecha_corte);
//die;

			//var_dump("Inicio: ".$fecha_ini->format("Y-m-d")." corte: ".$fecha_corte->format("Y-m-d")." fin: ".$fecha_fin->format("Y-m-d"));

			// Obtiene el registro de flota de renta correspondiente.
			$flr = new Flota_renta;
			if ($this->column_fields["equipo"] != "")
			{
				$flr->retrieve_entity_info($this->column_fields["equipo"], "Flota_renta");
			}
                        // Genera los registros de lo pendiente por facturar.
                        $por_facturar = new Por_facturar;
                        //$por_facturar->retrieve_entity_info(163, "Por_facturar");
//var_dump($por_facturar->column_fields);
//var_dump($por_facturar);
//var_dump($this->column_fields);
                        $por_facturar->column_fields["assigned_user_id"] = 1;
                        $por_facturar->column_fields["sucursal"] = $this->column_fields["sucursal"];
                        $por_facturar->column_fields["cliente"] = $this->column_fields["cliente"];
                        $por_facturar->column_fields["obra"] = $this->column_fields["obra"];
                        $por_facturar->column_fields["equipo"] = $this->column_fields["equipo"];
                        $por_facturar->column_fields["producto"] = $flr->column_fields["producto"];
                        $por_facturar->column_fields["periodo"] = $this->column_fields["record_id"];
                        $por_facturar->column_fields["cantidad"] = $this->column_fields["cantidad"];
                        $por_facturar->column_fields["estado"] = "Pendiente";
                        $por_facturar->column_fields["concepto"] = "Renta de equipo";
                        $por_facturar->column_fields["fecha_ini"] = $fecha_ini->format("Y-m-d");

			// Calcula los días a cobrar.
			//var_dump($fecha_corte < $fecha_fin);
			if ($fecha_corte <= $fecha_fin)
			{
				$diferencia = $fecha_corte->diff($fecha_ini);
                        	$por_facturar->column_fields["fecha_fin"] = $fecha_corte->format("Y-m-d");
				$cobrar = TRUE;
			}
			else
			{
				$diferencia = $fecha_fin->diff($fecha_ini);
                        	$por_facturar->column_fields["fecha_fin"] = $fecha_fin->format("Y-m-d");
				$cobrar = FALSE;
			}
			$dias = $diferencia->d + 1;
                        $por_facturar->column_fields["dias"] = "$dias";

			//var_dump($dias);
			$fecha_ini->modify("+ $dias days");
			//die ($fecha_ini->format("Y-m-d"));
			$i++;

			// Finalmente graba el registro por facturar.
//var_dump($por_facturar->column_fields);
//die;
//echo "hola1";
			if ($cobrar || $cerrar)
			{
				//var_dump("cobrar");
// Validación temporal para evitar pfa antes de la fecha de inicio oficial de operaciones.
$fecha_ini_pfa = new DateTime($por_facturar->column_fields["fecha_ini"], new DateTimeZone("America/Mexico_City"));
$fecha_fin_pfa = new DateTime($por_facturar->column_fields["fecha_fin"], new DateTimeZone("America/Mexico_City"));
if ($fecha_fin_pfa >= $fecha_ini_oper)
{
	if ($fecha_ini_pfa < $fecha_ini_oper)
	{
		$por_facturar->column_fields["fecha_ini"] = $inicio_operaciones;
		$diferencia = $fecha_ini_oper->diff($fecha_ini_pfa);
		$por_facturar->column_fields["dias"] -= $diferencia->d;
	}
				if ($por_facturar->validar())
				{
                        		$por_facturar->save("Por_facturar");
                        		$por_facturar->ajustar_segun_hora();
				}
}
				$this->column_fields["facturado_hasta"] = $por_facturar->column_fields["fecha_fin"];
				$this->save("Periodos", $this->column_fields["record_id"]);
			}
//echo "hola2";
		}

		// Ajustar si hay facturación por adelantado.
		//$this->ajustar_adelantado();

		// Corrige posibles pfa duplicados.
		$this->corregir_duplicados();
	}

	function cerrar($cantidad, $documento, $fecha_fin)
	{
		global $adb, $current_user;

		$id_periodo = $this->obtener_id();

		$this->column_fields["estado"] = "Cerrado";
		if ($cantidad < $this->column_fields["cantidad"])
		{
			// Divide el periodo en 2, uno cerrado y otro abierto por la diferencia.
			$per = new Periodos;
			$per->retrieve_entity_info($id_periodo, "Periodos");
			$per->column_fields["cantidad"] = $this->column_fields["cantidad"] - $cantidad;
			$per->column_fields["facturado_hasta"] = "";
			$per->save("Periodos");

			$this->column_fields["cantidad"] = $cantidad;
		}
		$this->column_fields["movimiento_cierre"] = $documento;
		$this->column_fields["fecha_fin"] = $fecha_fin;
		$this->save("Periodos", $id_periodo);
	}

	function limpiar_por_facturar()
	{
		global $adb, $current_user;

		$id_periodo = $this->obtener_id();

		$this->column_fields["facturado_hasta"] = "";
		$this->save("Periodos", $id_periodo);

		//$consulta = "select pfa.* from vtiger_por_facturar pfa, vtiger_crmentity e where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.periodosid = '$id_periodo' and pfa.estado = 'Pendiente'";
		$consulta = "update vtiger_por_facturar pfa, vtiger_crmentity e set e.deleted = '1' where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.periodosid = '$id_periodo' and pfa.estado = 'Pendiente'";
		//var_dump($consulta);
		$adb->query($consulta);
	}


	// Calcula los por_facturar del periodo. Usa un nuevo algoritmo que reemplaza al que se usó desde un principio. La mejora es que maneja fecha de inicio y fin, reconstrucción completa y detección de fragmentos ya facturados anteriormente para evitar duplicidad y sólo generar el resto.
	function calcular_pfa($ini = "", $fin = "", $reconstruir = false)
	{
	}


	// Calcula los por facturar nuevamente para un rango de fechas solicitado.
// No usar esta función. Es referencia temporal.
	//function calcular_pfa($fecha_ini, $fecha_fin)
	function calcular_pfa_antes($fecha_procesar)
	{
return;
// No usar esta función. Es referencia temporal.
		global $adb;

		$per_id = $this->obtener_id();

/*********************
		if (($fecha_fin == "") || ($fecha_fin == "0000-00-00"))
		{
			$fecha_fin = $this->column_fields["fecha_fin"];
		}
**********************/
		// Primero detecta posibles huecos para regenerar sus por_facturar.

		$fecha_comparar = new DateTime($this->column_fields["fecha_ini"], new DateTimeZone("America/Mexico_City"));
		$huecos = array();

		$consulta = "select pfa.* from vtiger_por_facturar pfa, vtiger_crmentity e where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.periodosid = '$per_id' order by fecha_ini";
		$resultado = $adb->query($consulta);
		while ($renglon = $adb->fetch_array($resultado))
		{
/**************
			echo "<pre>";
			var_dump($renglon["idv"], $renglon["fecha_ini"], $renglon["fecha_fin"], "comparar:".$fecha_comparar->format("Y-m-d"));
			echo "</pre>";
**************/

			unset($hueco);

			$fecha_ini = new DateTime($renglon["fecha_ini"], new DateTimeZone("America/Mexico_City"));
			$fecha_fin = new DateTime($renglon["fecha_fin"], new DateTimeZone("America/Mexico_City"));

			if ($fecha_ini > $fecha_comparar)
			{
				$hueco["ini"] = $fecha_comparar->format("Y-m-d");
				$fecha_ini->modify(" -1 day");
				$hueco["fin"] = $fecha_ini->format("Y-m-d");

				$huecos[] = $hueco;
			}

			$fecha_comparar = new DateTime($renglon["fecha_fin"]." +1 day", new DateTimeZone("America/Mexico_City"));
			
		}

/**********************
		echo "<pre>";
		var_dump($huecos);
		var_dump($fecha_fin->format("Y-m-d"));
		echo "</pre>";
***********************/
//die;

		// Se respalda el dato de hasta dónde estaban calculados los por_facturar.
		$calculado_hasta = $this->column_fields["facturado_hasta"];

		// Hace un barrido de los huecos encontrados y los procesa.
		foreach ($huecos as $hueco)
		{
			$fecha_ini->modify($hueco["ini"]." -1 day");
//var_dump($fecha_ini->format("Y-m-d"));
			//$this->column_fields["facturado_hasta"] = $hueco["ini"];
			$this->column_fields["facturado_hasta"] = $fecha_ini->format("Y-m-d");
			$this->facturar($hueco["fin"]);

			if (($calculado_hasta != "") && ($calculado_hasta != "0000-00-00"))
			{
				$this->column_fields["facturado_hasta"] = $calculado_hasta;
				$this->save("Periodos", $per_id);
			}
		}

		// Termina procesando a partir de la fecha final del último por_facturar hasta la fecha solicitada.
		$fecha_proc = new DateTime($fecha_procesar, new DateTimeZone("America/Mexico_City"));
		if ($fecha_proc > $fecha_fin)
		{
			$this->column_fields["facturado_hasta"] = $fecha_fin->format("Y-m-d");
			$this->facturar($fecha_procesar);
		}
	}

	// Calcula los días contabilizados en el periodo. Pueden verse afectados por la hora efectiva.
	function dias()
	{
		$fecha_ini = new DateTime($this->column_fields["fecha_ini"], new DateTimeZone("America/Mexico_City"));
		$fecha_fin = new DateTime($this->column_fields["fecha_fin"], new DateTimeZone("America/Mexico_City"));

		$diferencia = $fecha_fin->diff($fecha_ini)->d;

		return $diferencia;
	}

	// Ajustar si hay facturación por adelantado.
	function ajustar_adelantado($per2_id = "")
	{
//var_dump($per2_id);
		$per_id = $this->obtener_id();
		$per_fecha_fin = $this->column_fields["fecha_fin"];
		$per_folio = $this->column_fields["idv"];
		//$per_movimiento_apertura = $this->column_fields["movimiento_apertura"];
		$per_movimiento_cierre = $this->column_fields["movimiento_cierre"];
		$per_cantidad = $this->column_fields["cantidad"];
		$per_calculado_hasta = $this->column_fields["facturado_hasta"];
		$flr_id = $this->column_fields["equipo"];

		$flr = new Flota_renta;
		$flr->retrieve_entity_info($flr_id, "Flota_renta");
		$individual = $flr->individual();

		if ($per2_id != "")
		{
			$per2 = new Periodos;
			$per2->retrieve_entity_info($per2_id, "Periodos");
			$per2->limpiar_por_facturar();
		}

//var_dump($per_fecha_fin);
//var_dump($per_folio);
//var_dump($per_movimiento_cierre);
//var_dump($per_calculado_hasta);

		global $adb;

		$consulta = "select pfa.* from vtiger_por_facturar pfa, vtiger_crmentity e where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.periodosid = '$per_id' and pfa.fecha_fin >= '$per_fecha_fin'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		//$renglon = $adb->fetch_array($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
	//echo "<pre>";
	//var_dump($renglon);
	//echo "</pre>";
//die;
			$pfa_id = $renglon["por_facturarid"];
			$pfa_folio = $renglon["idv"];
			$pfa_estado = $renglon["estado"];
			$pfa_fecha_ini = $renglon["fecha_ini"];
			$pfa_fecha_fin = $renglon["fecha_fin"];
/*************
	$pfa_folio = $renglon["folio"];
	$pfa_sucursal = $renglon["sucursal"];
	$pfa_cliente = $renglon["cliente"];
	$pfa_obra = $renglon["obra"];
	$pfa_producto = $renglon["producto"];
	$pfa_equipo = $renglon["equipo"];
	$pfa_numero_serie = $renglon["numero_serie"];
	$pfa_periodo = $renglon["periodo"];
	$pfa_estado = $renglon["estado"];
	$pfa_fecha_ini = $renglon["fecha_ini"];
	$pfa_fecha_fin = $renglon["fecha_fin"];
	$pfa_cantidad = $renglon["cantidad"];
	$pfa_dias = $renglon["dias"];
	$pfa_factura = $renglon["factura"];
	$pfa_concepto = $renglon["concepto"];
	$pfa_segmento = $renglon["segmento"];
	$pfa_agrupador = $renglon["agrupador"];
	$pfa_contenedor = $renglon["contenedor"];
	$pfa_movimiento = $renglon["movimiento"];
	$pfa_adelantado = $renglon["adelantado"];
	$pfa_fecha_ini_fac = $renglon["fecha_ini_fac"];
	$pfa_fecha_fin_fac = $renglon["fecha_fin_fac"];
	$pfa_dias_fac = $renglon["dias_fac"];
	$pfa_cantidad_fac = $renglon["cantidad_fac"];
	$pfa_precio_unitario_fac = $renglon["precio_unitario_fac"];
*********/
//var_dump($pfa_folio);
			$fecha_ini = new DateTime($pfa_fecha_ini);
			$fecha_fin = new DateTime($pfa_fecha_fin);
			$fecha_cierre = new DateTime($per_fecha_fin);
			$fecha_calculado = new DateTime($per_calculado_hasta);

			// Lee valores facturados.
			$consulta2 = "select facd.facturas_detid, facd.precio_unitario from vtiger_facturas_det facd, vtiger_crmentity e where e.crmid = facd.facturas_detid and e.deleted = '0' and facd.por_facturarid = '$pfa_id'";
//var_dump($consulta2);
			$resultado2 = $adb->query($consulta2);
			$renglon2 = $adb->fetch_array($resultado2);
	//echo "<pre>";
	//var_dump($renglon2);
	//echo "</pre>";
//die;
			$facd_id = $renglon2["facturas_detid"];
			$facd_precio_unitario = $renglon2["precio_unitario"];

			// Hay 3 casos:
			// 1. PFA adelantado posterior a cierre de periodo.
			// 2. PFA adelantado que contiene fecha de cierre de periodo.
			// 3. PFA pendiente generado por la remisión que cierra el periodo.

			// 1. PFA adelantado posterior a cierre de periodo.
			if (($pfa_estado == 'Facturado') && ($fecha_ini > $fecha_cierre))
			{
				//echo "caso 1";
/****************************
				// Acciones para recolección:
				// Clonar y convertirlos en saldo a favor.
				$pfa = new Por_facturar;
				$pfa->retrieve_entity_info($pfa_id, "Por_facturar");
				$pfa->column_fields["estado"] = "Pendiente";
				$pfa->column_fields["factura"] = "";
				$pfa->column_fields["dias"] *= -1;
				$pfa->column_fields["precio_unitario_fac"] = $renglon2["precio_unitario"];
				$pfa->save("Por_facturar");

				// Si al cerrar el periodo se abre uno nuevo, genera la contraparte del segundo periodo.
				if ($per2_id != "")
				{
					$pfa->column_fields["periodo"] = $per2_id;
					$pfa->column_fields["equipo"] = $per2->column_fields["equipo"];
					$pfa->column_fields["cantidad"] = $per2->column_fields["cantidad"];
					$pfa->column_fields["dias"] *= -1;
					$pfa->save("Por_facturar");
				}
****************************/

				$pfa = new Por_facturar;
				$pfa->retrieve_entity_info($pfa_id, "Por_facturar");
				$pfa->column_fields["estado"] = "Pendiente";
				$pfa->column_fields["factura"] = "";
				$pfa->column_fields["precio_unitario_fac"] = $renglon2["precio_unitario"];
				if ($individual)
				{
					$pfa->column_fields["dias"] *= -1;
				}
				//$pfa->save("Por_facturar");

				// Si al cerrar el periodo se abre uno nuevo, genera la contraparte del segundo periodo.
				if ($per2_id != "")
				{
					$pfa->column_fields["periodo"] = $per2_id;
					$pfa->column_fields["equipo"] = $per2->column_fields["equipo"];
					//$pfa->column_fields["cantidad"] = $per2->column_fields["cantidad"];
					if ($per2->column_fields["cantidad"] > $per_cantidad)
					{
						$pfa->column_fields["cantidad"] = $per2->column_fields["cantidad"] - $per_cantidad;
					}

					if ($per2->column_fields["cantidad"] < $per_cantidad)
					{
						$pfa->column_fields["cantidad"] = $per_cantidad - $per2->column_fields["cantidad"];
						$pfa->column_fields["dias"] *= -1;
					}

					if ($per2->column_fields["cantidad"] == $per_cantidad)
					{
						$pfa->column_fields["cantidad"] = $per_cantidad;
						$pfa->column_fields["dias"] = 0;
					}

					//$pfa->save("Por_facturar");
				}

				$pfa->save("Por_facturar");
			}

			// 2. PFA adelantado que contiene fecha de cierre de periodo.
			if (($pfa_estado == 'Facturado') && ($fecha_cierre > $fecha_ini) && ($fecha_fin > $fecha_cierre))
			{
				// Acciones para recolección:
				// Generar el segmento derecho como saldo a favor.
				//echo "caso 2";
/*******************
				$pfa = new Por_facturar;
				$pfa->retrieve_entity_info($pfa_id, "Por_facturar");
				$pfa->column_fields["estado"] = "Pendiente";
				$pfa->column_fields["factura"] = "";
				$pfa->column_fields["fecha_ini"] = date("Y-m-d", strtotime($per_fecha_fin." +1 day"));
				$pfa->column_fields["dias"] = ($fecha_fin->diff($fecha_cierre)->days) * -1;
				$pfa->column_fields["precio_unitario_fac"] = $renglon2["precio_unitario"];
				$pfa->save("Por_facturar");

				// Si al cerrar el periodo se abre uno nuevo, genera la contraparte del segundo periodo.
				if ($per2_id != "")
				{
					$pfa->column_fields["periodo"] = $per2_id;
					$pfa->column_fields["equipo"] = $per2->column_fields["equipo"];
					$pfa->column_fields["cantidad"] = $per2->column_fields["cantidad"];
					$pfa->column_fields["dias"] *= -1;
					$pfa->save("Por_facturar");
				}
******************/

				$pfa = new Por_facturar;
				$pfa->retrieve_entity_info($pfa_id, "Por_facturar");
				$pfa->column_fields["estado"] = "Pendiente";
				$pfa->column_fields["factura"] = "";
				$pfa->column_fields["fecha_ini"] = date("Y-m-d", strtotime($per_fecha_fin." +1 day"));
				//$pfa->column_fields["dias"] = ($fecha_fin->diff($fecha_cierre)->days) * -1;
				$pfa->column_fields["dias"] = ($fecha_fin->diff($fecha_cierre)->days);
				$pfa->column_fields["precio_unitario_fac"] = $renglon2["precio_unitario"];
				//$pfa->save("Por_facturar");
				if ($individual)
				{
					$pfa->column_fields["dias"] *= -1;
				}

				// Si al cerrar el periodo se abre uno nuevo, genera la contraparte del segundo periodo.
				if ($per2_id != "")
				{
					$pfa->column_fields["periodo"] = $per2_id;
					$pfa->column_fields["equipo"] = $per2->column_fields["equipo"];
					//$pfa->column_fields["cantidad"] = $per2->column_fields["cantidad"];
					//$pfa->column_fields["cantidad"] = $per2->column_fields["cantidad"] - $per_cantidad;
					if ($per2->column_fields["cantidad"] > $per_cantidad)
					{
						$pfa->column_fields["cantidad"] = $per2->column_fields["cantidad"] - $per_cantidad;
					}

					if ($per2->column_fields["cantidad"] < $per_cantidad)
					{
						$pfa->column_fields["cantidad"] = $per_cantidad - $per2->column_fields["cantidad"];
						$pfa->column_fields["dias"] *= -1;
					}

					if ($per2->column_fields["cantidad"] == $per_cantidad)
					{
						$pfa->column_fields["cantidad"] = $per_cantidad;
						$pfa->column_fields["dias"] = 0;
					}

					//$pfa->column_fields["dias"] *= -1;
					//$pfa->save("Por_facturar");
				}

				$pfa->save("Por_facturar");
			}

			// 3. PFA pendiente generado por la remisión que cierra el periodo.
			//if (($pfa_estado == 'Pendiente') && ($fecha_fin == $fecha_cierre))
			if (($pfa_estado == 'Pendiente') && ($fecha_fin == $fecha_cierre) && ($fecha_calculado > $fecha_cierre))
			{
				//echo "caso 3";
				// Acciones para recolección:
				// Ponerlo en ceros pues ya se cobró.
				$pfa = new Por_facturar;
				$pfa->retrieve_entity_info($pfa_id, "Por_facturar");
				$pfa->column_fields["dias"] = 0;
				$pfa->column_fields["precio_unitario_fac"] = $renglon2["precio_unitario"];
				$pfa->save("Por_facturar", $pfa_id);
			}
		}

		// Actualiza el calculado hasta del periodo 2.
		if ($per2_id != "")
		{
			$consulta = "select max(pfa.fecha_fin) as calculado_hasta from vtiger_periodos per, vtiger_crmentity e, vtiger_por_facturar pfa, vtiger_crmentity e2 where e.crmid = per.periodosid and e.deleted = '0' and e2.crmid = pfa.por_facturarid and e2.deleted = '0' and per.periodosid = '$per2_id' and pfa.periodosid = per.periodosid";
//var_dump($consulta);
			$resultado = $adb->query($consulta);
			$renglon = $adb->fetch_array($resultado);

			$calculado_hasta = $renglon["calculado_hasta"];

			$consulta = "update vtiger_periodos per set per.facturado_hasta = '$calculado_hasta' where per.periodosid = '$per2_id'";
			$adb->query($consulta);
		}
//var_dump($pfa_fecha_fin);
//var_dump("adelantado");
//die;
	}

	// Genera la afectacióndel periodo, calculando horómetro teórico.
	function afectacion($sobrescribir_horometros = false)
	{
		global $adb;

		$per_id = $this->obtener_id();
		$per_folio = $this->column_fields["idv"];
//var_dump($per_folio);
//die;

		// Borra primero un posible registro de afectación existente.
		$consulta = "update vtiger_afectacion afe, vtiger_crmentity e set e.deleted = '1' where e.crmid = afe.afectacionid and e.deleted = '0' and afe.documento = '$per_folio'";
//var_dump($consulta);
		$adb->query($consulta);


		$per_sucursal = $this->column_fields["sucursal"];
		$per_cliente = $this->column_fields["cliente"];
		$per_obra = $this->column_fields["obra"];
		$per_estado = $this->column_fields["estado"];
		$per_fecha_ini = $this->column_fields["fecha_ini"];
		$per_fecha_fin = $this->column_fields["fecha_fin"];
		$per_movimiento_apertura = $this->column_fields["movimiento_apertura"];
		$per_movimiento_cierre = $this->column_fields["movimiento_cierre"];
		$flr_id = $this->column_fields["equipo"];
		$horas_uso = 0;
		$fecha_ini = new DateTime($per_fecha_ini);
		if ($per_estado == "Cerrado")
		{
			$fecha_fin = new DateTime($per_fecha_fin);

			$letra_remision = substr($per_movimiento_apertura, 1, 1);
			switch ($letra_remision)
			{
				case "E":
					$consulta2 = "select remd.horometro from vtiger_remisiones_det remd, vtiger_crmentity e, vtiger_entregas ent where e.crmid = remd.remisiones_detid and e.deleted = '0' and remd.entregasid = ent.entregasid and ent.folio =  '$per_movimiento_apertura' and remd.flota_rentaid = '$flr_id'";
				break;
				case "C":
					$consulta2 = "select remd.horometro from vtiger_remisiones_det remd, vtiger_crmentity e, vtiger_cambios cmb where e.crmid = remd.remisiones_detid and e.deleted = '0' and remd.cambiosid = cmb.cambiosid and cmb.folio =  '$per_movimiento_apertura' and remd.flota_rentaid = '$flr_id'";
				break;
				case "R":
					$consulta2 = "select remd.horometro from vtiger_remisiones_det remd, vtiger_crmentity e, vtiger_recolecciones rco where e.crmid = remd.remisiones_detid and e.deleted = '0' and remd.recoleccionesid = rco.recoleccionesid and rco.folio =  '$per_movimiento_apertura' and remd.flota_rentaid = '$flr_id'";
				break;
			}

//var_dump($consulta2);
//die;
			$resultado2 = $adb->query($consulta2);
			$renglon2 = $adb->fetch_array($resultado2);
			$horometro_ini = $renglon2["horometro"];


			$letra_remision = substr($per_movimiento_cierre, 1, 1);
			switch ($letra_remision)
			{
				case "E":
					$consulta2 = "select remd.horometro from vtiger_remisiones_det remd, vtiger_crmentity e, vtiger_entregas ent where e.crmid = remd.remisiones_detid and e.deleted = '0' and remd.entregasid = ent.entregasid and ent.folio =  '$per_movimiento_cierre' and remd.flota_rentaid = '$flr_id'";
				break;
				case "C":
					$consulta2 = "select remd.horometro from vtiger_remisiones_det remd, vtiger_crmentity e, vtiger_cambios cmb where e.crmid = remd.remisiones_detid and e.deleted = '0' and remd.cambiosid = cmb.cambiosid and cmb.folio =  '$per_movimiento_cierre' and remd.flota_rentaid = '$flr_id'";
				break;
				case "R":
					$consulta2 = "select remd.horometro from vtiger_remisiones_det remd, vtiger_crmentity e, vtiger_recolecciones rco where e.crmid = remd.remisiones_detid and e.deleted = '0' and remd.recoleccionesid = rco.recoleccionesid and rco.folio =  '$per_movimiento_cierre' and remd.flota_rentaid = '$flr_id'";
				break;
			}

			$resultado2 = $adb->query($consulta2);
			$renglon2 = $adb->fetch_array($resultado2);
			$horometro_fin = $renglon2["horometro"];

			$horas_uso = $horometro_fin - $horometro_ini;
		}
		else
		{
			$fecha_fin = new DateTime(date("Y-m-d"));
		}

		switch ($this->column_fields["turno"])
		{
			case "Doble":
				$per_turno = 2;
			break;
			case "Triple":
				$per_turno = 3;
			break;
			default:
				$per_turno = 1;
			break;
		}
		$uso_teorico = 0;
		$uso_teorico = ($fecha_fin->diff($fecha_ini)->days + 1) * $per_turno * 8;
		//$horas_uso = 0;
		//$horas_uso = ($fecha_fin->diff($fecha_ini)->days + 1) * $per_turno * 8;

		$flr_id = $this->column_fields["equipo"];
		if ($flr_id != "")
		{
			$flr = new Flota_renta;
			$flr->retrieve_entity_info($flr_id, "Flota_renta");
		}

		$afe = new Afectacion;
		$afe->column_fields["assigned_user_id"] = 1;
		$afe->column_fields["modulo"] = "Periodos";
		$afe->column_fields["crmid"] = $per_id;
		//$afe->column_fields["horometro"] = $ot_horometro;
		//$afe->column_fields["combustible"] = $remd_combustible;
		$afe->column_fields["documento"] = $per_folio;
		$afe->column_fields["sucursal"] = $per_sucursal;
		$afe->column_fields["cliente"] = $per_cliente;
		$afe->column_fields["obra"] = $per_obra;
		$afe->column_fields["producto"] = $flr->column_fields["producto"];
		//$afe->column_fields["fecha_efectiva"] = ($ot_terminada)?$ot_fecha_fin:$ot_fecha_ini;
		//$afe->column_fields["hora_efectiva"] = $this->column_fields["hora_efectiva"];
		$afe->column_fields["horas_uso"] = $horas_uso;
		$afe->column_fields["uso_teorico"] = $uso_teorico;
		$afe->column_fields["codigo"] = $flr->column_fields["numero_interno"];
		$afe->column_fields["cantidad"] = $this->column_fields["cantidad"];
		$afe->column_fields["almacen"] = $this->column_fields["almacen"];
		$afe->column_fields["numero_interno"] = $this->column_fields["equipo"];
		$afe->column_fields["numero_serie"] = $this->column_fields["numero_serie"];

		$afe->save("Afectacion");

		if ($sobrescribir_horometros)
		{
			$horometro_teorico = $flr->horometro_teorico();
			//$consulta = "update vtiger_flota_renta flr set flr.horometro_teorico = ('$uso_teorico' + flr.horometro_teorico) where flr.flota_rentaid = '$flr_id'";
			//$consulta = "update vtiger_flota_renta flr set flr.horometro_teorico = '$uso_teorico' where flr.flota_rentaid = '$flr_id'";
			$consulta = "update vtiger_flota_renta flr set flr.horometro_teorico = '$horometro_teorico' where flr.flota_rentaid = '$flr_id'";
			$adb->query($consulta);
		}





/*************************************************
		// Borra primero los posibles registros existentes.
		//$consulta = "update vtiger_remisiones_det remd, vtiger_crmentity e, vtiger_flota_renta flr where e.crmid = remd.remisiones_detid and e.deleted = '0' and flr.flota_rentaid = remd.flota_rentaid and flr.numero_interno = 'EGEJ002'";

		//$consulta = "select remd.* from vtiger_remisiones_det remd, vtiger_crmentity e, vtiger_flota_renta flr where e.crmid = remd.remisiones_detid and e.deleted = '0' and flr.flota_rentaid = remd.flota_rentaid and flr.numero_interno = 'EGEJ002'";
var_dump("afectacion");
//var_dump($per_id);
//var_dump($this->column_fields["equipo"]);
//die;
		$consulta = "select per.* from vtiger_periodos per, vtiger_crmentity e, vtiger_flota_renta flr where e.crmid = per.periodosid and e.deleted = '0' and flr.flota_rentaid = per.flota_rentaid and flr.numero_interno = 'EGEJ002'";
var_dump($consulta);
		$resultado = $adb->query($consulta);
//$renglon = $adb->fetch_array($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
	//echo "<pre>";
	//var_dump($renglon);
	//echo "</pre>";
//die;

			$per_id = $renglon["periodosid"];
			$per_folio = $renglon["idv"];
			$per_sucursal = $renglon["sucursalesid"];
			$per_cliente = $renglon["accountid"];
			$per_obra = $renglon["obrasid"];
			$per_estado = $renglon["estado"];
			$per_fecha_ini = $renglon["fecha_ini"];
			$per_fecha_fin = $renglon["fecha_fin"];
			$fecha_ini = new DateTime($per_fecha_ini);
			if ($per_estado == "Cerrado")
			{
				$fecha_fin = new DateTime($per_fecha_fin);
			}
			else
			{
				$fecha_fin = new DateTime(date("Y-m-d"));
			}

			$horas_uso = 0;
			if ($per_turno == "")
			{
				$per_turno = 1;
			}
			$horas_uso = ($fecha_fin->diff($fecha_ini)->days + 1) * $per_turno * 8;
***********************************/

/************************
	$per_equipo = $renglon["equipo"];
	$per_cantidad = $renglon["cantidad"];
	$per_facturado_hasta = $renglon["facturado_hasta"];
	$per_movimiento_apertura = $renglon["movimiento_apertura"];
	$per_movimiento_cierre = $renglon["movimiento_cierre"];
	$per_ultima_factura = $renglon["ultima_factura"];
************************/

/***********************************
			$afe = new Afectacion;
			$afe->column_fields["assigned_user_id"] = 1;
			$afe->column_fields["modulo"] = "Periodos";
			$afe->column_fields["crmid"] = $per_id;
			//$afe->column_fields["horometro"] = $ot_horometro;
			//$afe->column_fields["combustible"] = $remd_combustible;
			$afe->column_fields["documento"] = $per_folio;
			$afe->column_fields["sucursal"] = $per_sucursal;
			$afe->column_fields["cliente"] = $per_cliente;
			$afe->column_fields["obra"] = $per_obra;
			$afe->column_fields["producto"] = $renglon["productid"];
			//$afe->column_fields["fecha_efectiva"] = ($ot_terminada)?$ot_fecha_fin:$ot_fecha_ini;
			//$afe->column_fields["hora_efectiva"] = $renglon2["hora_efectiva"];
			$afe->column_fields["horas_uso"] = $horas_uso;
**********************************/
/**********************
$afe->column_fields["folio"] = $renglon["folio"];
$afe->column_fields["ado_tipo_documento"] = $renglon["ado_tipo_documento"];
$afe->column_fields["proveedor"] = $renglon["proveedor"];
$afe->column_fields["subarrendado"] = $renglon["subarrendado"];
$afe->column_fields["ado_tipo_interno"] = $renglon["ado_tipo_interno"];
$afe->column_fields["codigo"] = $renglon["codigo"];
$afe->column_fields["cantidad"] = $renglon["cantidad"];
$afe->column_fields["almacen"] = $renglon["almacen"];
$afe->column_fields["numero_interno"] = $renglon["numero_interno"];
$afe->column_fields["numero_serie"] = $renglon["numero_serie"];
$afe->column_fields["costo"] = $renglon["costo"];
$afe->column_fields["modulo"] = $renglon["modulo"];
$afe->column_fields["crmid"] = $renglon["crmid"];
$afe->column_fields["horometro"] = $renglon["horometro"];
$afe->column_fields["combustible"] = $renglon["combustible"];
**********************/

/****************************
			$afe->save("Afectacion");
		}
***************************/
	}

	// Genera un por_facturar de horas extra.
	function facturar_horas_extra()
	{
		global $adb;

		$per_id = $this->obtener_id();
		$per_folio = $this->column_fields["idv"];
		$per_turno = $this->column_fields["per_turno"];

		$flr = new Flota_renta;
		$flr_id = $this->column_fields["equipo"];
		$flr->retrieve_entity_info($flr_id, "Flota_renta");

		// Si este equipo no permite horas extra no hay nada que calcular.
		if (!$lin->column_fields["hextra"])
		{
			return;
		}

		$prod = new Products;
		$prod_id = $flr->column_fields["producto"];
		if ($prod_id == "")
		{
			die ("<h1>ERROR</h1>El registro de flota de renta no tiene producto.");
		}
		$prod->retrieve_entity_info($prod_id, "Products");

		$lin = new Lineas;
		$lin_id = $prod->personalizado("linea");
		if ($lin_id == "")
		{
			die ("<h1>ERROR</h1>El producto no tiene línea.");
		}
		$lin->retrieve_entity_info($lin_id, "Lineas");

		$precio_dia = $lin->precio_facturar($this->column_fields["sucursal"], $this->column_fields["cliente"], $this->column_fields["obra"], $per_id);
		$precio_hora = $precio_dia / 24;

		// Elimina un posible registro previo. Sólo se considera si está pendiente.
		$consulta = "update vtiger_por_facturar pfa, vtiger_crmentity e set e.deleted = '1' where e.crmid = pfa.por_facturarid and e.deleted = '0' and pfa.estado = 'Pendiente' and pfa.concepto = 'Horas extra' and pfa.periodosid = '$per_id'";
//var_dump($consulta);
//die;
		$adb->query($consulta);

		$consulta = "select afe.* from vtiger_afectacion afe, vtiger_crmentity e where e.crmid = afe.afectacionid and e.deleted = '0' and afe.documento = '$per_folio'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);

		$pfa = new Por_facturar;
		$pfa->column_fields["assigned_user_id"] = 1;
		$pfa->column_fields["sucursal"] = $this->column_fields["sucursal"];
		$pfa->column_fields["cliente"] = $this->column_fields["cliente"];
		$pfa->column_fields["obra"] = $this->column_fields["obra"];
		$pfa->column_fields["producto"] = $flr->column_fields["producto"];
		$pfa->column_fields["cantidad"] = $this->column_fields["cantidad"];;
		//$pfa->column_fields["dias"] = $cantidad;
		$pfa->column_fields["dias"] = $renglon["horas_uso"] - $renglon["uso_teorico"];
		$pfa->column_fields["precio_unitario_fac"] = $precio_hora;
		$pfa->column_fields["concepto"] = "Horas extra";
		$pfa->column_fields["movimiento"] = $this->column_fields["folio"];
		$pfa->column_fields["estado"] = "Pendiente";
		$pfa->column_fields["periodo"] = $per_id;
		$pfa->column_fields["equipo"] = $flr_id;
		$pfa->column_fields["fecha_ini"] = $this->column_fields["fecha_ini"];
		$pfa->column_fields["fecha_fin"] = $this->column_fields["fecha_fin"];
		$pfa->save("Por_facturar");

		$pfa_id = $pfa->obtener_id();
		return $pfa_id;
	}

	// Corrige posibles por_facturar duplicados producto de haber agrupado y después recalculado facturación.
	function corregir_duplicados()
	{
		global $adb;

		$per_id = $this->obtener_id();

		//$archivo = fopen ("aux/bitacora_duplicados.txt", "a");
		$archivo = fopen ("aux/bitacora.txt", "a");
		$mensaje = "Corrección duplicados ".$this->column_fields["idv"]." ($per_id) ".date("Y-m-d H:i:s");
		fwrite($archivo, html_entity_decode("$mensaje\n", ENT_QUOTES, "UTF-8"));

		$consulta = "select pfap.por_facturarid as pfap_id, pfap.idv as pfap_folio, pfap.fecha_ini as pfap_fecha_ini, pfap.fecha_fin as pfap_fecha_fin, pfap.estado as pfap_estado, pfap.dias as pfap_dias, pfap.cantidad as pfap_cantidad, pfaf.idv as pfaf_folio, pfaf.fecha_ini as pfaf_fecha_ini, pfaf.fecha_fin as pfaf_fecha_fin, pfaf.estado as pfaf_estado, pfaf.dias as pfaf_dias, pfaf.cantidad as pfaf_cantidad from vtiger_por_facturar pfap, vtiger_crmentity e, vtiger_por_facturar pfaf, vtiger_crmentity e2 where e.crmid = pfap.por_facturarid and e.deleted = '0' and e2.crmid = pfaf.por_facturarid and e2.deleted = '0' and pfap.periodosid = '$per_id' and pfap.estado = 'Pendiente' and pfap.concepto = 'Renta de equipo' and pfaf.periodosid = pfap.periodosid and pfaf.estado = 'Facturado' and pfaf.fecha_ini <= pfap.fecha_ini and pfaf.fecha_fin >= pfap.fecha_fin";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		//$renglon = $adb->fetch_array($resultado);
		$i = 1;
		while ($renglon = $adb->fetch_array($resultado))
		{
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
			$pfap_id = $renglon["pfap_id"];
			$pfap_folio = $renglon["pfap_folio"];
			$pfap_fecha_ini = $renglon["pfap_fecha_ini"];
			$pfap_fecha_fin = $renglon["pfap_fecha_fin"];
			$pfap_cantidad = $renglon["pfap_cantidad"];
			$pfap_dias = $renglon["pfap_dias"];
			$pfap_estado = $renglon["pfap_estado"];
			$pfaf_folio = $renglon["pfaf_folio"];
			$pfaf_fecha_ini = $renglon["pfaf_fecha_ini"];
			$pfaf_fecha_fin = $renglon["pfaf_fecha_fin"];
			$pfaf_cantidad = $renglon["pfaf_cantidad"];
			$pfaf_dias = $renglon["pfaf_dias"];
			$pfaf_estado = $renglon["pfaf_estado"];

			$instrucciones[$i] = "update vtiger_crmentity e set e.deleted = '1' where e.crmid = '$pfap_id'";
			$bitacora[$i] = "$i. Caso 1: Borrar $pfap_folio ($pfap_fecha_ini a $pfap_fecha_fin, d&iacute;as:$pfap_dias, cant:$pfap_cantidad). Ya existe $pfaf_folio ($pfaf_fecha_ini a $pfaf_fecha_fin, d&iacute;as:$pfaf_dias, cant:$pfaf_cantidad).";
			$i++;
/************************
	$pfa_sucursal = $renglon["sucursal"];
	$pfa_cliente = $renglon["cliente"];
	$pfa_obra = $renglon["obra"];
	$pfa_producto = $renglon["producto"];
	$pfa_equipo = $renglon["equipo"];
	$pfa_numero_serie = $renglon["numero_serie"];
	$pfa_periodo = $renglon["periodo"];
	$pfa_factura = $renglon["factura"];
	$pfa_concepto = $renglon["concepto"];
	$pfa_segmento = $renglon["segmento"];
	$pfa_agrupador = $renglon["agrupador"];
	$pfa_contenedor = $renglon["contenedor"];
	$pfa_movimiento = $renglon["movimiento"];
	$pfa_moneda = $renglon["moneda"];
	$pfa_tipo_cambio = $renglon["tipo_cambio"];
	$pfa_fecha_ini_fac = $renglon["fecha_ini_fac"];
	$pfa_fecha_fin_fac = $renglon["fecha_fin_fac"];
	$pfa_dias_fac = $renglon["dias_fac"];
	$pfa_cantidad_fac = $renglon["cantidad_fac"];
	$pfa_precio_unitario_fac = $renglon["precio_unitario_fac"];
************************/
		}

		foreach ($instrucciones as $i => $instruccion)
		{
			//echo $bitacora[$i]."<br>";
			$mensaje = $bitacora[$i];
			fwrite($archivo, html_entity_decode("$mensaje\n", ENT_QUOTES, "UTF-8"));
			//echo "$instruccion<br>";
			$mensaje = $instruccion;
			fwrite($archivo, html_entity_decode("$mensaje\n", ENT_QUOTES, "UTF-8"));
			$adb->query($instruccion);
		}

		//echo "Terminado.";
		$mensaje = "Terminado.";
		fwrite($archivo, html_entity_decode("$mensaje\n", ENT_QUOTES, "UTF-8"));
		fclose($archivo);
	}
}
?>
