<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
require_once('data/CRMEntity.php');
require_once('data/Tracker.php');
require_once("config.php");
require_once('include/utils/utils.php');
require_once('modules/Existencias/Existencias.php');
require_once('modules/Products/Products.php');
require_once('modules/Recepciones_mercancia/Recepciones_mercancia.php');
require_once('modules/Altas_flota_renta/Altas_flota_renta.php');
require_once('modules/Users/Users.php');
require_once('modules/Sucursales/Sucursales.php');
require_once('modules/Lineas/Lineas.php');
require_once('modules/Kardex/Kardex.php');
require_once('modules/Numeros_serie/Numeros_serie.php');
require_once('modules/Dias_subarrendamiento/Dias_subarrendamiento.php');
require_once('modules/Recepciones_mercancia_det/Recepciones_mercancia_det.php');
require_once("modules/Notas_credito_proveedor/Notas_credito_proveedor.php");
require_once("modules/Notas_credito_prov_det/Notas_credito_prov_det.php");
require_once("modules/Vendors/Vendors.php");

class Recepciones_mercancia extends CRMEntity {
	var $db, $log; // Used in class functions of CRMEntity

	var $table_name = 'vtiger_recepciones_mercancia';
	var $table_index= 'recepciones_mercanciaid';
	var $column_fields = Array();

	/** Indicator if this is a custom module or standard module */
	var $IsCustomModule = true;

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_recepciones_mercanciacf', 'recepciones_mercanciaid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_recepciones_mercancia', 'vtiger_recepciones_mercanciacf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_recepciones_mercancia'   => 'recepciones_mercanciaid',
	    'vtiger_recepciones_mercanciacf' => 'recepciones_mercanciaid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Recepciones_mercancia Name'=> Array('recepciones_mercancia', 'idv'),
		'Assigned To' => Array('crmentity','smownerid')
	);
	var $list_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Recepciones_mercancia Name'=> 'idv',
		'Assigned To' => 'assigned_user_id'
	);

	// Make the field link to detail view from list view (Fieldname)
	var $list_link_field = 'idv';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Recepciones_mercancia Name'=> Array('recepciones_mercancia', 'idv')
	);
	var $search_fields_name = Array(
		/* Format: Field Label => fieldname */
		'Recepciones_mercancia Name'=> 'idv'
	);

	// For Popup window record selection
	var $popup_fields = Array('idv');

	// Placeholder for sort fields - All the fields will be initialized for Sorting through initSortFields
	var $sortby_fields = Array();

	// For Alphabetical search
	var $def_basicsearch_col = 'idv';

	// Column value to use on detail view record text display
	var $def_detailview_recname = 'idv';

	// Required Information for enabling Import feature
	var $required_fields = Array('idv'=>1);

	// Callback function list during Importing
	var $special_functions = Array('set_import_assigned_user');

	var $default_order_by = 'idv';
	var $default_sort_order='ASC';
	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('createdtime', 'modifiedtime', 'idv');
	
	function __construct() {
		global $log, $currentModule;
		$this->column_fields = getColumnFields($currentModule);
		$this->db = PearDatabase::getInstance();
		$this->log = $log;
	}

	function getSortOrder() {
		global $currentModule;

		$sortorder = $this->default_sort_order;
		if($_REQUEST['sorder']) $sortorder = $this->db->sql_escape_string($_REQUEST['sorder']);
		else if($_SESSION[$currentModule.'_Sort_Order']) 
			$sortorder = $_SESSION[$currentModule.'_Sort_Order'];

		return $sortorder;
	}

	function getOrderBy() {
		global $currentModule;
		
		$use_default_order_by = '';		
		if(PerformancePrefs::getBoolean('LISTVIEW_DEFAULT_SORTING', true)) {
			$use_default_order_by = $this->default_order_by;
		}
		
		$orderby = $use_default_order_by;
		if($_REQUEST['order_by']) $orderby = $this->db->sql_escape_string($_REQUEST['order_by']);
		else if($_SESSION[$currentModule.'_Order_By'])
			$orderby = $_SESSION[$currentModule.'_Order_By'];
		return $orderby;
	}

	function save_module($module) {
		// Si se está corriendo un apartado de folios no procesa.
		//return;
		session_start();
		if ($_SESSION["cor"]["apartar_folios"])
		{
//var_dump("apartando save");
//die;
			return;
		}

//die("save");
		// Validaciones.
/***************************
// Esta lógica era de la estructura anterior (tabla 1).
		if ($this->column_fields["subarrendado"])
		{
			//die("sub");
			if ($this->column_fields["producto1"] == "")
			{
				die ("<h1>ERROR</h1>El primer producto no puede quedar en blanco.");
			}

			for ($i = 2; $i <= 10; $i++)
			{
				if ($this->column_fields["producto$i"] != "")
				{
					die ("<h1>ERROR</h1>En una recepción de mercancía subarrendada sólo se permite manejar un producto.");
				}
			}
			//echo "<pre>";
			//var_dump($this->column_fields);
		}
***************************/

		$this->asignar_dueno("rm");
//die("save");
	}

	/**
	 * Return query to use based on given modulename, fieldname
	 * Useful to handle specific case handling for Popup
	 */
	function getQueryByModuleField($module, $fieldname, $srcrecord, $query='') {
		// $srcrecord could be empty
	}

	/**
	 * Get list view query (send more WHERE clause condition if required)
	 */
	function getListQuery($module, $usewhere='') {
		$query = "SELECT vtiger_crmentity.*, $this->table_name.*";
		
		// Keep track of tables joined to avoid duplicates
		$joinedTables = array();

		// Select Custom Field Table Columns if present
		if(!empty($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$query .= " FROM $this->table_name";

		$query .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		$joinedTables[] = $this->table_name;
		$joinedTables[] = 'vtiger_crmentity';
		
		// Consider custom table join as well.
		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index";
			$joinedTables[] = $this->customFieldTable[0]; 
		}
		$query .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";

		$joinedTables[] = 'vtiger_users';
		$joinedTables[] = 'vtiger_groups';
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($module));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);
		
		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other =  CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			if(!in_array($other->table_name, $joinedTables)) {
				$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
				$joinedTables[] = $other->table_name;
			}
		}

		global $current_user;
		$query .= $this->getNonAdminAccessControlQuery($module,$current_user);
		$query .= "	WHERE vtiger_crmentity.deleted = 0 ".$usewhere;
		return $query;
	}

	/**
	 * Apply security restriction (sharing privilege) query part for List view.
	 */
	function getListViewSecurityParameter($module) {
		global $current_user;
		require('user_privileges/user_privileges_'.$current_user->id.'.php');
		require('user_privileges/sharing_privileges_'.$current_user->id.'.php');

		$sec_query = '';
		$tabid = getTabid($module);

		if($is_admin==false && $profileGlobalPermission[1] == 1 && $profileGlobalPermission[2] == 1 
			&& $defaultOrgSharingPermission[$tabid] == 3) {

				$sec_query .= " AND (vtiger_crmentity.smownerid in($current_user->id) OR vtiger_crmentity.smownerid IN 
					(
						SELECT vtiger_user2role.userid FROM vtiger_user2role 
						INNER JOIN vtiger_users ON vtiger_users.id=vtiger_user2role.userid 
						INNER JOIN vtiger_role ON vtiger_role.roleid=vtiger_user2role.roleid 
						WHERE vtiger_role.parentrole LIKE '".$current_user_parent_role_seq."::%'
					) 
					OR vtiger_crmentity.smownerid IN 
					(
						SELECT shareduserid FROM vtiger_tmp_read_user_sharing_per 
						WHERE userid=".$current_user->id." AND tabid=".$tabid."
					) 
					OR 
						(";
		
					// Build the query based on the group association of current user.
					if(sizeof($current_user_groups) > 0) {
						$sec_query .= " vtiger_groups.groupid IN (". implode(",", $current_user_groups) .") OR ";
					}
					$sec_query .= " vtiger_groups.groupid IN 
						(
							SELECT vtiger_tmp_read_group_sharing_per.sharedgroupid 
							FROM vtiger_tmp_read_group_sharing_per
							WHERE userid=".$current_user->id." and tabid=".$tabid."
						)";
				$sec_query .= ")
				)";
		}
		return $sec_query;
	}

	/**
	 * Create query to export the records.
	 */
	function create_export_query($where)
	{
		global $current_user;
		$thismodule = $_REQUEST['module'];
		
		include("include/utils/ExportUtils.php");

		//To get the Permitted fields query and the permitted fields list
		$sql = getPermittedFieldsQuery($thismodule, "detail_view");
		
		$fields_list = getFieldsListFromQuery($sql);

		$query = "SELECT $fields_list, vtiger_users.user_name AS user_name 
					FROM vtiger_crmentity INNER JOIN $this->table_name ON vtiger_crmentity.crmid=$this->table_name.$this->table_index";

		if(!empty($this->customFieldTable)) {
			$query .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}

		$query .= " LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		$query .= " LEFT JOIN vtiger_users ON vtiger_crmentity.smownerid = vtiger_users.id and vtiger_users.status='Active'";
		
		$linkedModulesQuery = $this->db->pquery("SELECT distinct fieldname, columnname, relmodule FROM vtiger_field" .
				" INNER JOIN vtiger_fieldmodulerel ON vtiger_fieldmodulerel.fieldid = vtiger_field.fieldid" .
				" WHERE uitype='10' AND vtiger_fieldmodulerel.module=?", array($thismodule));
		$linkedFieldsCount = $this->db->num_rows($linkedModulesQuery);

		for($i=0; $i<$linkedFieldsCount; $i++) {
			$related_module = $this->db->query_result($linkedModulesQuery, $i, 'relmodule');
			$fieldname = $this->db->query_result($linkedModulesQuery, $i, 'fieldname');
			$columnname = $this->db->query_result($linkedModulesQuery, $i, 'columnname');
			
			$other = CRMEntity::getInstance($related_module);
			vtlib_setup_modulevars($related_module, $other);
			
			$query .= " LEFT JOIN $other->table_name ON $other->table_name.$other->table_index = $this->table_name.$columnname";
		}

		$query .= $this->getNonAdminAccessControlQuery($thismodule,$current_user);
		$where_auto = " vtiger_crmentity.deleted=0";

		if($where != '') $query .= " WHERE ($where) AND $where_auto";
		else $query .= " WHERE $where_auto";

		return $query;
	}

	/**
	 * Initialize this instance for importing.
	 */
	function initImport($module) {
		$this->db = PearDatabase::getInstance();
		$this->initImportableFields($module);
	}

	/**
	 * Create list query to be shown at the last step of the import.
	 * Called From: modules/Import/UserLastImport.php
	 */
	function create_import_query($module) {
		global $current_user;
		$query = "SELECT vtiger_crmentity.crmid, case when (vtiger_users.user_name not like '') then vtiger_users.user_name else vtiger_groups.groupname end as user_name, $this->table_name.* FROM $this->table_name
			INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index
			LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=vtiger_crmentity.crmid
			LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
			LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid
			WHERE vtiger_users_last_import.assigned_user_id='$current_user->id'
			AND vtiger_users_last_import.bean_type='$module'
			AND vtiger_users_last_import.deleted=0";
		return $query;
	}

	/**
	 * Delete the last imported records.
	 */
	function undo_import($module, $user_id) {
		global $adb;
		$count = 0;
		$query1 = "select bean_id from vtiger_users_last_import where assigned_user_id=? AND bean_type='$module' AND deleted=0";
		$result1 = $adb->pquery($query1, array($user_id)) or die("Error getting last import for undo: ".mysql_error()); 
		while ( $row1 = $adb->fetchByAssoc($result1))
		{
			$query2 = "update vtiger_crmentity set deleted=1 where crmid=?";
			$result2 = $adb->pquery($query2, array($row1['bean_id'])) or die("Error undoing last import: ".mysql_error()); 
			$count++;			
		}
		return $count;
	}
	
	/**
	 * Transform the value while exporting
	 */
	function transform_export_value($key, $value) {
		return parent::transform_export_value($key, $value);
	}

	/**
	 * Function which will set the assigned user id for import record.
	 */
	function set_import_assigned_user()
	{
		global $current_user, $adb;
		$record_user = $this->column_fields["assigned_user_id"];
		
		if($record_user != $current_user->id){
			$sqlresult = $adb->pquery("select id from vtiger_users where id = ? union select groupid as id from vtiger_groups where groupid = ?", array($record_user, $record_user));
			if($this->db->num_rows($sqlresult)!= 1) {
				$this->column_fields["assigned_user_id"] = $current_user->id;
			} else {			
				$row = $adb->fetchByAssoc($sqlresult, -1, false);
				if (isset($row['id']) && $row['id'] != -1) {
					$this->column_fields["assigned_user_id"] = $row['id'];
				} else {
					$this->column_fields["assigned_user_id"] = $current_user->id;
				}
			}
		}
	}
	
	/** 
	 * Function which will give the basic query to find duplicates
	 */
	function getDuplicatesQuery($module,$table_cols,$field_values,$ui_type_arr,$select_cols='') {
		$select_clause = "SELECT ". $this->table_name .".".$this->table_index ." AS recordid, vtiger_users_last_import.deleted,".$table_cols;

		// Select Custom Field Table Columns if present
		if(isset($this->customFieldTable)) $query .= ", " . $this->customFieldTable[0] . ".* ";

		$from_clause = " FROM $this->table_name";

		$from_clause .= "	INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = $this->table_name.$this->table_index";

		// Consider custom table join as well.
		if(isset($this->customFieldTable)) {
			$from_clause .= " INNER JOIN ".$this->customFieldTable[0]." ON ".$this->customFieldTable[0].'.'.$this->customFieldTable[1] .
				      " = $this->table_name.$this->table_index"; 
		}
		$from_clause .= " LEFT JOIN vtiger_users ON vtiger_users.id = vtiger_crmentity.smownerid
						LEFT JOIN vtiger_groups ON vtiger_groups.groupid = vtiger_crmentity.smownerid";
		
		$where_clause = "	WHERE vtiger_crmentity.deleted = 0";
		$where_clause .= $this->getListViewSecurityParameter($module);
					
		if (isset($select_cols) && trim($select_cols) != '') {
			$sub_query = "SELECT $select_cols FROM  $this->table_name AS t " .
				" INNER JOIN vtiger_crmentity AS crm ON crm.crmid = t.".$this->table_index;
			// Consider custom table join as well.
			if(isset($this->customFieldTable)) {
				$sub_query .= " LEFT JOIN ".$this->customFieldTable[0]." tcf ON tcf.".$this->customFieldTable[1]." = t.$this->table_index";
			}
			$sub_query .= " WHERE crm.deleted=0 GROUP BY $select_cols HAVING COUNT(*)>1";	
		} else {
			$sub_query = "SELECT $table_cols $from_clause $where_clause GROUP BY $table_cols HAVING COUNT(*)>1";
		}	
		
		
		$query = $select_clause . $from_clause .
					" LEFT JOIN vtiger_users_last_import ON vtiger_users_last_import.bean_id=" . $this->table_name .".".$this->table_index .
					" INNER JOIN (" . $sub_query . ") AS temp ON ".get_on_clause($field_values,$ui_type_arr,$module) .
					$where_clause .
					" ORDER BY $table_cols,". $this->table_name .".".$this->table_index ." ASC";
					
		return $query;		
	}

	/**
	 * Invoked when special actions are performed on the module.
	 * @param String Module name
	 * @param String Event Type (module.postinstall, module.disabled, module.enabled, module.preuninstall)
	 */
	function vtlib_handler($modulename, $event_type) {
		if($event_type == 'module.postinstall') {
			// TODO Handle post installation actions
		} else if($event_type == 'module.disabled') {
			// TODO Handle actions when this module is disabled.
		} else if($event_type == 'module.enabled') {
			// TODO Handle actions when this module is enabled.
		} else if($event_type == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($event_type == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($event_type == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
	}

	/** 
	 * Handle saving related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	// function save_related_module($module, $crmid, $with_module, $with_crmid) { }
	
	/**
	 * Handle deleting related module information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function delete_related_module($module, $crmid, $with_module, $with_crmid) { }

	/**
	 * Handle getting related list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_related_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	/**
	 * Handle getting dependents list information.
	 * NOTE: This function has been added to CRMEntity (base class).
	 * You can override the behavior by re-defining it here.
	 */
	//function get_dependents_list($id, $cur_tab_id, $rel_tab_id, $actions=false) { }

	function procesar($productos_ns = "", $dias_subarrendamiento = false)
	{
		// Si se está corriendo un apartado de folios no procesa.
		//return;
		session_start();
		if ($_SESSION["cor"]["apartar_folios"])
		{
//var_dump("apartando procesar");
//die;
			return;
		}

		// Bloquea automáticamente el documento.
		$this->bloquear("recepciones_mercancia");
/**********************************
//die("proc");
echo "<pre>";
var_dump($productos_ns);
die;
**********************************/

		if ($dias_subarrendamiento)
		{
			$equipos = $productos_ns;
			return $this->dias_subarrendamiento($equipos);
		}

		// La sesión se abre no aquí sino en el programa que manda llamar esta función. De esto depende poder cargar el usuario actual.

		global $current_user, $adb;

        	// Carga definiciones de campos personalizados.
        	require("campos_personalizados.php");

        	$id_recepcion = (int)$this->column_fields["record_id"];
		$rm_id = $id_recepcion;
        	$folio_recepcion = $this->column_fields["folio"];

		// Obtiene la sucursal.
        	$sucursal = new Sucursales;
        	$sucursal->retrieve_entity_info((int)$this->column_fields["sucursal"], "Sucursales");

		// Hace los ajustes correspondientes a los registros de números de serie.
                // Obtiene productos y cantidades.
//echo "<pre>";
//var_dump($productos_ns);

		$iteraciones = 30;
		if ($this->column_fields["subarrendado"])
		{
			$iteraciones = 1;
		}

		// Hace un barrido de la tabla 2 (rmd).
		$consulta = "select rmd.* from vtiger_recepciones_mercancia_det rmd, vtiger_crmentity e where e.crmid = rmd.recepciones_mercancia_detid and e.deleted = '0' and rmd.recepciones_mercanciaid = '$rm_id'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
//$renglon = $adb->fetch_array($resultado);

		$i = 1;
		while ($renglon = $adb->fetch_array($resultado))
		{
			if ($i > $iteraciones)
			{
				continue;
			}
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
			$rmd_id = $renglon["recepciones_mercancia_detid"];
			$rmd_producto = $renglon["productid"];
			$rmd_cantidad = $renglon["cantidad"];
			$rmd_costo = $renglon["costo"];
/************************
	$rmd_folio = $renglon["folio"];
	$rmd_recepcion_mercancia = $renglon["recepcion_mercancia"];
************************/

			$producto = $rmd_producto;
			$prod_id = $producto;
			$ns_capturados = $productos_ns[$producto];

			// Obtiene el producto.
			$producto_actual = new Products;
//var_dump($producto);
			$producto_actual->retrieve_entity_info($producto, "Products");
//var_dump($producto);

                       	// Obtiene la línea del producto.
			if ($producto_actual->column_fields[$campos_personalizados["products"]["linea"]] != "")
			{
                       		$linea_actual = new Lineas;
				$linea_actual->retrieve_entity_info($producto_actual->column_fields[$campos_personalizados["products"]["linea"]], "Lineas");
			}
			else
			{
				die("<h1>ERROR</h1>El producto ".$producto_actual->column_fields["productname"]." no tiene línea.");
			}

                       	// Establece almacén a afectar y código de artículo según la familia de producto.
			$codigo_articulo = $producto_actual->column_fields["productcode"];

			if ($linea_actual->column_fields["familia"] != "")
			{
				$familia_actual = new Familias;
				$familia_actual->retrieve_entity_info($linea_actual->column_fields["familia"], "Familias");
				$id_almacen_afectar = $familia_actual->obtener_almacen((int)$this->column_fields["sucursal"]);
			}
			else
			{
				die("<h1>ERROR</h1>La línea ".$linea_actual->column_fields["nombre"]." no tiene familia.");
			}

			// Si es subarrendado, agrega el prefijo "6".
			if ($this->column_fields["subarrendado"])
			{
				$codigo_articulo = "6$codigo_articulo";
			}

			// Crea o actualiza, según sea el caso, el registro de kardex de nuevos.

			// 20140305
			// Registra en kardex y existencias.

			unset($parametros);
			$parametros["sucursal"] = $this->column_fields["sucursal"];
			$parametros["almacen"] = $id_almacen_afectar;
			$parametros["tipo_documento"] = "Recepción de mercancía";
			$parametros["folio"] = $this->column_fields["folio"];
			$parametros["fecha"] = $this->column_fields["fecha_efectiva"];
			//$parametros["producto"] = $this->column_fields["producto$i"];
			$parametros["producto"] = $rmd_producto;
			$parametros["codigo_articulo"] = $codigo_articulo;
			$parametros["entradas"] = $rmd_cantidad;
			$parametros["salidas"] = 0;
			$this->kardex($parametros);
			// 20140305

			// Si es subarrendado crea un alta a flota automática.
			if ($this->column_fields["subarrendado"])
			{
				// Primero verifica si ya existe un alta a flota relacionada.
				$consulta2 = "select afr.* from vtiger_altas_flota_renta afr, vtiger_crmentity e where e.crmid = afr.altas_flota_rentaid and e.deleted = '0' and afr.recepciones_mercanciaid = '$id_recepcion'";
				$resultado2 = $adb->query($consulta2);
				$renglon2 = $adb->fetch_array($resultado2);
				$id_alta = $renglon2["altas_flota_rentaid"];
//die(var_dump($id_alta));
				$alta = new Altas_flota_renta;
				if ($id_alta != "")
				{
//echo "dentro";
                                       	$alta->retrieve_entity_info($id_alta, "Altas_flota_renta");
                               	}
//echo "<pre>";
//var_dump($id_recepcion);
				//$alta->column_fields["assigned_user_id"] = $current_user->id;
				$alta->column_fields["assigned_user_id"] = $_SESSION["authenticated_user_id"];
				$alta->column_fields["sucursal"] = $this->column_fields["sucursal"];
				$alta->column_fields["subarrendado"] = $this->column_fields["subarrendado"];
				$alta->column_fields["producto"] = $producto_actual->column_fields["record_id"];
				$alta->column_fields["cantidad"] = $rmd_cantidad;
               			$alta->column_fields["fecha_efectiva"] = $this->column_fields["fecha_efectiva"];
               			$alta->column_fields["recepcion_mercancia"] = $id_recepcion;
               			$alta->save("Altas_flota_renta", $id_alta);
//die(var_dump($alta->column_fields));
/**********************************************
echo "<pre>";
var_dump($id_alta);
var_dump($alta->column_fields);
***********************************************/
				if ($alta->column_fields["folio"] == "")
				{
					$alta->asignar_folio();
				}
                       	}

			// Recorre los elementos (números de serie) de este producto.
			//if (!is_null($ns_capturados))
			if (is_array($ns_capturados))
			{
				$costo_rmd = 0;
				//for ($j = 1; $j <= $this->column_fields["cantidad$i"]; $j++)
				for ($j = 1; $j <= $rmd_cantidad; $j++)
				{
					$ns_capturado = each($ns_capturados);
					$ns = $ns_capturado["value"];

					// Busca un posible registro existente.
					$consulta2 = "select ns.numeros_serieid, ns.estado from vtiger_numeros_serie ns, vtiger_crmentity e where e.crmid = ns.numeros_serieid and e.deleted = '0' and ns.consecutivo_producto = '$j' and ns.productid = '$producto' and ns.recepciones_mercanciaid = '$id_recepcion'";
					$resultado2 = $adb->query($consulta2);
					$renglon2 = $adb->fetch_array($resultado2);

					$ns_actual = new Numeros_serie;
					if ($renglon2["numeros_serieid"] != "")
					{
						$ns_actual->retrieve_entity_info($renglon2["numeros_serieid"], "Numeros_serie");
					}
					if ($renglon2["estado"] == "")
					{
						$ns_actual->column_fields["estado"] = "Nuevo";
					}
					//$ns_actual->column_fields["assigned_user_id"] = $current_user->id;
					$ns_actual->column_fields["assigned_user_id"] = $ns["asignado"];
					$ns_actual->column_fields["consecutivo_producto"] = $j;
					$ns_actual->column_fields["producto"] = $producto;
					$ns_actual->column_fields["numero_serie"] = $ns["ns"];
					$ns_actual->column_fields["numero_interno_proveedor"] = $ns["numero_interno_proveedor"];
					$ns_actual->column_fields["motor"] = $ns["motor"];
					$ns_actual->column_fields["costo"] = $ns["costo"];
					$ns_actual->column_fields["moneda"] = $this->column_fields["moneda"];
					$ns_actual->column_fields["recepcion_mercancia"] = $id_recepcion;
					$ns_actual->save("Numeros_serie", $renglon2["numeros_serieid"]);

					// Acumula el costo para actualizar el registro de detalle de recepción correspondiente.
					$costo_rmd += $ns["costo"];

//var_dump($ns_actual->id);
//var_dump($ns_actual->column_fields["record_id"]);
					// Agrega el id del registro de número de serie a un arreglo.
					$ns_recepcion[$ns_actual->id] = "on";
					//$ns_recepcion[$ns_actual->column_fields["record_id"]] = "on";
				}
				// Actualiza el costo del registro de detalle.
				if ($costo_rmd > 0)
				{
					$consulta = "update vtiger_recepciones_mercancia_det rmd, vtiger_crmentity e set rmd.costo = '$costo_rmd' where rmd.recepciones_mercanciaid = '$rm_id' and producto = '$prod_id'";
					$adb->query($consulta);
				}

				// Elimina los números de serie extra que pudieran existir de una captura previa. Esto ocurre cuando se decrementó la cantidad de elementos del producto.
				$consulta = "update vtiger_numeros_serie ns, vtiger_crmentity e set e.deleted = '1' where e.crmid = ns.numeros_serieid and cast(ns.consecutivo_producto as signed) >= '$j' and ns.productid = '$producto' and ns.recepciones_mercanciaid = '$id_recepcion'";
				$adb->query($consulta);
			}

			// Si es subarrendado manda procesar el alta a flota automática.
			if ($this->column_fields["subarrendado"])
			{
//die(var_dump($ns_recepcion));
				$alta->procesar($ns_recepcion);
			}

			$i++;
		}


// Código para tabla 1.
/*********************************************************************************
                //for ($i = 1; $i <= 30; $i++)
                for ($i = 1; $i <= $iteraciones; $i++)
                {
//echo $i;
                        if ($this->column_fields["producto$i"])
                        {
				$producto = $this->column_fields["producto$i"];
				$prod_id = $producto;
				$ns_capturados = $productos_ns[$producto];

				// Obtiene el producto.
				$producto_actual = new Products;
//var_dump($producto);
				$producto_actual->retrieve_entity_info($producto, "Products");
//var_dump($producto);

                        	// Obtiene la línea del producto.
				if ($producto_actual->column_fields[$campos_personalizados["products"]["linea"]] != "")
				{
                        		$linea_actual = new Lineas;
                       			$linea_actual->retrieve_entity_info($producto_actual->column_fields[$campos_personalizados["products"]["linea"]], "Lineas");
				}
				else
				{
					die("<h1>ERROR</h1>El producto ".$producto_actual->column_fields["productname"]." no tiene línea.");
				}

                        	// Establece almacén a afectar y código de artículo según la familia de producto.
				$codigo_articulo = $producto_actual->column_fields["productcode"];

                                if ($linea_actual->column_fields["familia"] != "")
                                {
                                        $familia_actual = new Familias;
                                        $familia_actual->retrieve_entity_info($linea_actual->column_fields["familia"], "Familias");
					$id_almacen_afectar = $familia_actual->obtener_almacen((int)$this->column_fields["sucursal"]);
                                }
                                else
                                {
                                        die("<h1>ERROR</h1>La línea ".$linea_actual->column_fields["nombre"]." no tiene familia.");
                                }


                        	// Si es subarrendado, agrega el prefijo "6".
                        	if ($this->column_fields["subarrendado"])
                        	{
                                	$codigo_articulo = "6$codigo_articulo";
                        	}

                		// Crea o actualiza, según sea el caso, el registro de kardex de nuevos.




				// 20140305
				// Registra en kardex y existencias.

				unset($parametros);
				$parametros["sucursal"] = $this->column_fields["sucursal"];
				$parametros["almacen"] = $id_almacen_afectar;
				$parametros["tipo_documento"] = "Recepción de mercancía";
				$parametros["folio"] = $this->column_fields["folio"];
				$parametros["fecha"] = $this->column_fields["fecha_efectiva"];
				$parametros["producto"] = $this->column_fields["producto$i"];
				$parametros["codigo_articulo"] = $codigo_articulo;
				$parametros["entradas"] = $this->column_fields["cantidad$i"];
				$parametros["salidas"] = 0;
				$this->kardex($parametros);
				// 20140305





				// Si es subarrendado crea un alta a flota automática.
                        	if ($this->column_fields["subarrendado"])
                        	{
					// Primero verifica si ya existe un alta a flota relacionada.
					$consulta = "select afr.* from vtiger_altas_flota_renta afr, vtiger_crmentity e where e.crmid = afr.altas_flota_rentaid and e.deleted = '0' and afr.recepciones_mercanciaid = '$id_recepcion'";
                                	$resultado = $adb->query($consulta);
                                	$renglon = $adb->fetch_array($resultado);
					$id_alta = $renglon["altas_flota_rentaid"];
//die(var_dump($id_alta));
					$alta = new Altas_flota_renta;
                                	if ($id_alta != "")
                                	{
//echo "dentro";
                                        	$alta->retrieve_entity_info($id_alta, "Altas_flota_renta");
                                	}
//echo "<pre>";
//var_dump($id_recepcion);
					//$alta->column_fields["assigned_user_id"] = $current_user->id;
					$alta->column_fields["assigned_user_id"] = $_SESSION["authenticated_user_id"];
					$alta->column_fields["sucursal"] = $this->column_fields["sucursal"];
					$alta->column_fields["subarrendado"] = $this->column_fields["subarrendado"];
					$alta->column_fields["producto"] = $producto_actual->column_fields["record_id"];
					$alta->column_fields["cantidad"] = $this->column_fields["cantidad$i"];
                			$alta->column_fields["fecha_efectiva"] = $this->column_fields["fecha_efectiva"];
                			$alta->column_fields["recepcion_mercancia"] = $id_recepcion;
                			$alta->save("Altas_flota_renta", $id_alta);
//die(var_dump($alta->column_fields));
===**********************************************
echo "<pre>";
var_dump($id_alta);
var_dump($alta->column_fields);
===***********************************************
					if ($alta->column_fields["folio"] == "")
					{
						$alta->asignar_folio();
					}
                        	}


				// Recorre los elementos (números de serie) de este producto.
				//if (!is_null($ns_capturados))
				if (is_array($ns_capturados))
				{
					$costo_rmd = 0;
					for ($j = 1; $j <= $this->column_fields["cantidad$i"]; $j++)
					{
						$ns_capturado = each($ns_capturados);
						$ns = $ns_capturado["value"];

						// Busca un posible registro existente.
						$consulta = "select ns.numeros_serieid, ns.estado from vtiger_numeros_serie ns, vtiger_crmentity e where e.crmid = ns.numeros_serieid and e.deleted = '0' and ns.consecutivo_producto = '$j' and ns.productid = '$producto' and ns.recepciones_mercanciaid = '$id_recepcion'";
						$resultado = $adb->query($consulta);
						$renglon = $adb->fetch_array($resultado);

						$ns_actual = new Numeros_serie;
						if ($renglon["numeros_serieid"] != "")
						{
							$ns_actual->retrieve_entity_info($renglon["numeros_serieid"], "Numeros_serie");
						}
						if ($renglon["estado"] == "")
						{
							$ns_actual->column_fields["estado"] = "Nuevo";
						}
						//$ns_actual->column_fields["assigned_user_id"] = $current_user->id;
						$ns_actual->column_fields["assigned_user_id"] = $ns["asignado"];
						$ns_actual->column_fields["consecutivo_producto"] = $j;
						$ns_actual->column_fields["producto"] = $producto;
						$ns_actual->column_fields["numero_serie"] = $ns["ns"];
						$ns_actual->column_fields["numero_interno_proveedor"] = $ns["numero_interno_proveedor"];
						$ns_actual->column_fields["motor"] = $ns["motor"];
						$ns_actual->column_fields["costo"] = $ns["costo"];
						$ns_actual->column_fields["moneda"] = $this->column_fields["moneda"];
						$ns_actual->column_fields["recepcion_mercancia"] = $id_recepcion;
						$ns_actual->save("Numeros_serie", $renglon["numeros_serieid"]);

						// Acumula el costo para actualizar el registro de detalle de recepción correspondiente.
						$costo_rmd += $ns["costo"];

//var_dump($ns_actual->id);
//var_dump($ns_actual->column_fields["record_id"]);
						// Agrega el id del registro de número de serie a un arreglo.
						$ns_recepcion[$ns_actual->id] = "on";
						//$ns_recepcion[$ns_actual->column_fields["record_id"]] = "on";
					}
					// Actualiza el costo del registro de detalle.
					if ($costo_rmd > 0)
					{
						$consulta = "update vtiger_recepciones_mercancia_det rmd, vtiger_crmentity e set rmd.costo = '$costo_rmd' where rmd.recepciones_mercanciaid = '$rm_id' and producto = '$prod_id'";
						$adb->query($consulta);
					}

					// Elimina los números de serie extra que pudieran existir de una captura previa. Esto ocurre cuando se decrementó la cantidad de elementos del producto.
					$consulta = "update vtiger_numeros_serie ns, vtiger_crmentity e set e.deleted = '1' where e.crmid = ns.numeros_serieid and cast(ns.consecutivo_producto as signed) >= '$j' and ns.productid = '$producto' and ns.recepciones_mercanciaid = '$id_recepcion'";
					$adb->query($consulta);
				}

				// Si es subarrendado manda procesar el alta a flota automática.
                       		if ($this->column_fields["subarrendado"])
                       		{
//die(var_dump($ns_recepcion));
					$alta->procesar($ns_recepcion);
				}
                        }
                }
****************************************************************************/
//die;
	}

	function dias_subarrendamiento($equipos)
	{
/*******************************
echo "<pre>";
var_dump($equipos);
die;
echo "</pre>";
********************************/
		// La sesión se abre no aquí sino en el programa que manda llamar esta función. De esto depende poder cargar el usuario actual.

		global $current_user, $adb;

                $id_recepcion = (int)$this->column_fields["record_id"];
                $folio_recepcion = $this->column_fields["folio"];

                // Obtiene la sucursal.
                $sucursal = new Sucursales;
                $sucursal->retrieve_entity_info((int)$this->column_fields["sucursal"], "Sucursales");

		// Hace un barrido de los equipos capturados.
		foreach ($equipos as $equipo)
		{
			// Verifica si ya existe un registro previamente guardado.
			$numero_interno = $equipo["numero_interno"];
			$consecutivo = $equipo["consecutivo"];
			//$consulta = "select ds.*, e.smownerid, flr.flota_rentaid, ns.numero_interno_proveedor from vtiger_dias_subarrendamiento ds, vtiger_crmentity e, vtiger_flota_renta flr, vtiger_crmentity e2, vtiger_numeros_serie ns where e.crmid = ds.dias_subarrendamientoid and e.deleted = '0' and ds.recepciones_mercanciaid = '$id_recepcion' and ds.consecutivo = '$consecutivo' and e2.crmid = flr.flota_rentaid and e2.deleted = '0' and flr.numero_interno = '$numero_interno' and ns.numeros_serieid = flr.numeros_serieid order by cast(consecutivo as signed)";
			$consulta = "select ds.*, ns.numero_interno_proveedor from vtiger_dias_subarrendamiento ds, vtiger_crmentity e, vtiger_numeros_serie ns, vtiger_crmentity e2 where e.crmid = ds.dias_subarrendamientoid and e.deleted = '0' and ds.recepciones_mercanciaid = '$id_recepcion' and ds.consecutivo = '$consecutivo' and e2.crmid = ns.numeros_serieid and e2.deleted = '0' and ns.numeros_serieid = '".$equipo["numeros_serieid"]."' order by cast(consecutivo as signed)";
//var_dump($consulta);
//die;
			$resultado = $adb->query($consulta);
			$renglon = $adb->fetch_array($resultado);

			$diassub = new Dias_subarrendamiento;
			if ($renglon["numeros_serieid"] != "")
			{
				$diassub->retrieve_entity_info($renglon["dias_subarrendamientoid"], "Dias_subarrendamiento");
			}

			$diassub->column_fields["assigned_user_id"] = $equipo["asignado"];
			//$diassub->column_fields["equipo"] = $renglon["flota_rentaid"];
			$diassub->column_fields["equipo"] = $equipo["flota_rentaid"];
			$diassub->column_fields["numero_interno_proveedor"] = $renglon["numero_interno_proveedor"];
			$diassub->column_fields["fecha_inicial"] = $equipo["fecha_inicial"];
			$diassub->column_fields["fecha_final"] = $equipo["fecha_final"];
			$diassub->column_fields["dias"] = $equipo["dias"];
			$diassub->column_fields["precio"] = $equipo["precio"];
			$diassub->column_fields["consecutivo"] = $equipo["consecutivo"];
			$diassub->column_fields["recepcion_mercancia"] = $id_recepcion;
			$diassub->save("Dias_subarrendamiento", $renglon["dias_subarrendamientoid"]);
		}
		/*********************
		echo "<pre>";
		var_dump($equipos);
		die;
		********************/
	}

	function reconstruir()
	{
		// La sesión se abre no aquí sino en el programa que manda llamar esta función. De esto depende poder cargar el usuario actual.

		global $current_user, $adb;

        	$id_recepcion = (int)$this->column_fields["record_id"];
        	$folio_recepcion = $this->column_fields["folio"];

		// Formula "la pregunta". Dependiendo de las condiciones genera los parámetros correspondientes para mandar procesar.

		// Mercancía propia.
		if ($this->column_fields["tipo_recepcion"] == "Equipos" && !$this->column_fields["subarrendado"] && !$this->column_fields["dias_subarrendamiento"])
		{
        		//echo "document.location = 'index.php?module=Recepciones_mercancia&action=registrar_ns&record=$id'";
			echo "Mercancía propia";
			echo "<br>";

			// Revisa si ya hay números de serie registrados para esta recepción.
			$consulta = "select ns.*, e.smownerid from vtiger_numeros_serie ns, vtiger_crmentity e where e.crmid = ns.numeros_serieid and e.deleted = '0' and ns.recepciones_mercanciaid = '$id_recepcion' order by ns.productid, cast(ns.consecutivo_producto as signed)";
			//var_dump($consulta);
			$resultado = $adb->query($consulta);
			//var_dump($resultado);
			while ($renglon = $adb->fetch_array($resultado))
			{
        			$ns[$renglon["productid"]][$renglon["consecutivo_producto"]]["ns"] = $renglon["numero_serie"];
        			$ns[$renglon["productid"]][$renglon["consecutivo_producto"]]["motor"] = $renglon["motor"];
        			$ns[$renglon["productid"]][$renglon["consecutivo_producto"]]["costo"] = $renglon["costo"];
        			$ns[$renglon["productid"]][$renglon["consecutivo_producto"]]["asignado"] = $renglon["smownerid"];
        			$ns[$renglon["productid"]][$renglon["consecutivo_producto"]]["numero_interno_proveedor"] = $renglon["numero_interno_proveedor"];
			}

			if (is_null($ns))
			{
				//echo "Esta recepción de mercancía no tiene números de serie capturados por lo que no puede ser reconstruida.";
				echo "Esta recepción de mercancía no tiene números de serie capturados.";
				echo "<br>";
			}
/**************************************************************
			else
			{
				$this->procesar($ns);
			}
**************************************************************/
			$this->procesar($ns);
		}

		// Mercancía subarrendada.
		if ($this->column_fields["tipo_recepcion"] == "Subarrendamiento" && $this->column_fields["subarrendado"] && !$this->column_fields["dias_subarrendamiento"])
		{
        		//echo "document.location = 'index.php?module=Recepciones_mercancia&action=registrar_ns&record=$id'";
			echo "Mercancía subarrendada";
			echo "<br>";

                        // Revisa si ya hay números de serie registrados para esta recepción.
                        $consulta = "select ns.*, e.smownerid from vtiger_numeros_serie ns, vtiger_crmentity e where e.crmid = ns.numeros_serieid and e.deleted = '0' and ns.recepciones_mercanciaid = '$id_recepcion' order by ns.productid, cast(ns.consecutivo_producto as signed)";
                        //var_dump($consulta);
                        $resultado = $adb->query($consulta);
                        //var_dump($resultado);
                        while ($renglon = $adb->fetch_array($resultado))
                        {
                                $ns[$renglon["productid"]][$renglon["consecutivo_producto"]]["ns"] = $renglon["numero_serie"];
                                $ns[$renglon["productid"]][$renglon["consecutivo_producto"]]["motor"] = $renglon["motor"];
                                $ns[$renglon["productid"]][$renglon["consecutivo_producto"]]["costo"] = $renglon["costo"];
                                $ns[$renglon["productid"]][$renglon["consecutivo_producto"]]["asignado"] = $renglon["smownerid"];
                                $ns[$renglon["productid"]][$renglon["consecutivo_producto"]]["numero_interno_proveedor"] = $renglon["numero_interno_proveedor"];
                        }

			$prod1_individual = false;
			if ($this->column_fields["producto1"] != "")
			{
				$prod1 = new Products;
				$prod1->retrieve_entity_info($this->column_fields["producto1"], "Products");
				$prod1_individual = $prod1->individual();
			}

                        if (is_null($ns) && $prod1_individual)
                        {
                                echo "Esta recepción de mercancía no tiene números de serie capturados por lo que no puede ser reconstruida.";
                                echo "<br>";
                        }
                        else
                        {
                                $this->procesar($ns);
                        }
		}

		// Días de subarrendamiento.
		if ($this->column_fields["tipo_recepcion"] == "Subarrendamiento" && !$this->column_fields["subarrendado"] && $this->column_fields["dias_subarrendamiento"])
		{
        		//echo "document.location = 'index.php?module=Recepciones_mercancia&action=registrar_dias_subarrendamiento&record=$id'";
			echo "Días de subarrendamiento";
			echo "<br>";

			// Revisa si ya hay días de subarrendamiento registrados para esta recepción.
			$consulta = "select ds.*, flr.numero_interno, e.smownerid from vtiger_dias_subarrendamiento ds, vtiger_crmentity e, vtiger_flota_renta flr where e.crmid = ds.dias_subarrendamientoid and e.deleted = '0' and ds.recepciones_mercanciaid = '$id_recepcion' and flr.flota_rentaid = ds.flota_rentaid order by cast(ds.consecutivo as signed)";
			//var_dump($consulta);
			$resultado = $adb->query($consulta);
			while ($renglon = $adb->fetch_array($resultado))
			{
        			$ds_ya_registrado[$renglon["consecutivo"]]["numero_interno_proveedor"] = $renglon["numero_interno_proveedor"];
        			$ds_ya_registrado[$renglon["consecutivo"]]["numero_interno"] = $renglon["numero_interno"];
        			$ds_ya_registrado[$renglon["consecutivo"]]["fecha_inicial"] = $renglon["fecha_inicial"];
        			$ds_ya_registrado[$renglon["consecutivo"]]["fecha_final"] = $renglon["fecha_final"];
        			$ds_ya_registrado[$renglon["consecutivo"]]["precio"] = $renglon["precio"];
        			$ds_ya_registrado[$renglon["consecutivo"]]["dias"] = $renglon["dias"];
        			$ds_ya_registrado[$renglon["consecutivo"]]["asignado"] = $renglon["asignado"];
			}

                        if (is_null($ds_ya_registrado))
                        {
                                echo "Esta recepción de mercancía no tiene días de subarrendamiento capturados por lo que no puede ser reconstruida.";
                                echo "<br>";
                        }
                        else
                        {
                                $this->procesar($ns);
                        }
		}



	}

	function obtener_costo()
	{
		// Obtiene el costo total de la recepción.

		global $adb;

        	$id_recepcion = (int)$this->column_fields["record_id"];

		// Costo registrado en números de serie.
		$consulta = "select sum(costo) as costo_ns from vtiger_numeros_serie ns, vtiger_crmentity e where e.crmid = ns.numeros_serieid and e.deleted = '0' and ns.recepciones_mercanciaid = '$id_recepcion'";
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);

		$costo_ns = $renglon["costo_ns"];

		// Costo registrado en días de subarrendamiento.
		$consulta = "select sum(dias * precio) as costo_ds from vtiger_dias_subarrendamiento ds, vtiger_crmentity e where e.crmid = ds.dias_subarrendamientoid and e.deleted = '0' and ds.recepciones_mercanciaid = '$id_recepcion'";
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);

		$costo_ds = $renglon["costo_ds"];

		// Costo registrado en cada producto.
		$costo_productos = 0;
		for ($i = 1; $i <= 30; $i++)
		{
        		$costo_productos += ($this->column_fields["cantidad$i"] * $this->column_fields["costo$i"]);
		}

		$costo_total = number_format(($costo_ns + $costo_ds + $costo_productos), 2);

		return $costo_total;
	}

	function detectar_anomalias()
	{
		// Intenta detectar anomalías y, en caso de encontrar, las registra en el documento de operación.

		global $adb;

        	$id_recepcion = (int)$this->column_fields["record_id"];

		// Anomalía buscada: inconsistencia en cantidad vs números de serie registrados.
		$consulta = "select count(*) as cantidad from vtiger_numeros_serie ns, vtiger_crmentity e where e.crmid = ns.numeros_serieid and e.deleted = '0' and ns.recepciones_mercancia = '$id_recepcion'";
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);
//echo "<pre>";
//var_dump($consulta);
//var_dump($renglon);
//var_dump($this->column_fields);
		// Obtiene la cantidad de artículos recibidos.
		$cantidad = 0;
		for ($i = 1; $i <= 30; $i++)
		{
			$cantidad += $this->column_fields["cantidad$i"];
		}
//var_dump($cantidad);
//die;

		if ($cantidad != $renglon["cantidad"])
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	// Graba detalle de renta a partir de la información recabada con la "pregunta".
	function registrar_productos($captura)
	{
		global $adb;

		// Limpia detalles de cualquier captura previa.
		$this->limpiar_detalles();

		$rm_id = $this->obtener_id();

/********************
		echo "<pre>";
		var_dump($captura);
		echo "</pre>";
die;
*******************/
		$iteraciones = 30;

		for ($i = 1; $i <= $iteraciones; $i++)
		{
			// Graba en la estructura antigua.
			$consulta = "update vtiger_recepciones_mercancia set productid{$i} = '".$captura[$i]["prod_id"]."', cantidad{$i} = '".$captura[$i]["cantidad"]."', costo{$i} = '".$captura[$i]["costo"]."' where recepciones_mercanciaid = '".$this->obtener_id()."'";
//var_dump($consulta);
			$adb->query($consulta);

			// Graba en la estructura nueva.

			// Sólo registra si hay información.
			if ($captura[$i]["prod_id"] == "")
			{
				continue;
			}

			$prod_id = $captura[$i]["prod_id"];
			$cantidad = $captura[$i]["cantidad"];
			$costo = $captura[$i]["costo"];

			// Registra detalle.

			$rmd = new Recepciones_mercancia_det;
			$rmd->column_fields["assigned_user_id"] = 1;
			$rmd->column_fields["recepcion_mercancia"] = $rm_id;
			$rmd->column_fields["producto"] = $prod_id;
			$rmd->column_fields["cantidad"] = $cantidad;
			$rmd->column_fields["costo"] = $costo;
			$rmd->save("Recepciones_mercancia_det");
		}
	}

	// Limpia detalle de cualquier captura previa.
	function limpiar_detalles()
	{
		global $adb;

		$consulta = "update vtiger_recepciones_mercancia_det rmd, vtiger_crmentity e set e.deleted = '1' where e.crmid = rmd.recepciones_mercancia_detid and rmd.recepciones_mercanciaid = '".$this->obtener_id()."'";
		$adb->query($consulta);
	}

	function concatenar_codigos()
	{
		global $adb;

		$rm_id = $this->obtener_id();

		// Hace un barrido de la tabla 2 (rmd).
		$consulta = "select rmd.*, prod.productcode from vtiger_recepciones_mercancia_det rmd, vtiger_crmentity e, vtiger_products prod where e.crmid = rmd.recepciones_mercancia_detid and e.deleted = '0' and rmd.recepciones_mercanciaid = '$rm_id' and prod.productid = rmd.productid";
//var_dump($consulta);
//die;
		$resultado = $adb->query($consulta);
//$renglon = $adb->fetch_array($resultado);

		while ($renglon = $adb->fetch_array($resultado))
		{
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
			$rmd_id = $renglon["recepciones_mercancia_detid"];
			$rmd_producto = $renglon["productid"];
			$rmd_cantidad = $renglon["cantidad"];
			$rmd_costo = $renglon["costo"];
			$prod_productcode = $renglon["productcode"];
/************************
	$rmd_folio = $renglon["folio"];
	$rmd_recepcion_mercancia = $renglon["recepcion_mercancia"];
************************/
			$codigos[] = $prod_productcode.":".$rmd_cantidad;
		}

// Se elimina código de tabla 1.
/*************************************************************
		for ($i = 1; $i <= 30; $i++)
		{
			if ($this->column_fields["producto{$i}"] != "")
			{
				$prod = new Products;
				$prod->retrieve_entity_info($this->column_fields["producto{$i}"], "Products");
				$codigos[] = $prod->column_fields["productcode"].":".$this->column_fields["cantidad{$i}"];
			}
		}
***********************************************/

		if (is_array($codigos))
		{
			$rm_codigos = implode(" ", $codigos);
		}

		//$consulta = "update vtiger_recepciones_mercancia set codigos = '$rm_codigos' where recepciones_mercanciaid = '".$this->obtener_id()."'";
		$consulta = "update vtiger_recepciones_mercancia set codigos = '$rm_codigos' where recepciones_mercanciaid = '$rm_id'";
		$adb->query($consulta);
//var_dump($consulta);
//die;
	}

	// Genera tabla de detalles.
	function tabla_detalles()
	{
		$rm_id = $this->obtener_id();

		global $adb;

		// Calcula costos registrados en números de serie.
		$consulta = "select ns.productid, sum(costo) as costo_ns from vtiger_numeros_serie ns, vtiger_crmentity e where e.crmid = ns.numeros_serieid and e.deleted = '0' and ns.recepciones_mercanciaid = '$rm_id' group by ns.productid";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		//$renglon = $adb->fetch_array($resultado);
		while ($renglon = $adb->fetch_array($resultado))
		{
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
			$prod_id = $renglon["productid"];
			$costo_ns = $renglon["costo_ns"];

			$costos_ns[$prod_id] = $costo_ns;
		}


		// Costo registrado en días de subarrendamiento.
		$consulta = "select flr.productid, sum(dias * precio) as costo_ds from vtiger_dias_subarrendamiento ds, vtiger_crmentity e, vtiger_flota_renta flr where e.crmid = ds.dias_subarrendamientoid and e.deleted = '0' and ds.recepciones_mercanciaid = '$rm_id' and flr.flota_rentaid = ds.flota_rentaid group by flr.productid";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		//$renglon = $adb->fetch_array($resultado);

		while ($renglon = $adb->fetch_array($resultado))
		{
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
			$prod_id = $renglon["productid"];
			$costo_ds = $renglon["costo_ds"];

			$costos_ds[$prod_id] = $costo_ds;
		}


		//$tabla = "<table style=\"width:90%;border-collapse:collapse;\">";
		$tabla = "<table style=\"width:100%;\">";

		// Encabezado.
		$tabla .= "<tr>";
		//$tabla .= "<th colspan=\"2\" class=\"dvInnerHeader\">";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Cantidad";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Descripción";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Costo unitario";
		$tabla .= "</th>";
		$tabla .= "<th class=\"dvInnerHeader\">";
		$tabla .= "Costo";
		$tabla .= "</th>";
		$tabla .= "</tr>";

		// Barrido de detalles.
		$consulta = "select prod.productname, rmd.* from vtiger_recepciones_mercancia_det rmd, vtiger_crmentity e, vtiger_products prod where e.crmid = rmd.recepciones_mercancia_detid and e.deleted = '0' and rmd.recepciones_mercanciaid = '".$this->obtener_id()."' and prod.productid = rmd.productid";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		while ($renglon = $adb->fetch_array($resultado))
		{
			$color = ($contador_color % 2)?"#eee":"#fed";

			$tabla .= "<tr>";
			$tabla .= "<td style=\"background:$color;text-align:right;padding:0px 8px;\">";
			$tabla .= $renglon["cantidad"];
			$tabla .= "</td>";
			$tabla .= "<td style=\"background:$color;padding:0px 8px;\">";
			$tabla .= "<a href=\"index.php?module=Products&action=DetailView&record=".$renglon["productid"]."\">";
			$tabla .= $renglon["productname"];
			$tabla .= "</a>";
			$tabla .= "</td>";
			$tabla .= "<td style=\"background:$color;text-align:right;padding:0px 8px;\">";
			//$tabla .= $renglon["costo"];
			if (($costos_ns[$renglon["productid"]] == 0) && ($costos_ds[$renglon["productid"]] == 0))
			{
				$tabla .= number_format($renglon["costo"], 2);
			}
			if ($costos_ds[$renglon["productid"]] > 0)
			{
				$tabla .= number_format(($costos_ds[$renglon["productid"]] / $renglon["cantidad"]), 2);
			}
			$tabla .= "</td>";
			$tabla .= "<td style=\"background:$color;text-align:right;padding:0px 8px;\">";
			if (($costos_ns[$renglon["productid"]] == 0) && ($costos_ds[$renglon["productid"]] == 0))
			{
				$tabla .= number_format($renglon["cantidad"] * $renglon["costo"], 2);
				$costo_total += ($renglon["cantidad"] * $renglon["costo"]);
			}
			if ($costos_ns[$renglon["productid"]] > 0)
			{
				$tabla .= number_format($costos_ns[$renglon["productid"]], 2);
				$costo_total += $costos_ns[$renglon["productid"]];
			}
			if ($costos_ds[$renglon["productid"]] > 0)
			{
				$tabla .= number_format($costos_ds[$renglon["productid"]], 2);
				$costo_total += $costos_ds[$renglon["productid"]];
			}
			$tabla .= "</td>";
			$tabla .= "</tr>";

			$contador_color++;
		}
/***********************************
		$tabla .= "<tr style=\"font-weight:bold;\">";
		$tabla .= "<td style=\"text-align:right;padding:5px 8px;\" colspan=\"3\">";
		$tabla .= "Total";
		$tabla .= "</td>";
		$tabla .= "<td style=\"text-align:right;padding:5px 8px;\">";
		$tabla .= number_format($costo_total, 2);
		$tabla .= "</td>";
		$tabla .= "</tr>";
************************************/
		$subtotal = $costo_total;
		$porcentaje_iva = 16;
		$iva = $subtotal * $porcentaje_iva / 100;
		$total = $subtotal + $iva;

		$tabla .= "<tr>";
		$tabla .= "<td style=\"text-align:right;padding:5px 8px 0px 8px;\" colspan=\"3\">";
		$tabla .= "Subtotal";
		$tabla .= "</td>";
		$tabla .= "<td style=\"text-align:right;padding:5px 8px 0px 8px;\">";
		$tabla .= number_format($subtotal, 2);
		$tabla .= "</td>";
		$tabla .= "</tr>";
		$tabla .= "<tr>";
		$tabla .= "<td style=\"text-align:right;padding:0px 8px;\" colspan=\"3\">";
		$tabla .= "IVA";
		$tabla .= "</td>";
		$tabla .= "<td style=\"text-align:right;padding:0px 8px;\">";
		$tabla .= number_format($iva, 2);
		$tabla .= "</td>";
		$tabla .= "</tr>";
		$tabla .= "<tr style=\"font-weight:bold;\">";
		$tabla .= "<td style=\"text-align:right;padding:5px 8px 0px 8px;\" colspan=\"3\">";
		$tabla .= "Total";
		$tabla .= "</td>";
		$tabla .= "<td style=\"text-align:right;padding:5px 8px 0px 8px;\">";
		$tabla .= number_format($total, 2);
		$tabla .= "</td>";
		$tabla .= "</tr>";

		$tabla .= "</table>";

		return $tabla;
	}

	// Genera la estructura correspondiente usando Remisiones_det a partir de la estructura antigua. 
	function migrar_rmd() 
	{ 
		global $adb; 

		$rm_id = $this->obtener_id(); 

		// Genera la variable de captura.

		$iteraciones = 30;
//var_dump($this->column_fields);
		for ($i = 1; $i <= $iteraciones; $i++)
		{
			$captura[$i]["prod_id"] = $this->column_fields["producto{$i}"];
			$captura[$i]["cantidad"] = $this->column_fields["cantidad{$i}"];
			$captura[$i]["costo"] = $this->column_fields["costo{$i}"];
		}

		// Registra la captura en estructura de Recepeciones_mercancia_det.
		$this->registrar_productos($captura);
		$this->retrieve_entity_info($rm_id, "Recepciones_mercancia");
		$this->concatenar_codigos();
	}

	// Genera una nota de crédito de proveedor para esta recepción o identifica la existente.
	function nota_credito_proveedor()
	{
		global $adb;

		$rm_id = $this->obtener_id();

//echo "NCP";

		// Busca una posible nota existente.
		$consulta = "select ncp.notas_credito_proveedorid from vtiger_notas_credito_proveedor ncp, vtiger_crmentity e where e.crmid = ncp.notas_credito_proveedorid and e.deleted = '0' and ncp.recepciones_mercanciaid = '$rm_id'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
		$ncp_id = $renglon["notas_credito_proveedorid"];

		if ($ncp_id == "")
		{
			$ncp = new Notas_credito_proveedor;

			$ncp->column_fields["assigned_user_id"] = $this->column_fields["assigned_user_id"];
			//$ncp->column_fields["folio"] = $ncp_folio;
			$ncp->column_fields["sucursal"] = $this->column_fields["sucursal"];
			$ncp->column_fields["referencia"] = $this->column_fields["referencia"];
			$ncp->column_fields["proveedor"] = $this->column_fields["proveedor"];
			$ncp->column_fields["ncp_tipo"] = $this->column_fields["tipo_recepcion"];
			$ncp->column_fields["subarrendado"] = $this->column_fields["subarrendado"];
			$ncp->column_fields["dias_subarrendamiento"] = $this->column_fields["dias_subarrendamiento"];
			$ncp->column_fields["factura_proveedor"] = $this->column_fields["factura_proveedor"];
			$ncp->column_fields["remision_proveedor"] = $this->column_fields["remision_proveedor"];
			$ncp->column_fields["fecha_efectiva"] = date("Y-m-d");
			$ncp->column_fields["hora"] = date("H:i:s");
			$ncp->column_fields["moneda"] = $this->column_fields["moneda"];
			$ncp->column_fields["tipo_cambio"] = $this->column_fields["tipo_cambio"];
			$ncp->column_fields["pedimento"] = $this->column_fields["pedimento"];
			$ncp->column_fields["aduana"] = $this->column_fields["aduana"];
			$ncp->column_fields["fecha_pedimento"] = $this->column_fields["fecha_pedimento"];
			$ncp->column_fields["observaciones"] = $this->column_fields["observaciones"];
			$ncp->column_fields["bloqueado"] = "0";
			$ncp->column_fields["codigos"] = $this->column_fields["codigos"];
			$ncp->column_fields["recepcion_mercancia"] = $rm_id;
			$ncp->column_fields["ncp_estado"] = "Borrador";

			$ncp->save("Notas_credito_proveedor");
//die;

			$ncp_id = $ncp->obtener_id();
			$ncp->asignar_folio("Notas_credito_proveedor", "notas_credito_proveedor", "P");

			// Inicializa desglose de números de serie.
			$consulta = "select ns.*, prod.productname from vtiger_numeros_serie ns, vtiger_crmentity e, vtiger_products prod where e.crmid = ns.numeros_serieid and e.deleted = '0' and ns.recepciones_mercanciaid = '$rm_id' and prod.productid = ns.productid";
//var_dump($consulta);
			$resultado = $adb->query($consulta);
			while ($renglon = $adb->fetch_array($resultado))
			{
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
				$ns_id = $renglon["numeros_serieid"];
				$prod_id = $renglon["productid"];

				$arreglo_ns[$prod_id][$ns_id] = $ns_id;
			}

			$ncp->registrar_detalles(array(), $arreglo_ns);


			if ($this->column_fields["dias_subarrendamiento"])
			{
				// Utiliza mismo cálculo que en tabla_detalles.
				// Costo registrado en días de subarrendamiento.
				$consulta = "select flr.productid, sum(dias * precio) as costo_ds from vtiger_dias_subarrendamiento ds, vtiger_crmentity e, vtiger_flota_renta flr where e.crmid = ds.dias_subarrendamientoid and e.deleted = '0' and ds.recepciones_mercanciaid = '$rm_id' and flr.flota_rentaid = ds.flota_rentaid group by flr.productid";
//var_dump($consulta);
				$resultado = $adb->query($consulta);
				//$renglon = $adb->fetch_array($resultado);

				while ($renglon = $adb->fetch_array($resultado))
				{
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
					$prod_id = $renglon["productid"];
					$costo_ds = $renglon["costo_ds"];

					$costos_ds[$prod_id] = $costo_ds;
				}
			}


			// Crea registros de detalle de la ncp.
			$consulta = "select rmd.* from vtiger_recepciones_mercancia_det rmd, vtiger_crmentity e where e.crmid = rmd.recepciones_mercancia_detid and e.deleted = '0' and rmd.recepciones_mercanciaid = '$rm_id'";
//var_dump($consulta);
			$resultado = $adb->query($consulta);
//$renglon = $adb->fetch_array($resultado);
			while ($renglon = $adb->fetch_array($resultado))
			{
//echo "<pre>";
//var_dump($renglon);
//echo "</pre>";
//die;
				$rmd_id = $renglon["recepciones_mercancia_detid"];
				$rmd_recepcion_mercancia = $renglon["recepcion_mercancia"];
				$rmd_producto = $renglon["productid"];
				$rmd_cantidad = $renglon["cantidad"];
				$rmd_costo = $renglon["costo"];
				$rmd_surtido = $renglon["surtido"];
/************************
	$rmd_folio = $renglon["folio"];
************************/

				$ncpd = new Notas_credito_prov_det;

				$ncpd->column_fields["assigned_user_id"] = $this->column_fields["assigned_user_id"];
				//$ncpd->column_fields["folio"] = $rmd_folio;
				$ncpd->column_fields["nota_credito_proveedor"] = $ncp_id;
				$ncpd->column_fields["producto"] = $rmd_producto;
				$ncpd->column_fields["cantidad"] = $rmd_cantidad;
				//$ncpd->column_fields["costo"] = $rmd_costo;
				$ncpd->column_fields["costo"] = ($this->column_fields["dias_subarrendamiento"])?$costos_ds[$rmd_producto]:$rmd_costo;
				$ncpd->column_fields["surtido"] = $rmd_surtido;
				$ncpd->column_fields["rmd"] = $rmd_id;
				$ncpd->save("Notas_credito_prov_det");
			}
		}

		return $ncp_id;
//die;
	}

	// Crea o actualiza los registros necesarios de este documento en la oreja.
	function sincronizar()
	{
		global $adb;

		$rm_id = $this->obtener_id();

		$oreja = $this->oreja_conectar();

		$oreja_rm_codigo_concepto_mxn = "21";
		$oreja_rm_codigo_concepto_usd = "210";

		$tipo_recepcion = $this->column_fields["tipo_recepcion"];
		$rm_dias_subarrendamiento = $this->column_fields["dias_subarrendamiento"];
		$rm_moneda = ($this->column_fields["moneda"] != "")?$this->column_fields["moneda"]:"MXN";

		// Si es recepción de equipo subarrendado no debe sincronizar. Entonces limpia posible información y sale.
		if ($tipo_recepcion == "Subarrendamiento" && !$rm_dias_subarrendamiento)
		{
			$this->oreja_limpiar($oreja, "Documentos", "cIdDocumento", $this->column_fields["folio"]);
			$this->oreja_limpiar($oreja, "Movimientos", "cIdDocumento", $this->column_fields["folio"]);
			$this->oreja_limpiar($oreja, "CapasProducto", "cIdDocumento", $this->column_fields["folio"]);
			$this->oreja_desconectar($oreja);

			return;
		}



		switch ($tipo_recepcion)
		{
			case "Refacciones":
				$oreja_rm_almacen = "01REF";
			break;
		}

/****************************
		$cli_id = $this->column_fields["cliente"];
		if ($cli_id != "")
		{
			$cli = new Accounts;
			$cli->retrieve_entity_info($cli_id, "Accounts");
			$campo_codigo_cliente = $cli->personalizado("mlan", true);
		}
****************************/

		$prov_id = $this->column_fields["proveedor"];
		if ($prov_id != "")
		{
			$prov = new Vendors;
			$prov->retrieve_entity_info($prov_id, "Vendors");
			$campo_codigo_proveedor = $prov->personalizado("mlan", true);
			$campo_dias_credito = $prov->personalizado("dias_credito", true);

			// Sincroniza el proveedor.
			$prov->sincronizar();
		}

		unset($datos);
/**********************
		$datos["cIdDocumento"] = "ER5";
		$datos["cFecha"] = "2015-09-03";
		$datos["cCodigoConcepto"] = "340";
		$datos["cCodigoCteProv"] = "";
**********************/
		$datos["cIdDocumento"] = $this->column_fields["folio"];
		// ETL2 maneja otro formato de fecha.
		//$datos["cFecha"] = $this->column_fields["fecha_efectiva"];
		$datos["cFecha"] = date("m/d/Y", strtotime($this->column_fields["fecha_efectiva"]));

/**************************
		// Para pruebas solamente:
		if ($datos["cFecha"] == "2016-02-29")
		{
			$datos["cFecha"] = "2015-02-28";
		}
		else
		{
			$datos["cFecha"] = "2015".substr($this->column_fields["fecha_efectiva"], 4);
		}
**************************/

		//$datos["cTipoCambio"] = 1;
		//if ($this->column_fields["moneda"] == "MXN")
		if ($rm_moneda == "MXN")
		{
			$datos["cCodigoConcepto"] = $oreja_rm_codigo_concepto_mxn;
			$datos["cIdMoneda"] = 1;
			$datos["cTipoCambio"] = $this->column_fields["tipo_cambio"];
		}
		//if ($this->column_fields["moneda"] == "USD")
		if ($rm_moneda == "USD")
		{
			$datos["cCodigoConcepto"] = $oreja_rm_codigo_concepto_usd;
			$datos["cIdMoneda"] = 2;
			$datos["cTipoCambio"] = $this->column_fields["tipo_cambio"];
		}

		if ($datos["cTipoCambio"] == "")
		{
			$datos["cTipoCambio"] = 1;
		}

		//$datos["cCodigoCteProv"] = $cli->column_fields[$campo_codigo_cliente];
		$datos["cCodigoCteProv"] = $prov->column_fields[$campo_codigo_proveedor];
		//$datos["cCodigoCteProv"] = "P".$prov->column_fields[$campo_codigo_proveedor];
		if (substr($datos["cCodigoCteProv"], 0, 1) != "P")
		{
			$datos["cCodigoCteProv"] = "P".$datos["cCodigoCteProv"];
		}
		// Muy importante: debe ir en cero. Si es null no funciona!!!
		$datos["cImporte"] = 0;
		$datos["CSERIEDOCUMENTO"] = substr($this->column_fields["folio"], 0, 3);
		$datos["CFOLIO"] = (int)substr($this->column_fields["folio"], 3);
		$datos["CREFERENCIA"] = $this->column_fields["factura_proveedor"];
		//$datos["CFECHAVENCIMIENTO"] = date("Y-m-d", strtotime($this->column_fields["fecha_efectiva"]." + ".$prov->column_fields[$campo_dias_credito]." days"));
//var_dump($this->column_fields["fecha_efectiva"]." + ".$prov->column_fields[$campo_dias_credito]." days");
//die;


/*********************************
// Tabla mínima de documentos:

+--------------+-----------------+----------------+-----------+-------------+----------+------------+
| cIdDocumento | cCodigoConcepto | cCodigoCteProv | cIdMoneda | cTipoCambio | cImporte | cFecha     |
+--------------+-----------------+----------------+-----------+-------------+----------+------------+
| AMA000202    | 21              | P1024          |         1 |           1 |        0 | 2015-03-29 |
+--------------+-----------------+----------------+-----------+-------------+----------+------------+


+-----------------+---------------+------+-----+---------+-------+
| Field           | Type          | Null | Key | Default | Extra |
+-----------------+---------------+------+-----+---------+-------+
| cIdDocumento    | varchar(30)   | YES  |     | NULL    |       |
| cCodigoConcepto | varchar(30)   | YES  |     | NULL    |       |
| cCodigoCteProv  | varchar(10)   | YES  |     | NULL    |       |
| cIdMoneda       | int(11)       | YES  |     | NULL    |       |
| cTipoCambio     | decimal(10,0) | YES  |     | NULL    |       |
| cImporte        | decimal(10,0) | YES  |     | NULL    |       |
| cFecha          | date          | YES  |     | NULL    |       |
+-----------------+---------------+------+-----+---------+-------+
7 rows in set (0.00 sec)

*********************************/

		// Limpia posibles registros previos.
		//$this->oreja_limpiar($oreja, "Documentos", "cIdDocumento", "ER5");
		//$this->oreja_limpiar($oreja, "Movimientos", "cIdDocumento", "ER5");
		$this->oreja_limpiar($oreja, "Documentos", "cIdDocumento", $this->column_fields["folio"]);
		$this->oreja_limpiar($oreja, "Movimientos", "cIdDocumento", $this->column_fields["folio"]);
		$this->oreja_limpiar($oreja, "CapasProducto", "cIdDocumento", $this->column_fields["folio"]);
//die;

		// Transmite el encabezado.
		$this->oreja_transmitir($oreja, "Documentos", $datos);

		// Transmite los detalles.
		//$consulta = "select facd.*, obr.nombre as obra, pfa.periodosid, pfa.movimiento, pfa.fecha_ini, pfa.fecha_ini_fac, pfa.fecha_fin, pfa.fecha_fin_fac, pfa.concepto, pfa.productid, pfa.flota_rentaid, pfa.numeros_serieid, pfa.cantidad as unidades from vtiger_facturas_det facd, vtiger_crmentity e, vtiger_por_facturar pfa, vtiger_obras obr where e.crmid = facd.facturas_detid and e.deleted = '0' and facd.facturasid = '$fac_id' and pfa.por_facturarid = facd.por_facturarid and obr.obrasid = pfa.obrasid order by facd.facturas_detid limit 0, 13";
		$consulta = "select prod.productcode, prod.productname, rmd.* from vtiger_recepciones_mercancia_det rmd, vtiger_crmentity e, vtiger_products prod where e.crmid = rmd.recepciones_mercancia_detid and e.deleted = '0' and rmd.recepciones_mercanciaid = '$rm_id' and prod.productid = rmd.productid";
//var_dump($consulta);
		if ($tipo_recepcion == "Subarrendamiento" && $rm_dias_subarrendamiento)
		{
			$consulta = "select flr.codigo_renta, dsu.* from vtiger_dias_subarrendamiento dsu, vtiger_crmentity e, vtiger_flota_renta flr where e.crmid = dsu.dias_subarrendamientoid and e.deleted = '0' and dsu.recepciones_mercanciaid = '$rm_id' and flr.flota_rentaid = dsu.flota_rentaid;";
		}
		$resultado = $adb->query($consulta);

		$i = 1;
		while ($renglon = $adb->fetch_array($resultado))
		{
			unset($datos);
/**************************
			$datos["cIdDocumento"] = "ER5";
			$datos["cIdMovimiento"] = $datos["cIdDocumento"]."-".str_pad($i, 2, "0", STR_PAD_LEFT);
			$datos["cCodigoProducto"] = "9REP";
			$datos["cCodigoAlmacen"] = "01REP";
			$datos["cUnidades"] = 1;
			$datos["cPrecio"] = 1900.50;
**************************/
			if ($tipo_recepcion == "Subarrendamiento" && $rm_dias_subarrendamiento)
			{
				$datos["cIdDocumento"] = $this->column_fields["folio"];
				$datos["cIdMovimiento"] = $datos["cIdDocumento"]."-".str_pad($i, 2, "0", STR_PAD_LEFT);
				$datos["cCodigoProducto"] = $renglon["codigo_renta"];
				$flr_id = $renglon["flota_rentaid"];
				if ($flr_id != "")
				{
					$flr = new Flota_renta;
					$flr->retrieve_entity_info($flr_id, "Flota_renta");

					// Sincroniza el código de renta (como producto).
					$flr->sincronizar();
				}
				//$datos["cCodigoAlmacen"] = $this->oreja_almacen("RM", $prod_id);
				$datos["cCodigoAlmacen"] = "01CRS";
				$datos["cUnidades"] = $renglon["dias"];
				$datos["cPrecio"] = $renglon["precio"];
				$datos["CTEXTOEXTRA1"] = $renglon["fecha_inicial"].", ".$renglon["fecha_final"];
				$datos["CTEXTOEXTRA2"] = "";
				$datos["CTEXTOEXTRA3"] = "";
			}
			else
			{
				$datos["cIdDocumento"] = $this->column_fields["folio"];
				$datos["cIdMovimiento"] = $datos["cIdDocumento"]."-".str_pad($i, 2, "0", STR_PAD_LEFT);
				$prod_id = $renglon["productid"];
				if ($prod_id != "")
				{
					$prod = new Products;
					$prod->retrieve_entity_info($prod_id, "Products");
					//$datos["cCodigoProducto"] = $prod->column_fields["productcode"];

					// Sincroniza el producto.
					$prod->sincronizar();
				}
				$datos["cCodigoProducto"] = $renglon["productcode"];
				//$datos["cCodigoAlmacen"] = $oreja_rm_almacen;
				$datos["cCodigoAlmacen"] = $this->oreja_almacen("RM", $prod_id);
				$datos["cUnidades"] = $renglon["cantidad"];
				//if ($tipo_recepcion == "Equipos")
				if ($prod->individual())
				{
					$datos["cUnidades"] = 0;
				}
				$datos["cPrecio"] = $renglon["costo"];
				$datos["CTEXTOEXTRA1"] = "";
				$datos["CTEXTOEXTRA2"] = "";
				$datos["CTEXTOEXTRA3"] = "";

				// Almacena información que puede servir para capas.
				$movimientos_capas[$datos["cCodigoProducto"]] = $datos["cIdMovimiento"];
			}

			$this->oreja_transmitir($oreja, "Movimientos", $datos);

			$i++;
		}

		// Transmite las capas de producto (números de serie).
		//$consulta = "select ns.numero_serie, ns.motor, ns.costo from vtiger_numeros_serie ns, vtiger_crmentity e where e.crmid = ns.numeros_serieid and e.deleted = '0' and ns.recepciones_mercanciaid = '$rm_id'";
		$consulta = "select ns.numero_serie, ns.motor, ns.costo, prod.productcode from vtiger_numeros_serie ns, vtiger_crmentity e, vtiger_products prod where e.crmid = ns.numeros_serieid and e.deleted = '0' and ns.recepciones_mercanciaid = '$rm_id' and prod.productid = ns.productid";

//var_dump($consulta);
//die;
		$resultado = $adb->query($consulta);

/****************************
mysql> describe CapasProducto;
+-------------------+-------------+------+-----+---------+-------+
| Field             | Type        | Null | Key | Default | Extra |
+-------------------+-------------+------+-----+---------+-------+
| cIdDocumento      | varchar(30) | YES  |     | NULL    |       |
| cIdMovimiento     | varchar(30) | YES  |     | NULL    |       |
| CUNIDADES         | int(11)     | YES  |     | NULL    |       |
| CPEDIMENTO        | varchar(20) | YES  |     | NULL    |       |
| CADUANA           | varchar(60) | YES  |     | NULL    |       |
| CFECHAPEDIMENTO   | date        | YES  |     | NULL    |       |
| CTIPOCAMBIO       | float       | YES  |     | NULL    |       |
| CSERIE            | varchar(30) | YES  |     | NULL    |       |
| CNUMEROLOTE       | varchar(20) | YES  |     | NULL    |       |
| CFECHACADUCIDAD   | date        | YES  |     | NULL    |       |
| CFECHAFABRICACION | date        | YES  |     | NULL    |       |
| CCOSTO            | float       | YES  |     | NULL    |       |
+-------------------+-------------+------+-----+---------+-------+
12 rows in set (0.00 sec)
******************************/

		$i = 1;
		while ($renglon = $adb->fetch_array($resultado))
		{
			unset($datos);
			$datos["cIdDocumento"] = $this->column_fields["folio"];
			$datos["cIdMovimiento"] = $movimientos_capas[$renglon["productcode"]];
			$datos["CUNIDADES"] = 1;
			$datos["CPEDIMENTO"] = $this->column_fields["pedimento"];
			$datos["CADUANA"] = $this->column_fields["aduana"];
			//$datos["CFECHAPEDIMENTO"] = $this->column_fields["fecha_pedimento"];
			$datos["CFECHAPEDIMENTO"] = "";
			$datos["CTIPOCAMBIO"] = 1;
			//$datos["CSERIE"] = $renglon["numero_serie"];
			$datos["CSERIE"] = "NS:".$renglon["numero_serie"];
			$datos["CNUMEROLOTE"] = "";
			$datos["CFECHACADUCIDAD"] = "";
			$datos["CFECHAFABRICACION"] = "";
			//$datos["CCOSTO"] = $renglon["costo"];
			$datos["cCodigoProducto"] = $renglon["productcode"];

			$this->oreja_transmitir($oreja, "CapasProducto", $datos);

			$i++;
		}

		$this->oreja_desconectar($oreja);
	}
}
?>
