<?php
require_once("config.php");
require_once('include/utils/utils.php');
require_once('modules/Periodos/Periodos.php');
require_once('modules/Flota_renta/Flota_renta.php');
require_once('modules/Kardex/Kardex.php');
require_once('modules/Ordenes_trabajo/Ordenes_trabajo.php');
require_once('modules/Por_facturar/Por_facturar.php');
require_once('modules/Users/Users.php');

function aplicar_cambio($entity)
{
        // Abre la sesión PHP.
        session_start();

        // Carga definiciones de campos personalizados.
        require("campos_personalizados.php");
	global $adb;

        // Carga usuario actual.
        $current_user = new Users();
        $current_user->retrieveCurrentUserInfoFromFile($_SESSION["authenticated_user_id"]);

	$entityArray = get_object_vars($entity);
/****************************************
echo "<pre>";
die(var_dump($entityArray["data"]));
****************************************/

        // Obtiene el id del cliente.
        $elementos = explode("x", $entityArray["data"]["cliente"]);
        $id_cliente = $elementos[1];
//var_dump($id_cliente);

        // Obtiene el id de la obra.
        $elementos = explode("x", $entityArray["data"]["obra"]);
        $id_obra = $elementos[1];

	// Obtiene el id de la sucursal.
	$elementos = explode("x", $entityArray["data"]["sucursal"]);
	$id_sucursal = $elementos[1];

	// Carga la sucursal.
	$sucursal = new Sucursales;
        $sucursal->retrieve_entity_info($id_sucursal, "Sucursales");
//var_dump($id_sucursal);

	// Hace un barrido para aplicar las recolecciones y las nuevas entregas.
	for ($i = 1; $i <= 5; $i++)
	{
		// Obtiene el id de los equipos a recoger y a entregar.
		$elementos = explode("x", $entityArray["data"]["recoger{$i}_equipo"]);
		$id_equipo_recoger = $elementos[1];

                $elementos = explode("x", $entityArray["data"]["entrega{$i}_equipo"]);
                $id_equipo_entregar = $elementos[1];

		if ($id_equipo_recoger)
		{
			if (!$id_equipo_entregar)
			{
				die("<h1>ERROR</h1>No se indicó el equipo a entregar.");
			}
                        // Actualiza el registro de flota de renta correspondiente al equipo que se recoge.
                        $flota_renta_recoger = new Flota_renta;
                        $flota_renta_recoger->retrieve_entity_info($id_equipo_recoger, "Flota_renta");
                        $flota_renta_recoger->column_fields["estado"] = "En servicio";
                        $flota_renta_recoger->column_fields["cliente"] = $sucursal->column_fields["cliente_mks"];
                        $flota_renta_recoger->column_fields["obra"] = $sucursal->column_fields["obra_mks"];
                        $flota_renta_recoger->save("Flota_renta", $id_equipo_recoger);

                        // Actualiza el registro de flota de renta correspondiente al equipo que se entrega.
                        $flota_renta_entregar = new Flota_renta;
                        $flota_renta_entregar->retrieve_entity_info($id_equipo_entregar, "Flota_renta");
                        $flota_renta_entregar->column_fields["estado"] = "En obra";
                        $flota_renta_entregar->column_fields["cliente"] = $id_cliente;
                        $flota_renta_entregar->column_fields["obra"] = $id_obra;
                        $flota_renta_entregar->save("Flota_renta", $id_equipo_entregar);


			// Busca el periodo de renta abierto del equipo que se recoge.
			$consulta = "select per.periodosid from vtiger_periodos per, vtiger_crmentity e where per.flota_rentaid = '$id_equipo_recoger' and per.estado = 'Abierto' and e.crmid = per.periodosid and e.deleted = '0'";
			$resultado = $adb->query($consulta);
			$renglon = $adb->fetch_array($resultado);

			// Instancia el periodo de renta y lo cierra.
			if ($renglon["periodosid"])
			{
				$periodo_recoger = new Periodos;
				$periodo_recoger->retrieve_entity_info($renglon["periodosid"], "Periodos");
				$periodo_recoger->column_fields["estado"] = "Cerrado";
				$periodo_recoger->column_fields["fecha_fin"] = $entityArray["data"]["fecha_efectiva"];
				$periodo_recoger->save("Periodos", $renglon["periodosid"]);
				$periodo_recoger->facturar($entityArray["data"]["fecha_efectiva"], TRUE);
			}

                        // Abre un nuevo periodo de renta, correspondiente al equipo que se entrega.
                        $periodo_entregar = new Periodos;
                        $periodo_entregar->column_fields["estado"] = "Abierto";
                        $periodo_entregar->column_fields["assigned_user_id"] = $current_user->id;
                        $periodo_entregar->column_fields["sucursal"] = $id_sucursal;
                        $periodo_entregar->column_fields["cliente"] = $id_cliente;
                        $periodo_entregar->column_fields["obra"] = $id_obra;
                        $periodo_entregar->column_fields["equipo"] = $id_equipo_entregar;
                        $periodo_entregar->column_fields["fecha_ini"] = $entityArray["data"]["fecha_efectiva"];
                        $periodo_entregar->save("Periodos");


			// Genera una orden de trabajo para el equipo que se recoge. Debe reproducir el comportamiento del archivo Save.php de su módulo, pues sólo fciona cuando se crea manual y no mediante la api de Vtiger.
			$ot = new Ordenes_trabajo;
//var_dump($ot->column_fields);
			//$ot->column_fields["assigned_user_id"] = 1;
			$ot->column_fields["assigned_user_id"] = $current_user->id;
			$ot->column_fields["sucursal"] = $id_sucursal;
			$ot->column_fields["equipo"] = $id_equipo_recoger;
			$ot->column_fields["estado"] = "Abierta";
			$ot->column_fields["fecha_ini"] = $entityArray["data"]["fecha_efectiva"];
        		$ot->column_fields["folio"] = $sucursal->column_fields["prefijo"]."OT".str_pad($sucursal->column_fields["ordenes_trabajo"], 6, "0", STR_PAD_LEFT);
			$ot->save("Ordenes_trabajo");

			// Actualiza folio de órdenes de trabajo de la sucursal.
        		$sucursal->column_fields["ordenes_trabajo"]++;
        		$sucursal->column_fields["nombre"] = html_entity_decode($sucursal->column_fields["nombre"], ENT_NOQUOTES, "UTF-8");
        		$sucursal->save("Sucursales", $id_sucursal);

                        // Registra la recolección en el kardex.
                        $kardex = new Kardex;
                        $kardex->column_fields["assigned_user_id"] = $current_user->id;
                        $kardex->column_fields["codigo"] = $flota_renta_recoger->column_fields["numero_interno"];
                        $kardex->column_fields["numero_serie"] = $flota_renta_recoger->column_fields["numero_serie"];
                        $kardex->column_fields["fecha"] = $entityArray["data"]["fecha_efectiva"];
                        $kardex->column_fields["tipo_documento"] = "Cambio";
                        $kardex->column_fields["movimiento"] = $entityArray["data"]["folio"];
                        $kardex->column_fields["existencia_inicial"] = 1;
                        $kardex->column_fields["entradas"] = 0;
                        $kardex->column_fields["salidas"] = 0;
                        $kardex->column_fields["existencia_final"] = 1;
                        $kardex->save("Kardex");

                        // Registra la orden de trabajo en el kardex.
                        $kardex = new Kardex;
                        $kardex->column_fields["assigned_user_id"] = $current_user->id;
                        $kardex->column_fields["codigo"] = $flota_renta_recoger->column_fields["numero_interno"];
                        $kardex->column_fields["numero_serie"] = $flota_renta_recoger->column_fields["numero_serie"];
                        $kardex->column_fields["fecha"] = $entityArray["data"]["fecha_efectiva"];
                        $kardex->column_fields["tipo_documento"] = "Orden de trabajo";
                        $kardex->column_fields["movimiento"] = $ot->column_fields["folio"];
                        $kardex->column_fields["existencia_inicial"] = 1;
                        $kardex->column_fields["entradas"] = 0;
                        $kardex->column_fields["salidas"] = 0;
                        $kardex->column_fields["existencia_final"] = 1;
                        $kardex->save("Kardex");

                        // Registra la entrega en el kardex.
                        $kardex = new Kardex;
                        $kardex->column_fields["assigned_user_id"] = $current_user->id;
                        $kardex->column_fields["codigo"] = $flota_renta_entregar->column_fields["numero_interno"];
                        $kardex->column_fields["numero_serie"] = $flota_renta_entregar->column_fields["numero_serie"];
                        $kardex->column_fields["fecha"] = $entityArray["data"]["fecha_efectiva"];
                        $kardex->column_fields["tipo_documento"] = "Cambio";
                        $kardex->column_fields["movimiento"] = $entityArray["data"]["folio"];
                        $kardex->column_fields["existencia_inicial"] = 1;
                        $kardex->column_fields["entradas"] = 0;
                        $kardex->column_fields["salidas"] = 0;
                        $kardex->column_fields["existencia_final"] = 1;
                        $kardex->save("Kardex");
		}
	}
}
?>
