<?php
require_once("config.php");
require_once('include/utils/utils.php');
require_once('modules/Periodos/Periodos.php');
require_once('modules/Flota_renta/Flota_renta.php');
require_once('modules/Kardex/Kardex.php');
require_once('modules/Users/Users.php');

// Cambio el estado del equipo a "En obra".
function aplicar_entrega($entity)
{
        // Abre la sesión PHP.
        session_start();

        // Carga definiciones de campos personalizados.
        require("campos_personalizados.php");
	global $adb;

        // Carga usuario actual.
        $current_user = new Users();
        $current_user->retrieveCurrentUserInfoFromFile($_SESSION["authenticated_user_id"]);

	$entityArray = get_object_vars($entity);
/***************************************
	echo '<pre>';
var_dump($entityArray["data"]);
	//print_r($entityArray);
	//echo '</pre>';
**********************************/

	// Obtiene el id del cliente.
	$elementos = explode("x", $entityArray["data"]["cliente"]);
	$id_cliente = $elementos[1];
//var_dump($id_cliente);

	// Obtiene el id de la obra.
	$elementos = explode("x", $entityArray["data"]["obra"]);
	$id_obra = $elementos[1];
//var_dump($id_obra);

	// Obtiene el id de la sucursal.
	$elementos = explode("x", $entityArray["data"]["sucursal"]);
	$id_sucursal = $elementos[1];
//var_dump($id_sucursal);

	for ($i = 1; $i <= 10; $i++)
	{
		// Obtiene el id del equipo.
		$elementos = explode("x", $entityArray["data"]["entrega{$i}_equipo"]);
		$id_equipo = $elementos[1];

		if ($id_equipo)
		{
			/**********************************************************
			// Instancia el equipo y actualiza su estado.
			$equipo = new Assets;
			$equipo->retrieve_entity_info($id_equipo, "Assets");
//var_dump($equipo->column_fields);
			$equipo->column_fields["assetstatus"] = "En obra";
			$equipo->column_fields["account"] = $id_cliente;
			$equipo->column_fields[$campos_personalizados["assets"]["obra"]] = $id_obra;
			$equipo->save("Assets", $id_equipo);
			***********************************************************/
			// Actualiza el registro de flota de renta correspondiente.
			$flota_renta = new Flota_renta;
			$flota_renta->retrieve_entity_info($id_equipo, "Flota_renta");
			$flota_renta->column_fields["estado"] = "En obra";
			$flota_renta->column_fields["cliente"] = $id_cliente;
			$flota_renta->column_fields["obra"] = $id_obra;
			$flota_renta->save("Flota_renta", $id_equipo);

			// Abre un nuevo periodo de renta.
			$periodo = new Periodos;
//var_dump($periodo->column_fields);
			$periodo->column_fields["estado"] = "Abierto";
			//$periodo->column_fields["assigned_user_id"] = 1;
			$periodo->column_fields["assigned_user_id"] = $current_user->id;
			$periodo->column_fields["sucursal"] = $id_sucursal;
			$periodo->column_fields["cliente"] = $id_cliente;
			$periodo->column_fields["obra"] = $id_obra;
			$periodo->column_fields["equipo"] = $id_equipo;
			$periodo->column_fields["fecha_ini"] = $entityArray["data"]["fecha_efectiva"];
			$periodo->save("Periodos");

			// Registra la entrega en el kardex.
/***********************************************************************************
			$kardex = new Kardex;
			//$kardex->column_fields["assigned_user_id"] = 1;
			$kardex->column_fields["assigned_user_id"] = $current_user->id;
        		$kardex->column_fields["numero_serie"] = $flota_renta->column_fields["numero_serie"];
        		$kardex->column_fields["numero_interno"] = $flota_renta->column_fields["numero_interno"];
        		$kardex->column_fields["movimiento"] = $entityArray["data"]["folio"];
        		$kardex->save("Kardex");
*********************************************************************************/
        		$kardex = new Kardex;
        		$kardex->column_fields["assigned_user_id"] = $current_user->id;
        		$kardex->column_fields["codigo"] = $flota_renta->column_fields["numero_interno"];
        		$kardex->column_fields["numero_serie"] = $flota_renta->column_fields["numero_serie"];
        		$kardex->column_fields["fecha"] = $entityArray["data"]["fecha_efectiva"];
        		$kardex->column_fields["tipo_documento"] = "Entrega";
        		$kardex->column_fields["movimiento"] = $entityArray["data"]["folio"];
        		$kardex->column_fields["existencia_inicial"] = 1;
        		$kardex->column_fields["entradas"] = 0;
        		$kardex->column_fields["salidas"] = 0;
        		$kardex->column_fields["existencia_final"] = 1;
        		$kardex->save("Kardex");
		}
	}
}
?>
