<?php
require_once("config.php");
require_once('include/utils/utils.php');
require_once('modules/Periodos/Periodos.php');
require_once('modules/Flota_renta/Flota_renta.php');
require_once('modules/Kardex/Kardex.php');
require_once('modules/Ordenes_trabajo/Ordenes_trabajo.php');
require_once('modules/Por_facturar/Por_facturar.php');
require_once('modules/Users/Users.php');

// Cambio el estado del equipo a "En servicio".
function aplicar_recoleccion($entity)
{
        // Abre la sesión PHP.
        session_start();

        // Carga definiciones de campos personalizados.
        require("campos_personalizados.php");
	global $adb;

        // Carga usuario actual.
        $current_user = new Users();
        $current_user->retrieveCurrentUserInfoFromFile($_SESSION["authenticated_user_id"]);

	$entityArray = get_object_vars($entity);
/***************************************
	echo '<pre>';
var_dump($entityArray["data"]);
	//print_r($entityArray);
	//echo '</pre>';
	// Obtiene el id del cliente.
	$elementos = explode("x", $entityArray["data"]["cliente"]);
	$id_cliente = $elementos[1];
//var_dump($id_cliente);

	// Obtiene el id de la obra.
	$elementos = explode("x", $entityArray["data"]["obra"]);
	$id_obra = $elementos[1];
//var_dump($id_obra);
**********************************/

	// Obtiene el id de la sucursal.
	$elementos = explode("x", $entityArray["data"]["sucursal"]);
	$id_sucursal = $elementos[1];

	// Carga la sucursal.
	$sucursal = new Sucursales;
        $sucursal->retrieve_entity_info($id_sucursal, "Sucursales");
//var_dump($id_sucursal);

	for ($i = 1; $i <= 10; $i++)
	{
		// Obtiene el id del equipo.
		$elementos = explode("x", $entityArray["data"]["recoger{$i}_equipo"]);
		$id_equipo = $elementos[1];

		if ($id_equipo)
		{
			/**************************************************
			// Instancia el equipo y actualiza su estado.
			$equipo = new Assets;
			$equipo->retrieve_entity_info($id_equipo, "Assets");
//var_dump($equipo->column_fields);
			$equipo->column_fields["assetstatus"] = "In Service";
			$equipo->column_fields["account"] = $config_sistema["cliente_mks"];
			$equipo->column_fields[$campos_personalizados["assets"]["obra"]] = $config_sistema["obra_mks"];
			$equipo->save("Assets", $id_equipo);
			**************************************************/
                        // Actualiza el registro de flota de renta correspondiente.
                        $flota_renta = new Flota_renta;
                        $flota_renta->retrieve_entity_info($id_equipo, "Flota_renta");
                        $flota_renta->column_fields["estado"] = "En servicio";
                        $flota_renta->column_fields["cliente"] = $sucursal->column_fields["cliente_mks"];
                        $flota_renta->column_fields["obra"] = $sucursal->column_fields["obra_mks"];
                        $flota_renta->save("Flota_renta", $id_equipo);

			// Busca el periodo de renta abierto del equipo.
			//$consulta = "select per.periodosid from vtiger_periodos per, vtiger_crmentity e where per.assetsid = '$id_equipo' and per.estado = 'Abierto' and e.crmid = per.periodosid and e.deleted = '0'";
			$consulta = "select per.periodosid from vtiger_periodos per, vtiger_crmentity e where per.flota_rentaid = '$id_equipo' and per.estado = 'Abierto' and e.crmid = per.periodosid and e.deleted = '0'";
//var_dump($consulta);
//die;
			$resultado = $adb->query($consulta);
			$renglon = $adb->fetch_array($resultado);
//var_dump($renglon);

			// Instancia el periodo de renta y lo cierra.
			if ($renglon["periodosid"])
			{
				$periodo = new Periodos;
				$periodo->retrieve_entity_info($renglon["periodosid"], "Periodos");
				//var_dump($periodo->column_fields);
				$periodo->column_fields["estado"] = "Cerrado";
				$periodo->column_fields["fecha_fin"] = $entityArray["data"]["fecha_efectiva"];
				$periodo->save("Periodos", $renglon["periodosid"]);
				$periodo->facturar($entityArray["data"]["fecha_efectiva"], TRUE);
			}

/**********************************
			// Genera los registros de lo pendiente por facturar.
			$por_facturar = new Por_facturar;
//var_dump($por_facturar->column_fields);
			$por_facturar->column_fields["assigned_user_id"] = 1;
			$por_facturar->column_fields["cliente"] = $id_cliente;
			$por_facturar->column_fields["obra"] = $id_obra;
			$por_facturar->column_fields["equipo"] = $id_equipo;
			$por_facturar->column_fields["periodo"] = $renglon["periodosid"];
			$por_facturar->column_fields["estado"] = "Pendiente";
			$por_facturar->column_fields["fecha_ini"] = $periodo->column_fields["fecha_ini"];
			$por_facturar->column_fields["fecha_fin"] = $periodo->column_fields["fecha_fin"];
			$por_facturar->save("Por_facturar");
************************************/

			// Genera una orden de trabajo para el equipo. Debe reproducir el comportamiento del archivo Save.php de su módulo, pues sólo fciona cuando se crea manual y no mediante la api de Vtiger.
			$ot = new Ordenes_trabajo;
//var_dump($ot->column_fields);
			//$ot->column_fields["assigned_user_id"] = 1;
			$ot->column_fields["assigned_user_id"] = $current_user->id;
			$ot->column_fields["sucursal"] = $id_sucursal;
			$ot->column_fields["equipo"] = $id_equipo;
			$ot->column_fields["estado"] = "Abierta";
			$ot->column_fields["fecha_ini"] = $entityArray["data"]["fecha_efectiva"];
        		$ot->column_fields["folio"] = $sucursal->column_fields["prefijo"]."OT".str_pad($sucursal->column_fields["ordenes_trabajo"], 6, "0", STR_PAD_LEFT);
			$ot->save("Ordenes_trabajo");

			// Actualiza folio de órdenes de trabajo de la sucursal.
        		$sucursal->column_fields["ordenes_trabajo"]++;
        		$sucursal->column_fields["nombre"] = html_entity_decode($sucursal->column_fields["nombre"], ENT_NOQUOTES, "UTF-8");
        		$sucursal->save("Sucursales", $id_sucursal);

                        // Registra la recolección en el kardex.
/****************************************************************************
                        $kardex = new Kardex;
                        //$kardex->column_fields["assigned_user_id"] = 1;
                        $kardex->column_fields["assigned_user_id"] = $current_user->id;
                        $kardex->column_fields["numero_serie"] = $flota_renta->column_fields["numero_serie"];
                        $kardex->column_fields["numero_interno"] = $flota_renta->column_fields["numero_interno"];
                        $kardex->column_fields["movimiento"] = $entityArray["data"]["folio"];
                        $kardex->save("Kardex");
****************************************************************************/
                        $kardex = new Kardex;
                        $kardex->column_fields["assigned_user_id"] = $current_user->id;
                        $kardex->column_fields["codigo"] = $flota_renta->column_fields["numero_interno"];
                        $kardex->column_fields["numero_serie"] = $flota_renta->column_fields["numero_serie"];
                        $kardex->column_fields["fecha"] = $entityArray["data"]["fecha_efectiva"];
                        $kardex->column_fields["tipo_documento"] = "Recolección";
                        $kardex->column_fields["movimiento"] = $entityArray["data"]["folio"];
                        $kardex->column_fields["existencia_inicial"] = 1;
                        $kardex->column_fields["entradas"] = 0;
                        $kardex->column_fields["salidas"] = 0;
                        $kardex->column_fields["existencia_final"] = 1;
                        $kardex->save("Kardex");

                        // Registra la orden de trabajo en el kardex.
/*******************************************************************************
                        $kardex = new Kardex;
                        //$kardex->column_fields["assigned_user_id"] = 1;
                        $kardex->column_fields["assigned_user_id"] = $current_user->id;
                        $kardex->column_fields["numero_serie"] = $flota_renta->column_fields["numero_serie"];
                        $kardex->column_fields["numero_interno"] = $flota_renta->column_fields["numero_interno"];
                        $kardex->column_fields["movimiento"] = $ot->column_fields["folio"];
                        $kardex->save("Kardex");
*******************************************************************************/
                        $kardex = new Kardex;
                        $kardex->column_fields["assigned_user_id"] = $current_user->id;
                        $kardex->column_fields["codigo"] = $flota_renta->column_fields["numero_interno"];
                        $kardex->column_fields["numero_serie"] = $flota_renta->column_fields["numero_serie"];
                        $kardex->column_fields["fecha"] = $entityArray["data"]["fecha_efectiva"];
                        $kardex->column_fields["tipo_documento"] = "Orden de trabajo";
                        $kardex->column_fields["movimiento"] = $ot->column_fields["folio"];
                        $kardex->column_fields["existencia_inicial"] = 1;
                        $kardex->column_fields["entradas"] = 0;
                        $kardex->column_fields["salidas"] = 0;
                        $kardex->column_fields["existencia_final"] = 1;
                        $kardex->save("Kardex");
		}
	}
}
?>
