<?php
require_once("config.php");
require_once('include/utils/utils.php');
require_once('modules/Existencias/Existencias.php');
require_once('modules/Products/Products.php');
require_once('modules/Recepciones_mercancia/Recepciones_mercancia.php');
require_once('modules/Users/Users.php');
require_once('modules/Sucursales/Sucursales.php');
require_once('modules/Lineas/Lineas.php');
require_once('modules/Kardex/Kardex.php');

// Recibe la mercancía afectando existencias en el almacén correspondiente.
function recibir_mercancia($entity)
{
/*******************
echo "<pre>";
var_dump($entity);
die;
********************/
	// Abre la sesión PHP.
	session_start();

        // Carga definiciones de campos personalizados.
        require("campos_personalizados.php");
	
	// Carga usuario actual.
	$current_user = new Users();
	$current_user->retrieveCurrentUserInfoFromFile($_SESSION["authenticated_user_id"]);

	global $adb;

	$entityArray = get_object_vars($entity);

	// Obtiene el id de la recepción que estamos procesando.
	$elementos = explode("x", $entityArray["data"]["id"]);
	$id_recepcion = (int)$elementos[1];

	$producto_actual = new Products;
	//echo '<pre>';
	//var_dump($entityArray["data"]);
//die;

	// Obtiene productos y cantidades.
	for ($i = 1; $i <= 10; $i++)
	{
		$elementos = explode("x", $entityArray["data"]["producto$i"]);
		if ($elementos[1])
		{
			$productos[$i]["id"] = (int)$elementos[1];
			$productos[$i]["cantidad"] = $entityArray["data"]["cantidad$i"];
		}
	}

	// Obtiene la sucursal.
	$elementos = explode("x", $entityArray["data"]["sucursal"]);
	$sucursal = new Sucursales;
	$sucursal->retrieve_entity_info((int)$elementos[1], "Sucursales");
	//$id_almacen_nuevo = $sucursal->column_fields["almacen_nuevo"];

	//var_dump($producto1_id);
	foreach ($productos as $producto)
	{
		$producto_actual->retrieve_entity_info($producto["id"], "Products");
		// Obtiene la línea del producto.
		$linea_actual = new Lineas;
//var_dump($producto_actual->column_fields[$campos_personalizados["products"]["linea"]]);
		$linea_actual->retrieve_entity_info($producto_actual->column_fields[$campos_personalizados["products"]["linea"]], "Lineas");

		// Si se trata de una refacción afecta directamente al producto. No se usa módulo de existencias y no hay alta a flota de renta posteriormente.
/************************************
		// Si se trata de una refacción se usa el almacén de refacciones.
		//if ((strpos("Refacci", $producto_actual->column_fields[$campos_personalizados["products"]["familia"]])) !== FALSE)
		if ((strpos("Refacci", $linea_actual->column_fields["familia"])) !== FALSE)
		{
			$producto_actual->column_fields["qtyinstock"] += $producto["cantidad"];
			// Verifica que la información quede grabada en UTF-8.
			$producto_actual->column_fields["productname"] = html_entity_decode($producto_actual->column_fields["productname"], ENT_NOQUOTES, "UTF-8");
			//$producto_actual->column_fields[$campos_personalizados["products"]["familia"]] = html_entity_decode($producto_actual->column_fields[$campos_personalizados["products"]["familia"]], ENT_NOQUOTES, "UTF-8");
			$producto_actual->save("Products", $producto["id"]);
			continue;
		}
*************************************/

		// Establece almacén a afectar y número interno según la familia de producto.
		$familia = substr($linea_actual->column_fields["familia"], 0, 4);
		switch ($familia)
		{
			case "Refa":
				$num_int = $producto_actual->column_fields["productcode"];
				$id_almacen_afectar = $sucursal->column_fields["almacen_refacciones"];
			break;
			default:
				$num_int = "N".$producto_actual->column_fields["productcode"]."000";
				$id_almacen_afectar = $sucursal->column_fields["almacen_nuevo"];
			break;
		}

		//$num_int = "N".$producto_actual->column_fields["productcode"]."000";
		// Si es subarrendado, agrega el prefijo "W".
		if ($entityArray["data"]["subarrendado"])
		{
			$num_int = "W$num_int";
		}

//die(var_dump($num_int));
		//$consulta = "select ex.existenciasid from vtiger_existencias ex, vtiger_crmentity e where ex.productid = '".$producto["id"]."' and e.crmid = ex.existenciasid and e.deleted = '0' and ex.almacenesid = '$id_almacen_nuevo'";
		//$consulta = "select ex.existenciasid from vtiger_existencias ex, vtiger_crmentity e where ex.productid = '".$producto["id"]."' and e.crmid = ex.existenciasid and e.deleted = '0' and ex.almacenesid = '$id_almacen_afectar'";
		$consulta = "select ex.existenciasid from vtiger_existencias ex, vtiger_crmentity e where ex.codigo_producto = '$num_int' and e.crmid = ex.existenciasid and e.deleted = '0' and ex.almacenesid = '$id_almacen_afectar'";
//var_dump($consulta);
		$resultado = $adb->query($consulta);
		$renglon = $adb->fetch_array($resultado);
//var_dump($renglon);
//die;

		$existencias = new Existencias;
		if ($renglon["existenciasid"])
		{
			$existencias->retrieve_entity_info($renglon["existenciasid"], "Existencias");
		}
		$existencias->column_fields["assigned_user_id"] = $current_user->id;
		$existencias->column_fields["sucursal"] = $sucursal->column_fields["record_id"];
		//$existencias->column_fields["almacen"] = $sucursal->column_fields["almacen_nuevo"];
		$existencias->column_fields["almacen"] = $id_almacen_afectar;
		$existencias->column_fields["producto"] = $producto["id"];
		$existencias->column_fields["codigo_producto"] = $num_int;
//echo "<pre>";
//die(var_dump($existencias));

                // Crea un registro en el kardex.
                $kardex = new Kardex;
                $kardex->column_fields["assigned_user_id"] = $current_user->id;
                $kardex->column_fields["codigo"] = $num_int;
                //$kardex->column_fields["numero_serie"] = $ns->id;
                $kardex->column_fields["fecha"] = $entityArray["data"]["fecha_efectiva"];
                $kardex->column_fields["tipo_documento"] = "Recepción de mercancía";
                $kardex->column_fields["movimiento"] = $entityArray["data"]["folio"];
                $kardex->column_fields["existencia_inicial"] = 0 + $existencias->column_fields["cantidad"];
                $kardex->column_fields["entradas"] = $producto["cantidad"];
                $kardex->column_fields["salidas"] = 0;
                $kardex->column_fields["existencia_final"] = $existencias->column_fields["cantidad"] + $producto["cantidad"];

		// Graba kardex e incrementa y graba existencias.
                $kardex->save("Kardex");
		$existencias->column_fields["cantidad"] += $producto["cantidad"];
		$existencias->save("Existencias", $renglon["existenciasid"]);
	}

//die;

echo "<script language=\"javascript\">";
echo "document.location = 'index.php?module=Recepciones_mercancia&action=registrar_ns&record=$id_recepcion';";
echo "</script>";
}
?>
