<?php
require_once("config.php");
require_once("include/utils/utils.php");
require_once("modules/Docs_oper/Docs_oper.php");
require_once("modules/Recepciones_mercancia/Recepciones_mercancia.php");
require_once("modules/Altas_flota_renta/Altas_flota_renta.php");
require_once("modules/Entregas/Entregas.php");
require_once("modules/Recolecciones/Recolecciones.php");
require_once("modules/Cambios/Cambios.php");
require_once("modules/Users/Users.php");
require("campos_personalizados.php");

// Abre la sesión PHP.
session_start();

// Recibe parámetro con el bloque de fechas a procesar.
$bloque = $_GET["b"];
$fecha_inicio = $_GET["f"];
$documento_inicio = $_GET["d"];

if ($bloque == "" && $fecha_inicio == "")
{
	die("No se especificó el bloque de fechas a procesar.");
}

// Carga datos de usuario.
$current_user = new Users();
$current_user->retrieveCurrentUserInfoFromFile($_SESSION["authenticated_user_id"]);

global $adb;

echo "Reconstruyendo...";
echo "<br>";
echo "<br>";
echo "Agrupando documentos por fecha...";
echo "<br>";
echo "<br>";
echo "<div style=\"font-size:8px;\">";


// Recepciones de mercancía.
//$consulta = "select rm.* from vtiger_recepciones_mercancia rm, vtiger_crmentity e where e.crmid = rm.recepciones_mercanciaid and e.deleted = '0' and rm.fecha_efectiva != '' and rm.folio = 'AMA000108'";
//$consulta = "select rm.* from vtiger_recepciones_mercancia rm, vtiger_crmentity e where e.crmid = rm.recepciones_mercanciaid and e.deleted = '0' and rm.fecha_efectiva != '' and rm.fecha_efectiva != '0000-00-00' order by rm.fecha_efectiva limit 0,3";
$consulta = "select rm.* from vtiger_recepciones_mercancia rm, vtiger_crmentity e where e.crmid = rm.recepciones_mercanciaid and e.deleted = '0' and rm.fecha_efectiva != '' and rm.fecha_efectiva != '0000-00-00'";
$resultado = $adb->query($consulta);
while ($renglon = $adb->fetch_array($resultado))
{
	//echo $renglon["folio"].": ".$renglon["fecha_efectiva"]."<br>";
	echo $renglon["folio"].": ".$renglon["fecha_efectiva"]."|";
	$documentos[$renglon["fecha_efectiva"]][$renglon["recepciones_mercanciaid"]] = $renglon["folio"];
}
echo "Terminado.<br>";

// Altas a flota de renta.
//$consulta = "select afr.* from vtiger_altas_flota_renta afr, vtiger_crmentity e where e.crmid = afr.altas_flota_rentaid and e.deleted = '0' and afr.fecha_efectiva != '' and afr.fecha_efectiva != '0000-00-00' order by afr.fecha_efectiva limit 0,3";
$consulta = "select afr.* from vtiger_altas_flota_renta afr, vtiger_crmentity e where e.crmid = afr.altas_flota_rentaid and e.deleted = '0' and afr.fecha_efectiva != '' and afr.fecha_efectiva != '0000-00-00'";
$resultado = $adb->query($consulta);
while ($renglon = $adb->fetch_array($resultado))
{
	//echo $renglon["folio"].": ".$renglon["fecha_efectiva"]."<br>";
	echo $renglon["folio"].": ".$renglon["fecha_efectiva"]."|";
	$documentos[$renglon["fecha_efectiva"]][$renglon["altas_flota_rentaid"]] = $renglon["folio"];
}
echo "Terminado.<br>";
echo "</div>";

/****************************************************************************
// Entregas.
$consulta = "select ent.* from vtiger_entregas ent, vtiger_crmentity e where e.crmid = ent.entregasid and e.deleted = '0'";
$resultado = $adb->query($consulta);
while ($renglon = $adb->fetch_array($resultado))
{
	$docoper = new Docs_oper;
        //var_dump($renglon["folio"]);
        $docoper->column_fields["assigned_user_id"] = $current_user->id;
        //$docoper->column_fields["folio"] = $renglon["folio"];
        $docoper->column_fields["tipo_documento"] = "Entrega";
        $docoper->column_fields["fecha"] = $renglon["fecha_efectiva"];
	$docoper->column_fields["crmid"] = $renglon["entregasid"];
	$docoper->column_fields["entrega"] = $renglon["entregasid"];
        $docoper->save("Docs_oper");
}

// Cambios.
$consulta = "select cam.* from vtiger_cambios cam, vtiger_crmentity e where e.crmid = cam.cambiosid and e.deleted = '0'";
$resultado = $adb->query($consulta);
while ($renglon = $adb->fetch_array($resultado))
{
	$docoper = new Docs_oper;
        //var_dump($renglon["folio"]);
        $docoper->column_fields["assigned_user_id"] = $current_user->id;
        //$docoper->column_fields["folio"] = $renglon["folio"];
        $docoper->column_fields["tipo_documento"] = "Cambio";
        $docoper->column_fields["fecha"] = $renglon["fecha_efectiva"];
	$docoper->column_fields["crmid"] = $renglon["cambiosid"];
	$docoper->column_fields["cambio"] = $renglon["cambiosid"];
        $docoper->save("Docs_oper");
}

// Recolecciones.
$consulta = "select rco.* from vtiger_recolecciones rco, vtiger_crmentity e where e.crmid = rco.recoleccionesid and e.deleted = '0'";
$resultado = $adb->query($consulta);
while ($renglon = $adb->fetch_array($resultado))
{
	$docoper = new Docs_oper;
        //var_dump($renglon["folio"]);
        $docoper->column_fields["assigned_user_id"] = $current_user->id;
        //$docoper->column_fields["folio"] = $renglon["folio"];
        $docoper->column_fields["tipo_documento"] = "Recolección";
        $docoper->column_fields["fecha"] = $renglon["fecha_efectiva"];
	$docoper->column_fields["crmid"] = $renglon["recoleccionesid"];
	$docoper->column_fields["recoleccion"] = $renglon["recoleccionesid"];
        $docoper->save("Docs_oper");
}

// Órdenes de trabajo.
$consulta = "select ot.* from vtiger_ordenes_trabajo ot, vtiger_crmentity e where e.crmid = ot.ordenes_trabajoid and e.deleted = '0'";
$resultado = $adb->query($consulta);
while ($renglon = $adb->fetch_array($resultado))
{
	$docoper = new Docs_oper;
        //var_dump($renglon["folio"]);
        $docoper->column_fields["assigned_user_id"] = $current_user->id;
        //$docoper->column_fields["folio"] = $renglon["folio"];
        $docoper->column_fields["tipo_documento"] = "Orden de trabajo";
        $docoper->column_fields["fecha"] = $renglon["fecha_ini"];
	$docoper->column_fields["crmid"] = $renglon["ordenes_trabajoid"];
	$docoper->column_fields["orden_trabajo"] = $renglon["ordenes_trabajoid"];
        $docoper->save("Docs_oper");
}

// Facturas.
$consulta = "select fac.* from vtiger_facturas fac, vtiger_crmentity e where e.crmid = fac.facturasid and e.deleted = '0'";
$resultado = $adb->query($consulta);
while ($renglon = $adb->fetch_array($resultado))
{
	$docoper = new Docs_oper;
        //var_dump($renglon["folio"]);
        $docoper->column_fields["assigned_user_id"] = $current_user->id;
        //$docoper->column_fields["folio"] = $renglon["folio"];
        $docoper->column_fields["tipo_documento"] = "Factura";
        $docoper->column_fields["fecha"] = $renglon["fecha_efectiva"];
	$docoper->column_fields["crmid"] = $renglon["facturasid"];
	$docoper->column_fields["factura"] = $renglon["facturasid"];
        $docoper->save("Docs_oper");
}
echo "<pre>";
//var_dump($documentos);
ksort($documentos);
var_dump($documentos);
echo "</pre>";
die;
***************************************************************/

ksort($documentos);
$i = 1;
$fechas_procesar = 20;
$inicio = 1 + (($bloque - 1) * $fechas_procesar);
$fin = $fechas_procesar * $bloque;
//var_dump($inicio);
//var_dump($fin);
//die;

// Limpia las existencias.
// Tal vez sólo necesitamos borrarlas al iniciar una reconstrucción total.
if ($bloque == 1)
{
	$consulta = "update vtiger_crmentity e set deleted = '1' where e.setype = 'Existencias'";
	$adb->query($consulta);
}

$procesar = false;
foreach ($documentos as $fecha => $folios)
{
	if ($fecha_inicio != "")
	{
		if (strtotime($fecha) < strtotime($fecha_inicio))
		{
			continue;
		}
		if ($i > $fechas_procesar)
		{
			break;
		}
	}
	else
	{
		if ($i < $inicio)
		{
			//echo "ini$i|";
			$i++;
			continue;
		}
		if ($i > $fin)
		{
			//echo "fin$i|";
			break;
		}
	}

	echo "<b>$i. $fecha</b><br>";

	// Limpia elementos a partir de la fecha efectiva que se está procesando.
	// Limpia la lista de documentos de operación.
	//$consulta = "update vtiger_crmentity e set deleted = '1' where e.setype = 'Docs_oper'";
	//$adb->query($consulta);

	// Limpia el kardex.
	if ($documento_inicio == "")
	{
		$consulta = "update vtiger_kardex kdx, vtiger_crmentity e set e.deleted = '1' where e.crmid = kdx.kardexid and e.deleted = '0' and kdx.fecha >= '$fecha'";
		$adb->query($consulta);
	}

	// Limpia los periodos.
	//$consulta = "update vtiger_crmentity e set deleted = '1' where e.setype = 'Periodos'";
	//$adb->query($consulta);

	// Hace un barrido de los documentos de operación y los agrega a la lista.
	//$entrega = new Entregas;
	//$recoleccion = new Recolecciones;
	//$cambio = new Cambios;

	foreach ($folios as $crmid => $folio)
	{
		if ($documento_inicio != "")
		{
			if ($folio != $documento_inicio && $procesar == false)
			{
				continue;
			}
			if ($folio == $documento_inicio)
			{
				$procesar = true;
			}
		}
		echo "$folio <a href=\"reconstruccion.php?f=$fecha&d=$folio\" style=\"font-size:8px;\">Reconstruir desde aqu&iacute;</a><br>";
		$tipo = substr($folio, 1, 1);
		//echo "$tipo<br>";
		switch ($tipo)
		{
			case "M":
				$recepcion = new Recepciones_mercancia;
				$recepcion->retrieve_entity_info($crmid, "Recepciones_mercancia");
				$recepcion->reconstruir();
			break;
			case "A":
				$alta = new Altas_flota_renta;
				$alta->retrieve_entity_info($crmid, "Altas_flota_renta");
				$alta->reconstruir();
			break;
		}
	}

	$i++;
}
echo "Terminado. Se procesaron $fechas_procesar fechas.<br>";

die;





/****************************************************
			$alta->procesar();
			$anomalia = $alta->detectar_anomalias();
			if ($anomalia != false)
			{
				$docoper = new Docs_oper;
				$docoper->retrieve_entity_info($renglon["docs_operid"], "Docs_oper");
				$docoper->column_fields["anomalias"] = $anomalia;
				$docoper->save("Docs_oper", $renglon["docs_operid"]);
			}
		break;
		case "Entre":
			echo "Entrega de equipo...<br>";
			//$entrega->retrieve_entity_info($renglon["crmid"], "Entregas");
			//$entrega->procesar();
		break;
		case "Recol":
			echo "Recolección de equipo...<br>";
			//$recoleccion->retrieve_entity_info($renglon["crmid"], "Recolecciones");
			//$recoleccion->procesar();
		break;
		case "Cambi":
			echo "Cambio de equipo...<br>";
			//$cambio->retrieve_entity_info($renglon["crmid"], "Cambios");
			//$cambio->procesar();
		break;
	}
}
***************************************************/
?>
